/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;

public class HoodieColumnStatsIndexUtils {
    @VisibleForTesting
    public static void updateColsToIndex(HoodieTable dataTable, HoodieWriteConfig config, HoodieCommitMetadata commitMetadata, Functions.Function2<HoodieTableMetaClient, List<String>, Void> updateColSatsFunc) {
        if (config.getMetadataConfig().isColumnStatsIndexEnabled()) {
            dataTable.getMetaClient().reloadTableConfig();
            if (dataTable.getMetaClient().getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                try {
                    HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setStorage(dataTable.getStorage()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath((StoragePath)dataTable.getMetaClient().getBasePath())).build();
                    HoodieInstant latestInstant = (HoodieInstant)mdtMetaClient.getActiveTimeline().getWriteTimeline().filterCompletedInstants().lastInstant().get();
                    HoodieCommitMetadata mdtCommitMetadata = (HoodieCommitMetadata)mdtMetaClient.getTimelineLayout().getCommitMetadataSerDe().deserialize(latestInstant, (byte[])mdtMetaClient.getActiveTimeline().getInstantDetails(latestInstant).get(), HoodieCommitMetadata.class);
                    if (mdtCommitMetadata.getPartitionToWriteStats().containsKey(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                        ArrayList columnsToIndex = new ArrayList(HoodieTableMetadataUtil.getColumnsToIndex((HoodieCommitMetadata)commitMetadata, (HoodieTableMetaClient)dataTable.getMetaClient(), (HoodieMetadataConfig)config.getMetadataConfig(), (Option)Option.of((Object)config.getRecordMerger().getRecordType())).keySet());
                        updateColSatsFunc.apply((Object)dataTable.getMetaClient(), columnsToIndex);
                    }
                }
                catch (Exception e) {
                    throw new HoodieException("Updating data table config to latest set of columns indexed with col stats failed ", (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    public static void deleteColumnStatsIndexDefinition(HoodieTableMetaClient dataTableMetaClient) {
        dataTableMetaClient.deleteIndexDefinition("column_stats");
    }
}

