/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class CustomAvroKeyGenerator
extends BaseKeyGenerator {
    public static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    private final List<BaseKeyGenerator> partitionKeyGenerators;
    private final BaseKeyGenerator recordKeyGenerator;

    public CustomAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = (List)Option.ofNullable((Object)props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(",")).map(String::trim).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).collect(Collectors.toList());
        this.recordKeyGenerator = this.getRecordKeyFieldNames().size() == 1 ? new SimpleAvroKeyGenerator(this.config) : new ComplexAvroKeyGenerator(this.config);
        this.partitionKeyGenerators = CustomAvroKeyGenerator.getPartitionKeyGenerators(this.partitionPathFields, this.config);
    }

    private static List<BaseKeyGenerator> getPartitionKeyGenerators(List<String> partitionPathFields, TypedProperties config) {
        if (partitionPathFields.size() == 1 && partitionPathFields.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        return partitionPathFields.stream().map(field -> {
            Pair<String, Option<PartitionKeyType>> partitionAndType = CustomAvroKeyGenerator.getPartitionFieldAndKeyType(field);
            if (((Option)partitionAndType.getRight()).isEmpty()) {
                throw CustomAvroKeyGenerator.getPartitionPathFormatException();
            }
            PartitionKeyType keyType = (PartitionKeyType)((Object)((Object)((Option)partitionAndType.getRight()).get()));
            String partitionPathField = (String)partitionAndType.getLeft();
            switch (keyType) {
                case SIMPLE: {
                    return new SimpleAvroKeyGenerator(config, partitionPathField);
                }
                case TIMESTAMP: {
                    try {
                        return new TimestampBasedAvroKeyGenerator(config, partitionPathField);
                    }
                    catch (IOException e) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", e);
                    }
                }
            }
            throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + (Object)((Object)keyType));
        }).collect(Collectors.toList());
    }

    public static List<PartitionKeyType> getPartitionTypes(HoodieTableConfig tableConfig) {
        List partitionPathFields = (List)HoodieTableConfig.getPartitionFieldsForKeyGenerator((HoodieConfig)tableConfig).orElse(Collections.emptyList());
        if (partitionPathFields.size() == 1 && ((String)partitionPathFields.get(0)).isEmpty()) {
            return Collections.emptyList();
        }
        return partitionPathFields.stream().map(field -> (Option)CustomAvroKeyGenerator.getPartitionFieldAndKeyType(field).getRight()).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    public static Option<List<String>> getTimestampFields(HoodieTableConfig tableConfig) {
        List partitionPathFields = (List)HoodieTableConfig.getPartitionFieldsForKeyGenerator((HoodieConfig)tableConfig).orElse(Collections.emptyList());
        if (partitionPathFields.isEmpty() || partitionPathFields.size() == 1 && ((String)partitionPathFields.get(0)).isEmpty()) {
            return Option.of(Collections.emptyList());
        }
        if (((Option)CustomAvroKeyGenerator.getPartitionFieldAndKeyType((String)partitionPathFields.get(0)).getRight()).isEmpty()) {
            return Option.empty();
        }
        return Option.of(partitionPathFields.stream().map(CustomAvroKeyGenerator::getPartitionFieldAndKeyType).filter(fieldAndKeyType -> ((Option)fieldAndKeyType.getRight()).isPresent() && ((PartitionKeyType)((Object)((Object)((Option)fieldAndKeyType.getRight()).get()))).equals((Object)PartitionKeyType.TIMESTAMP)).map(Pair::getLeft).collect(Collectors.toList()));
    }

    public static Pair<String, Option<PartitionKeyType>> getPartitionFieldAndKeyType(String field) {
        String[] fieldWithType = field.split(":");
        if (fieldWithType.length == 2) {
            return Pair.of((Object)fieldWithType[0], (Object)Option.of((Object)((Object)PartitionKeyType.valueOf(fieldWithType[1].toUpperCase()))));
        }
        return Pair.of((Object)fieldWithType[0], (Object)Option.empty());
    }

    public String getPartitionPath(GenericRecord record) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        if (this.partitionKeyGenerators.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < this.partitionKeyGenerators.size(); ++i) {
            BaseKeyGenerator partitionKeyGenerator = this.partitionKeyGenerators.get(i);
            partitionPath.append(partitionKeyGenerator.getPartitionPath(record));
            if (i == this.partitionKeyGenerators.size() - 1) continue;
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        return partitionPath.toString();
    }

    public String getRecordKey(GenericRecord record) {
        this.validateRecordKeyFields();
        return this.recordKeyGenerator.getRecordKey(record);
    }

    private void validateRecordKeyFields() {
        if (this.getRecordKeyFieldNames() == null || this.getRecordKeyFieldNames().isEmpty()) {
            throw new HoodieKeyException("Unable to find field names for record key in cfg");
        }
    }

    static HoodieKeyGeneratorException getPartitionPathFormatException() {
        return new HoodieKeyGeneratorException("Unable to find field names for partition path in proper format. Please specify the partition field names in format `field1:type1,field2:type2`. Example: `city:simple,ts:timestamp`");
    }

    public String getDefaultPartitionPathSeparator() {
        return DEFAULT_PARTITION_PATH_SEPARATOR;
    }

    public static enum PartitionKeyType {
        SIMPLE,
        TIMESTAMP;

    }
}

