/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.util.List;
import java.util.Properties;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.HoodieCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunCompactionActionExecutor<T>
extends BaseActionExecutor<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, HoodieWriteMetadata<HoodieData<WriteStatus>>> {
    private static final Logger LOG = LoggerFactory.getLogger(RunCompactionActionExecutor.class);
    private final HoodieCompactor compactor;
    private final HoodieCompactionHandler compactionHandler;
    private WriteOperationType operationType;
    private final HoodieMetrics metrics;

    public RunCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieCompactor compactor, HoodieCompactionHandler compactionHandler, WriteOperationType operationType) {
        super(context, config, table, instantTime);
        this.compactor = compactor;
        this.compactionHandler = compactionHandler;
        this.operationType = operationType;
        ValidationUtils.checkArgument((operationType == WriteOperationType.COMPACT || operationType == WriteOperationType.LOG_COMPACT ? 1 : 0) != 0, (String)"Only COMPACT and LOG_COMPACT is supported");
        this.metrics = new HoodieMetrics(config, table.getStorage());
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute() {
        LOG.info("Compaction requested. Instant time: {}.", (Object)this.instantTime);
        this.metrics.emitCompactionRequested();
        HoodieTimeline pendingMajorOrMinorCompactionTimeline = WriteOperationType.COMPACT.equals((Object)this.operationType) ? this.table.getActiveTimeline().filterPendingCompactionTimeline() : this.table.getActiveTimeline().filterPendingLogCompactionTimeline();
        this.compactor.preCompact(this.table, pendingMajorOrMinorCompactionTimeline, this.operationType, this.instantTime);
        HoodieWriteMetadata<HoodieData<WriteStatus>> compactionMetadata = new HoodieWriteMetadata<HoodieData<WriteStatus>>();
        try {
            HoodieCompactionPlan compactionPlan = this.operationType.equals((Object)WriteOperationType.COMPACT) ? CompactionUtils.getCompactionPlan((HoodieTableMetaClient)this.table.getMetaClient(), (String)this.instantTime) : CompactionUtils.getLogCompactionPlan((HoodieTableMetaClient)this.table.getMetaClient(), (String)this.instantTime);
            HoodieWriteConfig configCopy = this.config;
            Pair schemaPair = InternalSchemaCache.getInternalSchemaAndAvroSchemaForClusteringAndCompaction((HoodieTableMetaClient)this.table.getMetaClient(), (String)this.instantTime);
            if (((Option)schemaPair.getLeft()).isPresent() && ((Option)schemaPair.getRight()).isPresent()) {
                configCopy = HoodieWriteConfig.newBuilder().withProperties((Properties)this.config.getProps()).build();
                configCopy.setInternalSchemaString((String)((Option)schemaPair.getLeft()).get());
                configCopy.setSchema((String)((Option)schemaPair.getRight()).get());
            }
            HoodieData<WriteStatus> statuses = this.compactor.compact(this.context, this.operationType, compactionPlan, this.table, configCopy, this.instantTime, this.compactionHandler);
            this.compactor.maybePersist(statuses, this.context, this.config, this.instantTime);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Preparing compaction metadata: " + this.config.getTableName());
            List updateStatusMap = statuses.map(WriteStatus::getStat).collectAsList();
            HoodieCommitMetadata metadata = new HoodieCommitMetadata(true);
            for (HoodieWriteStat stat : updateStatusMap) {
                metadata.addWriteStat(stat.getPartitionPath(), stat);
            }
            metadata.addMetadata("schema", this.config.getSchema());
            if (((Option)schemaPair.getLeft()).isPresent()) {
                metadata.addMetadata("latest_schema", (String)((Option)schemaPair.getLeft()).get());
                metadata.addMetadata("schema", (String)((Option)schemaPair.getRight()).get());
            }
            metadata.setOperationType(this.operationType);
            compactionMetadata.setWriteStatuses(statuses);
            compactionMetadata.setCommitted(false);
            compactionMetadata.setCommitMetadata((Option<HoodieCommitMetadata>)Option.of((Object)metadata));
            compactionMetadata.setWriteStats(updateStatusMap);
        }
        catch (Exception e) {
            throw new HoodieCompactionException("Could not compact " + this.config.getBasePath(), e);
        }
        LOG.info("Compaction completed. Instant time: {}.", (Object)this.instantTime);
        this.metrics.emitCompactionCompleted();
        return compactionMetadata;
    }
}

