/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.action.rollback.SerializableHoodieRollbackRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RollbackUtils.class);

    public static HoodieRollbackPlan getRollbackPlan(HoodieTableMetaClient metaClient, HoodieInstant rollbackInstant) throws IOException {
        HoodieInstant requested = metaClient.getInstantGenerator().getRollbackRequestedInstant(rollbackInstant);
        return (HoodieRollbackPlan)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])metaClient.getActiveTimeline().readRollbackInfoAsBytes(requested).get()), HoodieRollbackPlan.class);
    }

    static Map<HoodieLogBlock.HeaderMetadataType, String> generateHeader(String instantToRollback, String rollbackInstantTime) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, rollbackInstantTime);
        header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, instantToRollback);
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK.ordinal()));
        return header;
    }

    static HoodieRollbackStat mergeRollbackStat(HoodieRollbackStat stat1, HoodieRollbackStat stat2) {
        ValidationUtils.checkArgument((boolean)stat1.getPartitionPath().equals(stat2.getPartitionPath()));
        ArrayList successDeleteFiles = new ArrayList();
        ArrayList failedDeleteFiles = new ArrayList();
        HashMap commandBlocksCount = new HashMap();
        HashMap logFilesFromFailedCommit = new HashMap();
        Option.ofNullable((Object)stat1.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable((Object)stat2.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable((Object)stat1.getLogFilesFromFailedCommit()).ifPresent(logFilesFromFailedCommit::putAll);
        Option.ofNullable((Object)stat2.getLogFilesFromFailedCommit()).ifPresent(logFilesFromFailedCommit::putAll);
        return new HoodieRollbackStat(stat1.getPartitionPath(), successDeleteFiles, failedDeleteFiles, commandBlocksCount, logFilesFromFailedCommit);
    }

    static List<HoodieRollbackRequest> groupRollbackRequestsBasedOnFileGroup(List<HoodieRollbackRequest> rollbackRequests) {
        return RollbackUtils.groupRollbackRequestsBasedOnFileGroup(rollbackRequests, e -> e, HoodieRollbackRequest::getPartitionPath, HoodieRollbackRequest::getFileId, HoodieRollbackRequest::getLatestBaseInstant, HoodieRollbackRequest::getLogBlocksToBeDeleted, HoodieRollbackRequest::getFilesToBeDeleted);
    }

    static List<SerializableHoodieRollbackRequest> groupSerializableRollbackRequestsBasedOnFileGroup(List<SerializableHoodieRollbackRequest> rollbackRequests) {
        return RollbackUtils.groupRollbackRequestsBasedOnFileGroup(rollbackRequests, SerializableHoodieRollbackRequest::new, SerializableHoodieRollbackRequest::getPartitionPath, SerializableHoodieRollbackRequest::getFileId, SerializableHoodieRollbackRequest::getLatestBaseInstant, SerializableHoodieRollbackRequest::getLogBlocksToBeDeleted, SerializableHoodieRollbackRequest::getFilesToBeDeleted);
    }

    static <T> List<T> groupRollbackRequestsBasedOnFileGroup(List<T> rollbackRequests, Function<HoodieRollbackRequest, T> createRequestFunc, Function<T, String> getPartitionPathFunc, Function<T, String> getFileIdFunc, Function<T, String> getLatestBaseInstant, Function<T, Map<String, Long>> getLogBlocksToBeDeletedFunc, Function<T, List<String>> getFilesToBeDeletedFunc) {
        HashMap requestMap = new HashMap();
        rollbackRequests.forEach(rollbackRequest -> {
            String partitionPath = (String)getPartitionPathFunc.apply(rollbackRequest);
            Pair partitionFileIdPair = Pair.of((Object)(partitionPath != null ? partitionPath : ""), getFileIdFunc.apply(rollbackRequest));
            requestMap.computeIfAbsent(partitionFileIdPair, k -> new ArrayList()).add(rollbackRequest);
        });
        return requestMap.entrySet().stream().flatMap(entry -> {
            List rollbackRequestList = (List)entry.getValue();
            ArrayList newRequestList = new ArrayList();
            HashMap logBlocksToBeDeleted = new HashMap();
            rollbackRequestList.forEach(rollbackRequest -> {
                if (!((Map)getLogBlocksToBeDeletedFunc.apply(rollbackRequest)).isEmpty()) {
                    if (!((List)getFilesToBeDeletedFunc.apply(rollbackRequest)).isEmpty()) {
                        LOG.warn("Only one of the following should be non-empty. Adding the files to be deleted to a new rollback request. FilesToBeDeleted: {}, LogBlocksToBeDeleted: {}", getFilesToBeDeletedFunc.apply(rollbackRequest), getLogBlocksToBeDeletedFunc.apply(rollbackRequest));
                        String partitionPath = (String)getPartitionPathFunc.apply(rollbackRequest);
                        newRequestList.add(createRequestFunc.apply(HoodieRollbackRequest.newBuilder().setPartitionPath(partitionPath != null ? partitionPath : "").setFileId((String)getFileIdFunc.apply(rollbackRequest)).setLatestBaseInstant((String)getLatestBaseInstant.apply(rollbackRequest)).setFilesToBeDeleted((List)getFilesToBeDeletedFunc.apply(rollbackRequest)).setLogBlocksToBeDeleted(Collections.emptyMap()).build()));
                    }
                    logBlocksToBeDeleted.putAll((Map)getLogBlocksToBeDeletedFunc.apply(rollbackRequest));
                } else {
                    newRequestList.add(rollbackRequest);
                }
            });
            if (!logBlocksToBeDeleted.isEmpty() && !rollbackRequestList.isEmpty()) {
                newRequestList.add(createRequestFunc.apply(HoodieRollbackRequest.newBuilder().setPartitionPath((String)((Pair)entry.getKey()).getKey()).setFileId((String)((Pair)entry.getKey()).getValue()).setLatestBaseInstant((String)getLatestBaseInstant.apply(rollbackRequestList.get(0))).setFilesToBeDeleted(Collections.emptyList()).setLogBlocksToBeDeleted(logBlocksToBeDeleted).build()));
            }
            return newRequestList.stream();
        }).collect(Collectors.toList());
    }
}

