/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.PreferWriterConflictResolutionStrategy;
import org.apache.hudi.client.transaction.TestConflictResolutionStrategyUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPreferWriterConflictResolutionStrategy
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompactionRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)candidateInstants.size());
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        Thread.sleep(1000L);
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        Assertions.assertEquals((Object)newInstantTime, (Object)((HoodieInstant)candidateInstants.get(0)).requestedTime());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompactionRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", newInstantTime));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        Assertions.assertEquals((Object)currentWriterInstant, (Object)((HoodieInstant)candidateInstants.get(0)).requestedTime());
    }

    @Test
    public void testConcurrentWriteAndCompactionScheduledEarlier() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)candidateInstants.size());
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCluster() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createClusterRequested(newInstantTime, this.metaClient);
        TestConflictResolutionStrategyUtil.createClusterInflight(newInstantTime, WriteOperationType.CLUSTER, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)candidateInstants.size());
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCluster() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Thread.sleep(1000L);
        String replaceWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCluster(replaceWriterInstant, WriteOperationType.CLUSTER, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        Assertions.assertEquals((Object)replaceWriterInstant, (Object)((HoodieInstant)candidateInstants.get(0)).requestedTime());
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulReplace() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Thread.sleep(1000L);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createReplace(newInstantTime, WriteOperationType.INSERT_OVERWRITE, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        PreferWriterConflictResolutionStrategy strategy = new PreferWriterConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }
}

