/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.models;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hudi.client.transaction.lock.models.StorageLockData;
import org.apache.hudi.client.transaction.lock.models.StorageLockFile;
import org.apache.hudi.exception.HoodieIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class StorageLockClientFileTest {
    private static final String JSON_DATA = "{\"expired\":false,\"validUntil\":1700000000000,\"owner\":\"testOwner\"}";
    private static final String JSON_DATA_EXTRA_FIELD = "{\"expired\":true,\"validUntil\":1600000000000,\"owner\":\"otherOwner\",\"state\":\"active\"}";
    private static final String INVALID_JSON = "{\"invalidField\":123}";
    private static final String VERSION_ID = "testVersionId";
    private InputStream validJsonStream;
    private InputStream extraFieldValidJsonStream;
    private InputStream invalidJsonStream;

    @BeforeEach
    void setup() {
        this.validJsonStream = new ByteArrayInputStream(JSON_DATA.getBytes());
        this.extraFieldValidJsonStream = new ByteArrayInputStream(JSON_DATA_EXTRA_FIELD.getBytes());
        this.invalidJsonStream = new ByteArrayInputStream(INVALID_JSON.getBytes());
    }

    @Test
    void testCreateValidInputStream() {
        StorageLockFile file = StorageLockFile.createFromStream((InputStream)this.validJsonStream, (String)VERSION_ID);
        Assertions.assertEquals((long)1700000000000L, (long)file.getValidUntilMs());
        Assertions.assertEquals((Object)"testOwner", (Object)file.getOwner());
        Assertions.assertEquals((Object)VERSION_ID, (Object)file.getVersionId());
        Assertions.assertFalse((boolean)file.isExpired());
    }

    @Test
    void testCreateValidInputStreamExtraField() {
        StorageLockFile file = StorageLockFile.createFromStream((InputStream)this.extraFieldValidJsonStream, (String)VERSION_ID);
        Assertions.assertEquals((long)1600000000000L, (long)file.getValidUntilMs());
        Assertions.assertEquals((Object)"otherOwner", (Object)file.getOwner());
        Assertions.assertEquals((Object)VERSION_ID, (Object)file.getVersionId());
        Assertions.assertTrue((boolean)file.isExpired());
    }

    @Test
    void testCreateInvalidInputStreamFromMock() throws IOException {
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Simulated IOException")}).when((Object)mockInputStream)).read();
        HoodieIOException exception = (HoodieIOException)Assertions.assertThrows(HoodieIOException.class, () -> StorageLockFile.createFromStream((InputStream)mockInputStream, (String)"versionId"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to deserialize"));
    }

    @Test
    void testCreateInvalidInputStreamFromBadData() {
        HoodieIOException exception = (HoodieIOException)Assertions.assertThrows(HoodieIOException.class, () -> StorageLockFile.createFromStream((InputStream)this.invalidJsonStream, (String)VERSION_ID));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to deserialize"));
    }

    @Test
    void testCreateNullData() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new StorageLockFile(null, VERSION_ID));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Data must not be null"));
    }

    @Test
    void testCreateNullVersionId() {
        StorageLockData data = new StorageLockData(true, 1700000000000L, "testOwner");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new StorageLockFile(data, null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("VersionId must not be null or empty."));
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new StorageLockFile(data, ""));
        Assertions.assertTrue((boolean)exception.getMessage().contains("VersionId must not be null or empty."));
    }

    @Test
    void testToJsonStreamValidData() {
        StorageLockFile file = StorageLockFile.createFromStream((InputStream)this.validJsonStream, (String)VERSION_ID);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        file.writeToStream((OutputStream)outputStream);
        String outputJson = new String(outputStream.toByteArray());
        Assertions.assertTrue((boolean)outputJson.contains("\"expired\":false"));
        Assertions.assertTrue((boolean)outputJson.contains("\"validUntil\":1700000000000"));
        Assertions.assertTrue((boolean)outputJson.contains("\"owner\":\"testOwner\""));
    }

    @Test
    void testToJsonStreamErrorHandling() throws IOException {
        OutputStream mockOutputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Simulated IOException")}).when((Object)mockOutputStream)).write((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        StorageLockFile file = new StorageLockFile(new StorageLockData(true, System.currentTimeMillis() + 1000L, "testOwner"), VERSION_ID);
        HoodieIOException exception = (HoodieIOException)Assertions.assertThrows(HoodieIOException.class, () -> file.writeToStream(mockOutputStream));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Error writing object to JSON"));
    }

    @Test
    void testToByteArrayValidData() {
        StorageLockData data = new StorageLockData(false, 1700000000000L, "testOwner");
        String outputJson = new String(StorageLockFile.toByteArray((StorageLockData)data));
        Assertions.assertTrue((boolean)outputJson.contains("\"expired\":false"));
        Assertions.assertTrue((boolean)outputJson.contains("\"validUntil\":1700000000000"));
        Assertions.assertTrue((boolean)outputJson.contains("\"owner\":\"testOwner\""));
    }

    @Test
    void testIsExpired() {
        StorageLockData data = new StorageLockData(true, System.currentTimeMillis() - 1000L, "testOwner");
        StorageLockFile file = new StorageLockFile(data, VERSION_ID);
        Assertions.assertTrue((boolean)file.isExpired());
    }

    @Test
    void testGetVersionId() {
        StorageLockData data = new StorageLockData(false, 1700000000000L, "testOwner");
        StorageLockFile file = new StorageLockFile(data, VERSION_ID);
        Assertions.assertEquals((Object)VERSION_ID, (Object)file.getVersionId());
    }
}

