/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import junit.framework.TestCase;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Test;

public class TestComplexAvroKeyGenerator {
    @Test
    public void testSingleValueKeyGenerator() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "timestamp");
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)1);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)1);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = record.get("_row_key").toString();
        String partitionPath = record.get("timestamp").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
    }

    @Test
    public void testMultipleValueKeyGenerator() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "rider,driver");
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)2);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = record.get("rider").toString() + "/" + record.get("driver").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
    }

    @Test
    public void testMultipleValueKeyGeneratorNonPartitioned() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "");
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)0);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = "";
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
    }
}

