/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import java.util.UUID;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieGraphiteMetrics {
    @Mock
    HoodieWriteConfig writeConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;

    @AfterEach
    void shutdownMetrics() {
        this.metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.GRAPHITE);
        Mockito.when((Object)this.metricsConfig.getGraphiteServerHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.metricsConfig.getGraphiteServerPort()).thenReturn((Object)NetworkTestUtils.nextFreePort());
        Mockito.when((Object)this.metricsConfig.getGraphiteReportPeriodSeconds()).thenReturn((Object)30);
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
        this.metrics = this.hoodieMetrics.getMetrics();
        this.metrics.registerGauge("graphite_metric", 123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)this.metrics.getRegistry().getGauges().get("graphite_metric")).getValue().toString());
    }
}

