/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import java.util.UUID;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestSlf4jMetrics {
    @Mock
    HoodieWriteConfig writeConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;

    @BeforeEach
    public void start() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.SLF4J);
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Mockito.when((Object)this.metricsConfig.getMetricReporterMetricsNamePrefix()).thenReturn((Object)"hoodie");
        this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
        this.metrics = this.hoodieMetrics.getMetrics();
    }

    @AfterEach
    public void stop() {
        this.metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        this.metrics.registerGauge("metric1", 123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)this.metrics.getRegistry().getGauges().get("metric1")).getValue().toString());
        this.metrics.flush();
    }
}

