/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.strategy.PartitionAwareClusteringPlanStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class TestPartitionAwareClusteringPlanStrategy {
    @Mock
    HoodieTable table;
    @Mock
    HoodieEngineContext context;
    HoodieWriteConfig hoodieWriteConfig;

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("hoodie.clustering.plan.strategy.partition.regex.pattern", "2021072.*");
        this.hoodieWriteConfig = HoodieWriteConfig.newBuilder().withPath("dummy_Table_Path").withClusteringConfig(HoodieClusteringConfig.newBuilder().fromProperties(props).build()).build();
    }

    @Test
    public void testFilterPartitionPaths() {
        DummyPartitionAwareClusteringPlanStrategy strategyTestRegexPattern = new DummyPartitionAwareClusteringPlanStrategy(this.table, this.context, this.hoodieWriteConfig);
        ArrayList<String> fakeTimeBasedPartitionsPath = new ArrayList<String>();
        fakeTimeBasedPartitionsPath.add("20210718");
        fakeTimeBasedPartitionsPath.add("20210715");
        fakeTimeBasedPartitionsPath.add("20210723");
        fakeTimeBasedPartitionsPath.add("20210716");
        fakeTimeBasedPartitionsPath.add("20210719");
        fakeTimeBasedPartitionsPath.add("20210721");
        List list = strategyTestRegexPattern.getRegexPatternMatchedPartitions(this.hoodieWriteConfig, fakeTimeBasedPartitionsPath);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("20210721"));
        Assertions.assertTrue((boolean)list.contains("20210723"));
    }

    class DummyPartitionAwareClusteringPlanStrategy
    extends PartitionAwareClusteringPlanStrategy {
        public DummyPartitionAwareClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
            super(table, engineContext, writeConfig);
        }

        protected Map<String, String> getStrategyParams() {
            return null;
        }
    }
}

