/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.index.AbstractIndexingCatchupTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestIndexingCatchupTask {
    @Mock
    private HoodieTableMetadataWriter metadataWriter;
    @Mock
    private HoodieTableMetaClient metaClient;
    @Mock
    private HoodieTableMetaClient metadataMetaClient;
    @Mock
    private TransactionManager transactionManager;
    @Mock
    private HoodieEngineContext engineContext;
    @Mock
    private HoodieTable table;
    @Mock
    private HoodieHeartbeatClient heartbeatClient;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testTaskSuccessful() throws IOException {
        List<HoodieInstant> instants = Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "001"));
        HashSet<String> metadataCompletedInstants = new HashSet<String>();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/some/path").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)writeConfig);
        Mockito.when((Object)this.heartbeatClient.isHeartbeatExpired("002")).thenReturn((Object)false);
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, instants, metadataCompletedInstants, this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext, this.table, this.heartbeatClient);
        task.run();
        Assertions.assertEquals((Object)"001", (Object)task.currentCaughtupInstant);
    }

    @Test
    public void testTaskInterrupted() throws IOException {
        HoodieInstant neverCompletedInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "001");
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        HoodieActiveTimeline filteredTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        HoodieActiveTimeline furtherFilteredTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.metaClient.reloadActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.filterCompletedInstants()).thenReturn((Object)filteredTimeline);
        Mockito.when((Object)filteredTimeline.filter((Predicate)ArgumentMatchers.any())).thenReturn((Object)furtherFilteredTimeline);
        AtomicInteger callCount = new AtomicInteger(0);
        Mockito.when((Object)furtherFilteredTimeline.firstInstant()).thenAnswer(invocation -> {
            if (callCount.incrementAndGet() > 3) {
                throw new InterruptedException("Simulated interruption");
            }
            return Option.empty();
        });
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/some/path").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)writeConfig);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)storage);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)new StoragePath("/some/path"));
        Mockito.when((Object)storage.exists((StoragePath)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.heartbeatClient.isHeartbeatExpired("001")).thenReturn((Object)false);
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, Collections.singletonList(neverCompletedInstant), new HashSet<String>(), this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext, this.table, this.heartbeatClient);
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                task.awaitInstantCaughtUp(neverCompletedInstant);
            }
            catch (HoodieIndexException e) {
                latch.countDown();
            }
        });
        thread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Should have thrown HoodieIndexException and not interrupted exception. This means latch count down was not called.");
        }
    }

    @Test
    public void testHeartbeatExpired() throws IOException {
        HoodieInstant expiredInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "002");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/some/path").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)writeConfig);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)storage);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)new StoragePath("/some/path"));
        Mockito.when((Object)storage.exists((StoragePath)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.heartbeatClient.isHeartbeatExpired("002")).thenReturn((Object)true);
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, Collections.singletonList(expiredInstant), new HashSet<String>(), this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext, this.table, this.heartbeatClient);
        Assertions.assertTrue((boolean)task.awaitInstantCaughtUp(expiredInstant), (String)"Expected null as the instant's heartbeat has expired.");
    }

    @Test
    public void testNoHeartbeat() throws IOException {
        HoodieInstant pendingInstantWithNoHeartbeat = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "002");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/some/path").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)writeConfig);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)storage);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)new StoragePath("/some/path"));
        Mockito.when((Object)storage.exists((StoragePath)ArgumentMatchers.any())).thenReturn((Object)false);
        DummyIndexingCatchupTask task = new DummyIndexingCatchupTask(this.metadataWriter, Collections.singletonList(pendingInstantWithNoHeartbeat), new HashSet<String>(), this.metaClient, this.metadataMetaClient, this.transactionManager, "001", this.engineContext, this.table, this.heartbeatClient);
        Assertions.assertTrue((boolean)task.awaitInstantCaughtUp(pendingInstantWithNoHeartbeat), (String)"Expected null as the instant's heartbeat has expired.");
    }

    static class DummyIndexingCatchupTask
    extends AbstractIndexingCatchupTask {
        public DummyIndexingCatchupTask(HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTableMetaClient metaClient, HoodieTableMetaClient metadataMetaClient, TransactionManager transactionManager, String currentCaughtupInstant, HoodieEngineContext engineContext, HoodieTable table, HoodieHeartbeatClient heartbeatClient) {
            super(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, transactionManager, currentCaughtupInstant, engineContext, table, heartbeatClient);
        }

        public void run() {
        }

        public void updateIndexForWriteAction(HoodieInstant instant) {
        }
    }
}

