/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.action.rollback.SerializableHoodieRollbackRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestRollbackUtils {
    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,false"})
    void testGroupRollbackRequestsBasedOnFileGroup(boolean nonPartitioned, boolean useNullPartitionPath) {
        String partition1;
        ArrayList<HoodieRollbackRequest> inputList = new ArrayList<HoodieRollbackRequest>();
        Object object = nonPartitioned ? (useNullPartitionPath ? null : "") : (partition1 = "partition1");
        String partition2 = nonPartitioned ? (useNullPartitionPath ? null : "") : "partition2";
        String expectedPartition2 = nonPartitioned ? "" : "partition2";
        String baseFileName1 = "basefile1";
        String baseFileName2 = "basefile2";
        String baseFileName3 = "basefile3";
        String baseFileName4 = "basefile4";
        String baseInstantTime1 = "003";
        String baseFileId1 = UUID.randomUUID().toString();
        String baseFileId2 = UUID.randomUUID().toString();
        String baseFileId3 = UUID.randomUUID().toString();
        String logFileId1 = UUID.randomUUID().toString();
        int numLogFiles1 = 10;
        String baseInstantTime2 = "002";
        String logFileId2 = UUID.randomUUID().toString();
        int numLogFiles2 = 5;
        String baseInstantTime3 = "001";
        inputList.add(new HoodieRollbackRequest(partition1, baseFileId1, baseInstantTime1, Collections.emptyList(), Collections.emptyMap()));
        inputList.add(new HoodieRollbackRequest(partition2, baseFileId2, baseInstantTime1, Collections.emptyList(), Collections.emptyMap()));
        inputList.add(new HoodieRollbackRequest(partition1, baseFileId1, baseInstantTime1, Collections.singletonList(baseFileName1), Collections.emptyMap()));
        inputList.add(new HoodieRollbackRequest(partition2, baseFileId2, baseInstantTime1, Collections.singletonList(baseFileName2), Collections.emptyMap()));
        inputList.add(new HoodieRollbackRequest(partition2, baseFileId3, baseInstantTime1, Collections.singletonList(baseFileName3), Collections.emptyMap()));
        ArrayList<HoodieRollbackRequest> expected = new ArrayList<HoodieRollbackRequest>(inputList);
        HashMap logFileMap1 = new HashMap();
        HashMap<String, Long> logFileMap2 = new HashMap<String, Long>();
        IntStream.rangeClosed(2, numLogFiles1 + 1).forEach(i -> {
            inputList.add(new HoodieRollbackRequest(partition2, logFileId1, baseInstantTime2, Collections.emptyList(), Collections.singletonMap(logFileId1 + "." + i, (long)i * 2L)));
            logFileMap1.put(logFileId1 + "." + i, (long)i * 2L);
        });
        IntStream.rangeClosed(2, numLogFiles2).forEach(i -> {
            inputList.add(new HoodieRollbackRequest(partition2, logFileId2, baseInstantTime3, Collections.emptyList(), Collections.singletonMap(logFileId2 + "." + i, (long)i * 3L)));
            logFileMap2.put(logFileId2 + "." + i, (long)i * 3L);
        });
        inputList.add(new HoodieRollbackRequest(partition2, logFileId2, baseInstantTime3, Collections.singletonList(baseFileName4), Collections.singletonMap(logFileId2 + "." + (numLogFiles2 + 1), (long)(numLogFiles2 + 1) * 3L)));
        logFileMap2.put(logFileId2 + "." + (numLogFiles2 + 1), (long)(numLogFiles2 + 1) * 3L);
        expected.add(new HoodieRollbackRequest(expectedPartition2, logFileId1, baseInstantTime2, Collections.emptyList(), logFileMap1));
        expected.add(new HoodieRollbackRequest(expectedPartition2, logFileId2, baseInstantTime3, Collections.emptyList(), logFileMap2));
        expected.add(new HoodieRollbackRequest(expectedPartition2, logFileId2, baseInstantTime3, Collections.singletonList(baseFileName4), Collections.emptyMap()));
        Assertions.assertEquals((int)(5 + numLogFiles1 + numLogFiles2), (int)inputList.size());
        List actual = RollbackUtils.groupRollbackRequestsBasedOnFileGroup(inputList);
        List actualSerializable = RollbackUtils.groupSerializableRollbackRequestsBasedOnFileGroup(inputList.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList()));
        TestRollbackUtils.assertRollbackRequestListEquals(expected, actual);
        TestRollbackUtils.assertSerializableRollbackRequestListEquals(expected.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList()), actualSerializable);
    }

    public static void assertRollbackRequestListEquals(List<HoodieRollbackRequest> expected, List<HoodieRollbackRequest> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        TestRollbackUtils.assertSerializableRollbackRequestListEquals(expected.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList()), actual.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList()));
    }

    public static void assertSerializableRollbackRequestListEquals(List<SerializableHoodieRollbackRequest> expected, List<SerializableHoodieRollbackRequest> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        List<SerializableHoodieRollbackRequest> sortedExpected = TestRollbackUtils.getSortedRollbackRequests(expected);
        List<SerializableHoodieRollbackRequest> sortedActual = TestRollbackUtils.getSortedRollbackRequests(actual);
        for (int i = 0; i < sortedExpected.size(); ++i) {
            SerializableHoodieRollbackRequest expectedRequest = sortedExpected.get(i);
            SerializableHoodieRollbackRequest actualRequest = sortedActual.get(i);
            Assertions.assertEquals((Object)expectedRequest.getPartitionPath(), (Object)actualRequest.getPartitionPath());
            Assertions.assertEquals((Object)expectedRequest.getFileId(), (Object)actualRequest.getFileId());
            Assertions.assertEquals((Object)expectedRequest.getLatestBaseInstant(), (Object)actualRequest.getLatestBaseInstant());
            Assertions.assertEquals(expectedRequest.getFilesToBeDeleted().stream().sorted().collect(Collectors.toList()), actualRequest.getFilesToBeDeleted().stream().sorted().collect(Collectors.toList()));
            Map expectedLogFileMap = expectedRequest.getLogBlocksToBeDeleted();
            Map actualLogFileMap = actualRequest.getLogBlocksToBeDeleted();
            Assertions.assertEquals((int)expectedLogFileMap.size(), (int)actualLogFileMap.size());
            for (Map.Entry entry : expectedLogFileMap.entrySet()) {
                Assertions.assertTrue((boolean)actualLogFileMap.containsKey(entry.getKey()));
                Assertions.assertEquals((Long)((Long)entry.getValue()), (Long)((Long)actualLogFileMap.get(entry.getKey())));
            }
        }
    }

    private static List<SerializableHoodieRollbackRequest> getSortedRollbackRequests(List<SerializableHoodieRollbackRequest> rollbackRequestList) {
        return rollbackRequestList.stream().sorted(Comparator.comparing(e -> Triple.of((Object)e.getFileId(), (Object)e.getLogBlocksToBeDeleted().size(), (Object)(!e.getFilesToBeDeleted().isEmpty() ? (String)e.getFilesToBeDeleted().get(0) : (!e.getLogBlocksToBeDeleted().isEmpty() ? (String)e.getLogBlocksToBeDeleted().keySet().stream().findFirst().get() : ""))), Comparator.naturalOrder())).collect(Collectors.toList());
    }
}

