/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.hadoop.HoodieAvroOrcWriter;
import org.apache.hudi.io.hadoop.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.orc.CompressionKind;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieWriteableTestTable
extends HoodieMetadataTestTable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteableTestTable.class);
    protected final Schema schema;
    protected final Option<BloomFilter> filter;
    protected final boolean populateMetaFields;

    protected HoodieWriteableTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter) {
        this(basePath, storage, metaClient, schema, filter, null);
    }

    protected HoodieWriteableTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter) {
        this(basePath, storage, metaClient, schema, filter, metadataWriter, (Option<HoodieEngineContext>)Option.empty());
    }

    public HoodieWriteableTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter, Option<HoodieEngineContext> context) {
        super(basePath, storage, metaClient, metadataWriter, context);
        this.schema = schema;
        this.filter = Option.ofNullable((Object)filter);
        this.populateMetaFields = metaClient.getTableConfig().populateMetaFields();
    }

    public HoodieWriteableTestTable addCommit(String instantTime) throws Exception {
        return (HoodieWriteableTestTable)super.addCommit(instantTime);
    }

    public HoodieWriteableTestTable forCommit(String instantTime) {
        return (HoodieWriteableTestTable)super.forCommit(instantTime);
    }

    public StoragePath withInserts(String partition, String fileId, List<HoodieRecord> records, TaskContextSupplier contextSupplier) throws Exception {
        FileCreateUtilsLegacy.createPartitionMetaFile((String)this.basePath, (String)partition);
        String fileName = FileCreateUtilsLegacy.baseFileName((String)this.currentInstantTime, (String)fileId);
        StoragePath baseFilePath = new StoragePath(Paths.get(this.basePath, partition, fileName).toString());
        if (this.storage.exists(baseFilePath)) {
            LOG.warn("Deleting the existing base file " + baseFilePath);
            this.storage.deleteFile(baseFilePath);
        }
        if (((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).equals((Object)HoodieFileFormat.PARQUET)) {
            HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(this.schema), this.schema, this.filter, new Properties());
            HoodieParquetConfig config = new HoodieParquetConfig((Object)writeSupport, CompressionCodecName.GZIP, 0x8000000, 0x100000, 0x7800000L, this.storage.getConf(), Double.parseDouble((String)HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue()), true);
            try (HoodieAvroParquetWriter writer = new HoodieAvroParquetWriter(new StoragePath(Paths.get(this.basePath, partition, fileName).toString()), config, this.currentInstantTime, contextSupplier, this.populateMetaFields);){
                int seqId = 1;
                for (HoodieRecord record : records) {
                    GenericRecord avroRecord = (GenericRecord)((HoodieRecordPayload)record.getData()).getInsertValue(this.schema).get();
                    if (this.populateMetaFields) {
                        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, (String)this.currentInstantTime, (String)String.valueOf(seqId++));
                        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, (String)record.getRecordKey(), (String)record.getPartitionPath(), (String)fileName);
                        writer.writeAvro(record.getRecordKey(), (IndexedRecord)avroRecord);
                        this.filter.ifPresent(f -> f.add(record.getRecordKey()));
                        continue;
                    }
                    writer.writeAvro(record.getRecordKey(), (IndexedRecord)avroRecord);
                }
            }
        }
        if (((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).equals((Object)HoodieFileFormat.ORC)) {
            StorageConfiguration conf = this.storage.getConf().newInstance();
            int orcStripSize = Integer.parseInt((String)HoodieStorageConfig.ORC_STRIPE_SIZE.defaultValue());
            int orcBlockSize = Integer.parseInt((String)HoodieStorageConfig.ORC_BLOCK_SIZE.defaultValue());
            int maxFileSize = Integer.parseInt((String)HoodieStorageConfig.ORC_FILE_MAX_SIZE.defaultValue());
            HoodieOrcConfig config = new HoodieOrcConfig(conf, CompressionKind.ZLIB, orcStripSize, orcBlockSize, (long)maxFileSize, (BloomFilter)this.filter.orElse(null));
            try (HoodieAvroOrcWriter writer = new HoodieAvroOrcWriter(this.currentInstantTime, new StoragePath(Paths.get(this.basePath, partition, fileName).toString()), config, this.schema, contextSupplier);){
                int seqId = 1;
                for (HoodieRecord record : records) {
                    GenericRecord avroRecord = (GenericRecord)((HoodieRecordPayload)record.getData()).getInsertValue(this.schema).get();
                    HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, (String)this.currentInstantTime, (String)String.valueOf(seqId++));
                    HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, (String)record.getRecordKey(), (String)record.getPartitionPath(), (String)fileName);
                    writer.writeAvro(record.getRecordKey(), (IndexedRecord)avroRecord);
                    this.filter.ifPresent(f -> f.add(record.getRecordKey()));
                }
            }
        }
        return baseFilePath;
    }

    public Map<String, List<HoodieLogFile>> withLogAppends(String partition, String fileId, List<HoodieRecord> records) throws Exception {
        HashMap<String, List<HoodieLogFile>> partitionToLogfilesMap = new HashMap<String, List<HoodieLogFile>>();
        Pair<String, HoodieLogFile> appendedLogFile = this.appendRecordsToLogFile(partition, fileId, records);
        partitionToLogfilesMap.computeIfAbsent((String)appendedLogFile.getKey(), (Function<String, List<HoodieLogFile>>)((Function<String, List>)k -> new ArrayList())).add(appendedLogFile.getValue());
        return partitionToLogfilesMap;
    }

    private Pair<String, HoodieLogFile> appendRecordsToLogFile(String partitionPath, String fileId, List<HoodieRecord> records) throws Exception {
        try (HoodieLogFormat.Writer logWriter = HoodieLogFormat.newWriterBuilder().onParentPath(new StoragePath(this.basePath, partitionPath)).withFileExtension(".log").withFileId(fileId).withInstantTime(this.currentInstantTime).withStorage(this.storage).build();){
            HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, this.currentInstantTime);
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, this.schema.toString());
            logWriter.appendBlock((HoodieLogBlock)new HoodieAvroDataBlock(records.stream().map(r -> {
                try {
                    GenericRecord val = (GenericRecord)((HoodieRecordPayload)r.getData()).getInsertValue(this.schema).get();
                    HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)val, (String)r.getRecordKey(), (String)r.getPartitionPath(), (String)"");
                    return val;
                }
                catch (IOException e) {
                    LOG.warn("Failed to convert record " + r.toString(), (Throwable)e);
                    return null;
                }
            }).map(HoodieAvroIndexedRecord::new).collect(Collectors.toList()), header, HoodieRecord.RECORD_KEY_METADATA_FIELD));
            Pair pair = Pair.of((Object)partitionPath, (Object)logWriter.getLogFile());
            return pair;
        }
    }
}

