/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieLSMTimelineInstant;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMetadataConversionUtils
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testCompletedClean() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCleanMetadata(newCommitTime);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clean", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED.toString(), (Object)metaEntry.getActionState());
        Assertions.assertEquals((Object)newCommitTime, (Object)metaEntry.getHoodieCleanMetadata().getStartCleanTime());
    }

    @Test
    public void testCompletedReplace() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE, true);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.COMPLETED.toString());
        Assertions.assertEquals((Object)metaEntry.getHoodieReplaceCommitMetadata().getOperationType(), (Object)WriteOperationType.INSERT_OVERWRITE.toString());
    }

    @Test
    public void testEmptyRequestedReplace() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE_TABLE, false);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.REQUESTED.toString());
        Assertions.assertNull((Object)metaEntry.getHoodieRequestedReplaceMetadata());
    }

    @Test
    public void testEmptyInflightReplace() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE_TABLE, true);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.INFLIGHT.toString());
        Assertions.assertNull((Object)metaEntry.getHoodieInflightReplaceMetadata());
    }

    @Test
    public void testNonEmptyInflightReplace() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE_TABLE, false);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.INFLIGHT.toString());
        Assertions.assertEquals((Object)metaEntry.getHoodieInflightReplaceMetadata().getOperationType(), (Object)WriteOperationType.INSERT_OVERWRITE_TABLE.name());
    }

    @Test
    public void testCompletedCommit() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCommitMetadata(newCommitTime);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.COMPLETED.toString());
        Assertions.assertEquals((Object)metaEntry.getHoodieCommitMetadata().getOperationType(), (Object)WriteOperationType.INSERT.toString());
    }

    @Test
    public void testCompletedDeltaCommit() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createDeltaCommitMetadata(newCommitTime);
        HoodieInstant completedDeltaCommitInstant = this.metaClient.getActiveTimeline().getInstantsAsStream().filter(s -> s.isCompleted() && s.requestedTime().equals(newCommitTime)).findFirst().get();
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)completedDeltaCommitInstant, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.COMPLETED.toString());
        Assertions.assertEquals((Object)metaEntry.getActionType(), (Object)"deltacommit");
    }

    @Test
    public void testCompletedRollback() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createRollbackMetadata(newCommitTime);
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "rollback", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.COMPLETED.toString());
        Assertions.assertEquals((Object)metaEntry.getHoodieRollbackMetadata().getStartRollbackTime(), (Object)newCommitTime);
    }

    @Test
    public void testCompletedCompaction() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCompactionMetadata(newCommitTime);
        this.metaClient.reloadActiveTimeline();
        HoodieArchivedMetaEntry metaEntry = MetadataConversionUtils.createMetaWrapper((HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)metaEntry.getActionState(), (Object)HoodieInstant.State.COMPLETED.toString());
        Assertions.assertEquals((Object)metaEntry.getHoodieCommitMetadata().getOperationType(), (Object)WriteOperationType.COMPACT.toString());
    }

    @Test
    public void testConvertCommitMetadata() {
        org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        hoodieCommitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieCommitMetadata expectedCommitMetadata = (HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadataToAvro((org.apache.hudi.common.model.HoodieCommitMetadata)hoodieCommitMetadata);
        Assertions.assertEquals((Object)expectedCommitMetadata.getOperationType(), (Object)WriteOperationType.INSERT.toString());
    }

    @Test
    public void testArchivedClean() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCleanMetadata(newCommitTime);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"clean", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)this.metaClient, (InputStream)new ByteArrayInputStream(archived.getMetadata().array())));
        Assertions.assertDoesNotThrow(() -> (HoodieCleanerPlan)TimelineMetadataUtils.deserializeAvroMetadata((InputStream)new ByteArrayInputStream(archived.getPlan().array()), HoodieCleanerPlan.class));
    }

    @Test
    public void testArchivedReplace() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE, true);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"replacecommit", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (HoodieRequestedReplaceMetadata)TimelineMetadataUtils.deserializeAvroMetadata((InputStream)new ByteArrayInputStream(archived.getPlan().array()), HoodieRequestedReplaceMetadata.class));
    }

    @Test
    public void testArchivedInsertOverwriteWithoutClustering() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE, false);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"replacecommit", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (org.apache.hudi.common.model.HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime), (InputStream)new ByteArrayInputStream(archived.getPlan().array()), () -> false, org.apache.hudi.common.model.HoodieCommitMetadata.class), (String)"Insert overwrite without clustering should have a plan");
        String newCommitTime2 = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime2, WriteOperationType.INSERT_OVERWRITE_TABLE, false);
        HoodieLSMTimelineInstant archived2 = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime2), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime2, (Object)archived2.getInstantTime());
        Assertions.assertEquals((Object)"replacecommit", (Object)archived2.getAction());
        Assertions.assertDoesNotThrow(() -> (org.apache.hudi.common.model.HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime2), (InputStream)new ByteArrayInputStream(archived2.getPlan().array()), () -> false, org.apache.hudi.common.model.HoodieCommitMetadata.class), (String)"Insert overwrite table without clustering should have a plan");
    }

    @Test
    public void testArchivedInsertOverwriteWithClustering() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime, WriteOperationType.INSERT_OVERWRITE, true);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"replacecommit", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (HoodieRequestedReplaceMetadata)TimelineMetadataUtils.deserializeAvroMetadata((InputStream)new ByteArrayInputStream(archived.getPlan().array()), HoodieRequestedReplaceMetadata.class));
        String newCommitTime2 = HoodieTestTable.makeNewCommitTime();
        this.createReplace(newCommitTime2, WriteOperationType.INSERT_OVERWRITE_TABLE, true);
        HoodieLSMTimelineInstant archived2 = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime2), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime2, (Object)archived2.getInstantTime());
        Assertions.assertEquals((Object)"replacecommit", (Object)archived2.getAction());
        Assertions.assertDoesNotThrow(() -> (HoodieRequestedReplaceMetadata)TimelineMetadataUtils.deserializeAvroMetadata((InputStream)new ByteArrayInputStream(archived2.getPlan().array()), HoodieRequestedReplaceMetadata.class));
    }

    @Test
    public void testArchivedCommit() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCommitMetadata(newCommitTime);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"commit", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (org.apache.hudi.common.model.HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime), (InputStream)new ByteArrayInputStream(archived.getMetadata().array()), () -> false, org.apache.hudi.common.model.HoodieCommitMetadata.class));
    }

    @Test
    public void testArchivedDeltaCommit() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createDeltaCommitMetadata(newCommitTime);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"deltacommit", (Object)archived.getAction());
        Assertions.assertNull((Object)archived.getMetadata());
    }

    @Test
    public void testArchivedRollback() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createRollbackMetadata(newCommitTime);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"rollback", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((InputStream)new ByteArrayInputStream(archived.getMetadata().array()), HoodieRollbackMetadata.class));
        Assertions.assertNull((Object)archived.getPlan());
    }

    @Test
    public void testArchivedCompaction() throws Exception {
        String newCommitTime = HoodieTestTable.makeNewCommitTime();
        this.createCompactionMetadata(newCommitTime);
        HoodieLSMTimelineInstant archived = MetadataConversionUtils.createLSMTimelineInstant((ActiveAction)this.getActiveInstant(newCommitTime), (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)newCommitTime, (Object)archived.getInstantTime());
        Assertions.assertEquals((Object)"commit", (Object)archived.getAction());
        Assertions.assertDoesNotThrow(() -> (org.apache.hudi.common.model.HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", newCommitTime), (InputStream)new ByteArrayInputStream(archived.getMetadata().array()), () -> false, org.apache.hudi.common.model.HoodieCommitMetadata.class));
        Assertions.assertDoesNotThrow(() -> CompactionUtils.getCompactionPlan((HoodieTableMetaClient)this.metaClient, (InputStream)new ByteArrayInputStream(archived.getPlan().array())));
    }

    private void createCompactionMetadata(String instantTime) throws Exception {
        String fileId1 = "file-" + instantTime + "-1";
        String fileId2 = "file-" + instantTime + "-2";
        org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        commitMetadata.setCompacted(Boolean.valueOf(true));
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCompaction(instantTime, commitMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createRollbackMetadata(String instantTime) throws Exception {
        HoodieRollbackMetadata rollbackMetadata = new HoodieRollbackMetadata();
        rollbackMetadata.setCommitsRollback(Arrays.asList(instantTime));
        rollbackMetadata.setStartRollbackTime(instantTime);
        HoodieRollbackPartitionMetadata rollbackPartitionMetadata = new HoodieRollbackPartitionMetadata();
        rollbackPartitionMetadata.setPartitionPath("p1");
        rollbackPartitionMetadata.setSuccessDeleteFiles(Arrays.asList("f1"));
        rollbackPartitionMetadata.setFailedDeleteFiles(new ArrayList());
        rollbackPartitionMetadata.setRollbackLogFiles(new HashMap());
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieRollbackPartitionMetadata>();
        partitionMetadataMap.put("p1", rollbackPartitionMetadata);
        rollbackMetadata.setPartitionMetadata(partitionMetadataMap);
        rollbackMetadata.setInstantsRollback(Arrays.asList(new HoodieInstantInfo("1", "commit")));
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollback(instantTime, rollbackMetadata, null);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollbackCompleted(instantTime, rollbackMetadata, false);
    }

    private void createCommitMetadata(String instantTime) throws Exception {
        String fileId1 = "file-" + instantTime + "-1";
        String fileId2 = "file-" + instantTime + "-2";
        org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createDeltaCommitMetadata(String instantTime) throws Exception {
        String fileId1 = "file-" + instantTime + "-1";
        String fileId2 = "file-" + instantTime + "-2";
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addDeltaCommit(instantTime).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createReplace(String instantTime, WriteOperationType writeOperationType, Boolean isClustering) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId2));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = null;
        org.apache.hudi.common.model.HoodieCommitMetadata inflightReplaceMetadata = null;
        if (isClustering.booleanValue()) {
            requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
            requestedReplaceMetadata.setOperationType(writeOperationType.name());
            HoodieClusteringPlan clusteringPlan = new HoodieClusteringPlan();
            HoodieClusteringGroup clusteringGroup = new HoodieClusteringGroup();
            HoodieSliceInfo sliceInfo = new HoodieSliceInfo();
            clusteringGroup.setSlices(Arrays.asList(sliceInfo));
            clusteringPlan.setInputGroups(Arrays.asList(clusteringGroup));
            requestedReplaceMetadata.setClusteringPlan(clusteringPlan);
            requestedReplaceMetadata.setVersion(TimelineLayoutVersion.CURR_VERSION);
        } else {
            inflightReplaceMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
            inflightReplaceMetadata.setOperationType(writeOperationType);
            inflightReplaceMetadata.setCompacted(Boolean.valueOf(false));
        }
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addReplaceCommit(instantTime, Option.ofNullable((Object)requestedReplaceMetadata), Option.ofNullable((Object)inflightReplaceMetadata), replaceMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createCleanMetadata(String instantTime) throws IOException {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.EMPTY_MAP);
        HoodieCleanStat cleanStats = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, HoodieTestUtils.DEFAULT_PARTITION_PATHS[new Random().nextInt(HoodieTestUtils.DEFAULT_PARTITION_PATHS.length)], Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), instantTime, "");
        HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)instantTime, (Option)Option.of((Object)0L), Collections.singletonList(cleanStats), (Map)Collections.EMPTY_MAP);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addClean(instantTime, cleanerPlan, cleanMetadata);
    }

    private ActiveAction getActiveInstant(String instantTime) {
        HoodieActiveTimeline rawActiveTimeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, false);
        List instants = rawActiveTimeline.getInstantsAsStream().filter(instant -> instant.requestedTime().equals(instantTime)).collect(Collectors.toList());
        return ActiveAction.fromInstants(instants);
    }
}

