/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcurrentSchemaEvolutionTableSchemaGetter {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentSchemaEvolutionTableSchemaGetter.class);
    protected final HoodieTableMetaClient metaClient;
    private final Lazy<ConcurrentHashMap<HoodieInstant, Schema>> tableSchemaCache;
    private Option<HoodieInstant> latestCommitWithValidSchema = Option.empty();

    @VisibleForTesting
    public ConcurrentHashMap<HoodieInstant, Schema> getTableSchemaCache() {
        return (ConcurrentHashMap)this.tableSchemaCache.get();
    }

    public ConcurrentSchemaEvolutionTableSchemaGetter(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.tableSchemaCache = Lazy.lazily(ConcurrentHashMap::new);
    }

    private Schema handlePartitionColumnsIfNeeded(Schema schema) {
        if (this.metaClient.getTableConfig().shouldDropPartitionColumns().booleanValue()) {
            return (Schema)this.metaClient.getTableConfig().getPartitionFields().map(partitionFields -> ConcurrentSchemaEvolutionTableSchemaGetter.appendPartitionColumns(schema, (Option<String[]>)Option.ofNullable((Object)partitionFields))).or(() -> Option.of((Object)schema)).get();
        }
        return schema;
    }

    public Option<Schema> getTableAvroSchemaIfPresent(boolean includeMetadataFields, Option<HoodieInstant> instant) {
        return this.getTableAvroSchemaFromTimelineWithCache(instant).or(this::getTableCreateSchemaWithoutMetaField).map(tableSchema -> includeMetadataFields ? HoodieAvroUtils.addMetadataFields((Schema)tableSchema, (boolean)false) : HoodieAvroUtils.removeMetadataFields((Schema)tableSchema)).map(this::handlePartitionColumnsIfNeeded);
    }

    private Option<Schema> getTableCreateSchemaWithoutMetaField() {
        return this.metaClient.getTableConfig().getTableCreateSchema();
    }

    private void setCachedLatestCommitWithValidSchema(Option<HoodieInstant> instantOption) {
        this.latestCommitWithValidSchema = instantOption;
    }

    private Option<HoodieInstant> getCachedLatestCommitWithValidSchema() {
        return this.latestCommitWithValidSchema;
    }

    @VisibleForTesting
    Option<Schema> getTableAvroSchemaFromTimelineWithCache(Option<HoodieInstant> instantTime) {
        return this.getTableAvroSchemaFromTimelineWithCache(this.computeSchemaEvolutionTimelineInReverseOrder(), instantTime);
    }

    Option<Schema> getTableAvroSchemaFromTimelineWithCache(Stream<HoodieInstant> reversedTimelineStream, Option<HoodieInstant> instantTime) {
        Option<Pair<HoodieInstant, Schema>> instantWithSchema;
        boolean fetchFromLastValidCommit = instantTime.isEmpty();
        Option targetInstant = instantTime.or(this.getCachedLatestCommitWithValidSchema());
        Schema cachedTableSchema = null;
        if (!targetInstant.isEmpty()) {
            cachedTableSchema = ((ConcurrentHashMap)this.tableSchemaCache.get()).getOrDefault(targetInstant.get(), null);
        }
        if (cachedTableSchema == null && (instantWithSchema = this.getLastCommitMetadataWithValidSchemaFromTimeline(reversedTimelineStream, (Option<HoodieInstant>)targetInstant)).isPresent()) {
            targetInstant = Option.of((Object)((Pair)instantWithSchema.get()).getLeft());
            cachedTableSchema = (Schema)((Pair)instantWithSchema.get()).getRight();
        }
        if (fetchFromLastValidCommit) {
            this.setCachedLatestCommitWithValidSchema((Option<HoodieInstant>)targetInstant);
        }
        if (cachedTableSchema != null) {
            if (instantTime.isPresent()) {
                ((ConcurrentHashMap)this.tableSchemaCache.get()).putIfAbsent(instantTime.get(), cachedTableSchema);
            }
            if (targetInstant.isPresent()) {
                ((ConcurrentHashMap)this.tableSchemaCache.get()).putIfAbsent(targetInstant.get(), cachedTableSchema);
            }
        }
        return cachedTableSchema == null ? Option.empty() : Option.of((Object)cachedTableSchema);
    }

    @VisibleForTesting
    Option<Pair<HoodieInstant, Schema>> getLastCommitMetadataWithValidSchemaFromTimeline(Stream<HoodieInstant> reversedTimelineStream, Option<HoodieInstant> instant) {
        ConcurrentHashMap tableSchemaAtInstant = new ConcurrentHashMap();
        Option instantWithTableSchema = Option.fromJavaOptional(reversedTimelineStream.filter(s -> instant.isEmpty() || InstantComparison.compareTimestamps((String)s.getCompletionTime(), (BiPredicate)InstantComparison.LESSER_THAN_OR_EQUALS, (String)((HoodieInstant)instant.get()).getCompletionTime())).filter(s -> {
            try {
                boolean isValidSchemaStr;
                if (((ConcurrentHashMap)this.tableSchemaCache.get()).containsKey(s)) {
                    tableSchemaAtInstant.putIfAbsent(s, ((ConcurrentHashMap)this.tableSchemaCache.get()).get(s));
                    return true;
                }
                HoodieCommitMetadata metadata = this.metaClient.getActiveTimeline().readCommitMetadata(s);
                String schemaStr = metadata.getMetadata("schema");
                boolean bl = isValidSchemaStr = !StringUtils.isNullOrEmpty((String)schemaStr);
                if (isValidSchemaStr) {
                    tableSchemaAtInstant.putIfAbsent(s, new Schema.Parser().parse(schemaStr));
                }
                return isValidSchemaStr;
            }
            catch (IOException e) {
                LOG.warn("Failed to parse commit metadata for instant {} ", s, (Object)e);
                return false;
            }
        }).findFirst());
        if (instantWithTableSchema.isEmpty()) {
            return Option.empty();
        }
        return Option.of((Object)Pair.of((Object)instantWithTableSchema.get(), tableSchemaAtInstant.get(instantWithTableSchema.get())));
    }

    public static Schema appendPartitionColumns(Schema dataSchema, Option<String[]> partitionFields) {
        if (!partitionFields.isPresent() || ((String[])partitionFields.get()).length == 0) {
            return dataSchema;
        }
        boolean hasPartitionColNotInSchema = Arrays.stream((Object[])partitionFields.get()).anyMatch(pf -> !AvroSchemaUtils.containsFieldInSchema((Schema)dataSchema, (String)pf));
        boolean hasPartitionColInSchema = Arrays.stream((Object[])partitionFields.get()).anyMatch(pf -> AvroSchemaUtils.containsFieldInSchema((Schema)dataSchema, (String)pf));
        if (hasPartitionColNotInSchema && hasPartitionColInSchema) {
            throw new HoodieSchemaException("Partition columns could not be partially contained w/in the data schema");
        }
        if (hasPartitionColNotInSchema) {
            ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
            for (String partitionField : (String[])partitionFields.get()) {
                newFields.add(new Schema.Field(partitionField, AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE));
            }
            return AvroSchemaUtils.appendFieldsToSchema((Schema)dataSchema, newFields);
        }
        return dataSchema;
    }

    public Stream<HoodieInstant> computeSchemaEvolutionTimelineInReverseOrder() {
        HashSet<String> actions;
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Stream timelineStream = timeline.getInstantsAsStream();
        switch (this.metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                actions = new HashSet<String>(Arrays.asList("commit", "replacecommit"));
                break;
            }
            case MERGE_ON_READ: {
                actions = new HashSet<String>(Arrays.asList("deltacommit", "replacecommit"));
                break;
            }
            default: {
                throw new HoodieException("Unsupported table type :" + this.metaClient.getTableType());
            }
        }
        TimelineLayout timelineLayout = this.metaClient.getTimelineLayout();
        Comparator reversedComparator = timelineLayout.getInstantComparator().completionTimeOrderedComparator().reversed();
        Stream<HoodieInstant> reversedTimelineWithTableSchema = timelineStream.filter(instant -> actions.contains(instant.getAction())).filter(instant -> !ClusteringUtils.isClusteringInstant((HoodieTimeline)timeline, (HoodieInstant)instant, (InstantGenerator)this.metaClient.getInstantGenerator())).filter(HoodieInstant::isCompleted).sorted(reversedComparator);
        return reversedTimelineWithTableSchema;
    }
}

