/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;

public abstract class BucketSortBulkInsertPartitioner<T>
implements BulkInsertPartitioner<T> {
    protected final String[] sortColumnNames;
    protected final HoodieTable table;

    public BucketSortBulkInsertPartitioner(HoodieTable table, String sortString) {
        this.table = table;
        this.sortColumnNames = !StringUtils.isNullOrEmpty((String)sortString) ? sortString.split(",") : null;
    }

    protected boolean isCustomSorted() {
        return this.sortColumnNames != null && this.sortColumnNames.length > 0;
    }

    protected boolean isRecordKeySorted() {
        return this.table.requireSortedRecords() || this.table.getConfig().getBulkInsertSortMode() != BulkInsertSortMode.NONE;
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return this.isCustomSorted() || this.isRecordKeySorted();
    }
}

