/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.ttl.strategy;

import java.io.IOException;
import java.util.Locale;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.ttl.strategy.KeepByCreationTimeStrategy;
import org.apache.hudi.table.action.ttl.strategy.KeepByTimeStrategy;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategy;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodiePartitionTTLStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodiePartitionTTLStrategyFactory.class);

    public static PartitionTTLStrategy createStrategy(HoodieTable hoodieTable, TypedProperties props, String instantTime) throws IOException {
        String strategyClassName = HoodiePartitionTTLStrategyFactory.getPartitionTTLStrategyClassName(props);
        try {
            return (PartitionTTLStrategy)ReflectionUtils.loadClass((String)strategyClassName, (Class[])new Class[]{HoodieTable.class, String.class}, (Object[])new Object[]{hoodieTable, instantTime});
        }
        catch (Throwable e) {
            throw new IOException("Could not load partition ttl management strategy class " + strategyClassName, e);
        }
    }

    private static String getPartitionTTLStrategyClassName(TypedProperties props) {
        String strategyClassName = props.getString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME.key(), null);
        if (StringUtils.isNullOrEmpty((String)strategyClassName)) {
            PartitionTTLStrategyType strategyTypeEnum;
            String strategyType = props.getString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_TYPE.key(), (String)HoodieTTLConfig.PARTITION_TTL_STRATEGY_TYPE.defaultValue());
            try {
                strategyTypeEnum = PartitionTTLStrategyType.valueOf(strategyType.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new HoodieException("Unsupported PartitionTTLStrategy Type " + strategyType);
            }
            strategyClassName = HoodiePartitionTTLStrategyFactory.getPartitionTTLStrategyFromType(strategyTypeEnum);
        }
        return strategyClassName;
    }

    public static String getPartitionTTLStrategyFromType(PartitionTTLStrategyType type) {
        switch (type) {
            case KEEP_BY_TIME: {
                return KeepByTimeStrategy.class.getName();
            }
            case KEEP_BY_CREATION_TIME: {
                return KeepByCreationTimeStrategy.class.getName();
            }
        }
        throw new HoodieException("Unsupported PartitionTTLStrategy Type " + (Object)((Object)type));
    }
}

