/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.DowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;

public class SixToFiveDowngradeHandler
implements DowngradeHandler {
    @Override
    public Pair<Map<ConfigProperty, String>, List<ConfigProperty>> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetadataUtil.deleteMetadataTable((String)config.getBasePath(), (HoodieEngineContext)context);
        UpgradeDowngradeUtils.rollbackFailedWritesAndCompact(table, context, config, upgradeDowngradeHelper, HoodieTableType.MERGE_ON_READ.equals((Object)table.getMetaClient().getTableType()), HoodieTableVersion.SIX);
        UpgradeDowngradeUtils.syncCompactionRequestedFileToAuxiliaryFolder(table);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)table.getMetaClient());
        HashMap updatedTableProps = new HashMap();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        Option.ofNullable((Object)tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS, v));
        Option.ofNullable((Object)tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, v));
        return Pair.of(updatedTableProps, Collections.emptyList());
    }
}

