/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.transaction.lock.NoopLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDowngradeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeDowngradeUtils.class);
    static final Map<String, String> SIX_TO_EIGHT_TIMELINE_ACTION_MAP = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"replacecommit", (Object)"clustering")});
    static final Map<String, String> EIGHT_TO_SIX_TIMELINE_ACTION_MAP = CollectionUtils.reverseMap(SIX_TO_EIGHT_TIMELINE_ACTION_MAP);

    public static void runCompaction(HoodieTable table, HoodieEngineContext context, HoodieWriteConfig config, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        block15: {
            try {
                if (table.getMetaClient().getTableType() != HoodieTableType.MERGE_ON_READ) break block15;
                HoodieInstantTimeGenerator.setCommitTimeZone((HoodieTimelineTimeZone)table.getMetaClient().getTableConfig().getTimelineTimezone());
                HoodieWriteConfig compactionConfig = HoodieWriteConfig.newBuilder().withProps((Map)config.getProps()).build();
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1");
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key(), CompactionTriggerStrategy.NUM_COMMITS.name());
                compactionConfig.setValue(HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName());
                compactionConfig.setValue(HoodieMetadataConfig.ENABLE.key(), "false");
                try (BaseHoodieWriteClient writeClient = upgradeDowngradeHelper.getWriteClient(compactionConfig, context);){
                    Option<String> compactionInstantOpt = writeClient.scheduleCompaction((Option<Map<String, String>>)Option.empty());
                    if (compactionInstantOpt.isPresent()) {
                        writeClient.compact((String)compactionInstantOpt.get());
                    }
                }
            }
            catch (Exception e) {
                throw new HoodieException((Throwable)e);
            }
        }
    }

    public static void syncCompactionRequestedFileToAuxiliaryFolder(HoodieTable table) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        TimelineFactory timelineFactory = metaClient.getTimelineLayout().getTimelineFactory();
        InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
        HoodieTimeline compactionTimeline = timelineFactory.createActiveTimeline(metaClient, false).filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.REQUESTED);
        compactionTimeline.getInstantsAsStream().forEach(instant -> {
            String fileName = instantFileNameGenerator.getFileName(instant);
            try {
                if (!metaClient.getStorage().exists(new StoragePath(metaClient.getMetaAuxiliaryPath(), fileName))) {
                    FileIOUtils.copy((HoodieStorage)metaClient.getStorage(), (StoragePath)new StoragePath(metaClient.getTimelinePath(), fileName), (StoragePath)new StoragePath(metaClient.getMetaAuxiliaryPath(), fileName));
                }
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    static void updateMetadataTableVersion(HoodieEngineContext context, HoodieTableVersion toVersion, HoodieTableMetaClient dataMetaClient) throws HoodieIOException {
        try {
            StoragePath metadataBasePath = new StoragePath(dataMetaClient.getBasePath(), ".hoodie/metadata");
            if (dataMetaClient.getStorage().exists(metadataBasePath)) {
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(metadataBasePath).build();
                metaClient.getTableConfig().setTableVersion(toVersion);
                HoodieTableConfig.update((HoodieStorage)metaClient.getStorage(), (StoragePath)metaClient.getMetaPath(), (Properties)metaClient.getTableConfig().getProps());
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error while updating metadata table version", e);
        }
    }

    public static long convertCompletionTimeToEpoch(HoodieInstant instant) {
        try {
            String completionTime = instant.getCompletionTime();
            String completionTimeInSecs = Long.parseLong(completionTime) / 1000L + "";
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime ldtInSecs = LocalDateTime.parse(completionTimeInSecs, inputFormatter);
            long millis = Long.parseLong(completionTime.substring(completionTime.length() - 3));
            return ldtInSecs.atZone(zoneId).toEpochSecond() * 1000L + millis;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse completion time string for instant {}", (Object)instant, (Object)e);
            return -1L;
        }
    }

    static void rollbackFailedWritesAndCompact(HoodieTable table, HoodieEngineContext context, HoodieWriteConfig config, SupportsUpgradeDowngrade upgradeDowngradeHelper, boolean shouldCompact, HoodieTableVersion tableVersion) {
        try {
            HoodieInstantTimeGenerator.setCommitTimeZone((HoodieTimelineTimeZone)table.getMetaClient().getTableConfig().getTimelineTimezone());
            TypedProperties properties = new TypedProperties();
            properties.putAll((Map)config.getProps());
            properties.put((Object)HoodieTimeGeneratorConfig.TIME_GENERATOR_REUSE_ENABLE.key(), (Object)"false");
            properties.put((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), (Object)NoopLockProvider.class.getName());
            properties.put((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"false");
            HoodieWriteConfig rollbackWriteConfig = HoodieWriteConfig.newBuilder().withProps((Map)properties).withWriteTableVersion(tableVersion.versionCode()).withAutoUpgradeVersion(false).build();
            rollbackWriteConfig.setValue(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.EAGER.name());
            rollbackWriteConfig.setValue(HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE.key(), String.valueOf(config.shouldRollbackUsingMarkers()));
            if (shouldCompact) {
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1");
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key(), CompactionTriggerStrategy.NUM_COMMITS.name());
                rollbackWriteConfig.setValue(HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName());
            } else {
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
            }
            rollbackWriteConfig.setValue(HoodieMetadataConfig.ENABLE.key(), "false");
            try (BaseHoodieWriteClient writeClient = upgradeDowngradeHelper.getWriteClient(rollbackWriteConfig, context);){
                Option<String> compactionInstantOpt;
                writeClient.rollbackFailedWrites(table.getMetaClient());
                if (shouldCompact && (compactionInstantOpt = writeClient.scheduleCompaction((Option<Map<String, String>>)Option.empty())).isPresent()) {
                    writeClient.compact((String)compactionInstantOpt.get());
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
    }
}

