/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.TableWriteStats;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class TestBaseHoodieTableServiceClient
extends HoodieCommonTestHarness {
    TestBaseHoodieTableServiceClient() {
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void cleanRollsBackFailedWritesWithLazyPolicy(boolean rollbackOccurred) throws IOException {
        Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo;
        String cleanInstantTime = "001";
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        HoodieTable firstTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTable secondTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline timeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)firstTable.getMetaClient()).thenReturn((Object)mockMetaClient);
        if (rollbackOccurred) {
            String newInstantTime = InProcessTimeGenerator.createNewInstantTime();
            MockHoodieTimeline pendingTimeline = new MockHoodieTimeline(Stream.empty(), Stream.of(newInstantTime));
            Mockito.when((Object)mockMetaClient.getCommitsTimeline().filterPendingExcludingCompaction()).thenReturn((Object)pendingTimeline);
            Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants()).thenReturn(Collections.emptyList());
            expectedRollbackInfo = Collections.singletonMap(newInstantTime, Option.empty());
            Mockito.when((Object)secondTable.getActiveTimeline()).thenReturn((Object)timeline);
        } else {
            MockHoodieTimeline pendingTimeline = new MockHoodieTimeline(Stream.empty(), Stream.empty());
            Mockito.when((Object)mockMetaClient.getCommitsTimeline().filterPendingExcludingCompaction()).thenReturn((Object)pendingTimeline);
            Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants()).thenReturn(Collections.emptyList());
            expectedRollbackInfo = Collections.emptyMap();
            Mockito.when((Object)firstTable.getActiveTimeline()).thenReturn((Object)timeline);
        }
        Mockito.when((Object)timeline.getCleanerTimeline().filterInflightsAndRequested().firstInstant()).thenReturn((Object)Option.empty());
        if (rollbackOccurred) {
            Mockito.when((Object)secondTable.clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)cleanInstantTime))).thenReturn(null);
        } else {
            Mockito.when((Object)firstTable.clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)cleanInstantTime))).thenReturn(null);
        }
        TestTableServiceClient tableServiceClient = new TestTableServiceClient(writeConfig, Arrays.asList(firstTable, secondTable).iterator(), (Option<EmbeddedTimelineService>)Option.empty(), expectedRollbackInfo, Collections.singletonList(cleanInstantTime).iterator());
        tableServiceClient.clean(Option.empty(), false);
    }

    @Test
    void cleanerPlanIsSkippedIfHasInflightClean() throws IOException {
        String cleanInstantTime = "001";
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        HoodieTable firstTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline timeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)firstTable.getMetaClient()).thenReturn((Object)mockMetaClient);
        MockHoodieTimeline pendingTimeline = new MockHoodieTimeline(Stream.empty(), Stream.empty());
        Mockito.when((Object)mockMetaClient.getCommitsTimeline().filterPendingExcludingCompaction()).thenReturn((Object)pendingTimeline);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants()).thenReturn(Collections.emptyList());
        Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo = Collections.emptyMap();
        Mockito.when((Object)firstTable.getActiveTimeline()).thenReturn((Object)timeline);
        HoodieInstant inflightCleaning = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", cleanInstantTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Mockito.when((Object)firstTable.getActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().firstInstant()).thenReturn((Object)Option.of((Object)inflightCleaning));
        HoodieCleanMetadata metadata = new HoodieCleanMetadata();
        Mockito.when((Object)firstTable.clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)cleanInstantTime))).thenReturn((Object)metadata);
        TestTableServiceClient tableServiceClient = new TestTableServiceClient(writeConfig, Collections.singletonList(firstTable).iterator(), (Option<EmbeddedTimelineService>)Option.empty(), expectedRollbackInfo, Collections.emptyIterator());
        Assertions.assertSame((Object)metadata, (Object)tableServiceClient.clean(Option.empty(), true));
        ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient)).reloadActiveTimeline();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void cleanerPlanIsCalledWithoutInflightClean(boolean generatesPlan) throws IOException {
        HoodieCleanMetadata metadata;
        String cleanInstantTime = "001";
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).build();
        HoodieTable mockTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline timeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockTable.getMetaClient()).thenReturn((Object)mockMetaClient);
        MockHoodieTimeline pendingTimeline = new MockHoodieTimeline(Stream.empty(), Stream.empty());
        Mockito.when((Object)mockMetaClient.getCommitsTimeline().filterPendingExcludingCompaction()).thenReturn((Object)pendingTimeline);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants()).thenReturn(Collections.emptyList());
        Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo = Collections.emptyMap();
        Mockito.when((Object)mockTable.getActiveTimeline()).thenReturn((Object)timeline);
        Mockito.when((Object)mockTable.getActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().firstInstant()).thenReturn((Object)Option.empty());
        if (generatesPlan) {
            HoodieCleanerPlan plan = new HoodieCleanerPlan();
            Mockito.when((Object)mockTable.createCleanerPlan((HoodieEngineContext)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Option.of((Object)plan));
            metadata = new HoodieCleanMetadata();
            Mockito.when((Object)mockTable.clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)cleanInstantTime))).thenReturn((Object)metadata);
        } else {
            Mockito.when((Object)mockTable.createCleanerPlan((HoodieEngineContext)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Option.empty());
            metadata = null;
        }
        TestTableServiceClient tableServiceClient = new TestTableServiceClient(writeConfig, Collections.singletonList(mockTable).iterator(), (Option<EmbeddedTimelineService>)Option.empty(), expectedRollbackInfo, Collections.singletonList(cleanInstantTime).iterator());
        Assertions.assertEquals((Object)metadata, (Object)tableServiceClient.clean(Option.empty(), true));
        if (generatesPlan) {
            ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient)).reloadActiveTimeline();
        } else {
            ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient, (VerificationMode)Mockito.never())).reloadActiveTimeline();
            ((HoodieTable)Mockito.verify((Object)mockTable, (VerificationMode)Mockito.never())).clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
    }

    @Test
    void cleanerPlanIsCalledWithInflightCleanAndAllowMultipleCleans() throws IOException {
        String inflightInstant = "001";
        String cleanInstantTime = "002";
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetricsConfig(HoodieMetricsConfig.newBuilder().on(true).withReporterType(MetricsReporterType.INMEMORY.name()).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).allowMultipleCleans(true).build()).build();
        HoodieTable mockTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline timeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockTable.getMetaClient()).thenReturn((Object)mockMetaClient);
        MockHoodieTimeline pendingTimeline = new MockHoodieTimeline(Stream.empty(), Stream.empty());
        Mockito.when((Object)mockMetaClient.getCommitsTimeline().filterPendingExcludingCompaction()).thenReturn((Object)pendingTimeline);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants()).thenReturn(Collections.emptyList());
        Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo = Collections.emptyMap();
        Mockito.when((Object)mockTable.getActiveTimeline()).thenReturn((Object)timeline);
        HoodieInstant inflightCleaning = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", inflightInstant, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Mockito.when((Object)mockTable.getActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().firstInstant()).thenReturn((Object)Option.of((Object)inflightCleaning));
        HoodieCleanerPlan plan = new HoodieCleanerPlan();
        Mockito.when((Object)mockTable.createCleanerPlan((HoodieEngineContext)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Option.of((Object)plan));
        HoodieCleanMetadata metadata = new HoodieCleanMetadata();
        Mockito.when((Object)mockTable.clean((HoodieEngineContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)cleanInstantTime))).thenReturn((Object)metadata);
        TestTableServiceClient tableServiceClient = new TestTableServiceClient(writeConfig, Collections.singletonList(mockTable).iterator(), (Option<EmbeddedTimelineService>)Option.empty(), expectedRollbackInfo, Collections.singletonList(cleanInstantTime).iterator());
        Assertions.assertEquals((Object)metadata, (Object)tableServiceClient.clean(Option.empty(), true));
        ((HoodieTableMetaClient)Mockito.verify((Object)mockMetaClient)).reloadActiveTimeline();
    }

    private static class TestTableServiceClient
    extends BaseHoodieTableServiceClient<String, String, String> {
        private final Iterator<HoodieTable<String, String, String, String>> tables;
        private final Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo;
        private final Iterator<String> instantTimes;

        public TestTableServiceClient(HoodieWriteConfig writeConfig, Iterator<HoodieTable<String, String, String, String>> tables, Option<EmbeddedTimelineService> timelineService, Map<String, Option<HoodiePendingRollbackInfo>> expectedRollbackInfo, Iterator<String> instantTimes) {
            super((HoodieEngineContext)new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf()), writeConfig, timelineService);
            this.tables = tables;
            this.expectedRollbackInfo = expectedRollbackInfo;
            this.instantTimes = instantTimes;
        }

        public String createNewInstantTime(boolean shouldLock) {
            return this.instantTimes.next();
        }

        protected TableWriteStats triggerWritesAndFetchWriteStats(HoodieWriteMetadata<String> writeMetadata) {
            return null;
        }

        protected HoodieWriteMetadata<String> convertToOutputMetadata(HoodieWriteMetadata<String> writeMetadata) {
            return null;
        }

        protected HoodieTable<?, String, ?, String> createTable(HoodieWriteConfig config, StorageConfiguration<?> storageConf, boolean skipValidation) {
            return this.tables.next();
        }

        protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback) {
            Assertions.assertEquals(this.expectedRollbackInfo, instantsToRollback);
        }
    }
}

