/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.util.Option;

public class WriteClientTestUtils {
    private WriteClientTestUtils() {
    }

    public static void startCommitWithTime(BaseHoodieWriteClient<?, ?, ?, ?> writeClient, String instantTime, String actionType) {
        writeClient.startCommit(Option.of((Object)instantTime), actionType, writeClient.createMetaClient(false));
    }

    public static void startCommitWithTime(BaseHoodieWriteClient<?, ?, ?, ?> writeClient, String instantTime) {
        HoodieTableMetaClient metaClient = writeClient.createMetaClient(false);
        writeClient.startCommit(Option.of((Object)instantTime), metaClient.getCommitActionType(), metaClient);
    }

    public static Option<String> scheduleTableService(BaseHoodieWriteClient<?, ?, ?, ?> writeClient, String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        return writeClient.scheduleTableService(Option.of((Object)instantTime), extraMetadata, tableServiceType);
    }

    public static String createNewInstantTime() {
        return HoodieInstantTimeGenerator.createNewInstantTime((boolean)false, (TimeGenerator)TestTimeGenerator.INSTANCE, (long)0L);
    }

    private static class TestTimeGenerator
    implements TimeGenerator {
        private static final TimeGenerator INSTANCE = new TestTimeGenerator();

        private TestTimeGenerator() {
        }

        public long generateTime(boolean skipLocking) {
            return System.currentTimeMillis();
        }

        public void consumeTime(boolean skipLocking, Consumer<Long> func) {
        }
    }
}

