/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;

public class TestConflictResolutionStrategyUtil {
    public static void createCommit(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        testTable = metaClient.getTableConfig().getTableType() == HoodieTableType.COPY_ON_WRITE ? testTable.addCommit(instantTime, Option.of((Object)commitMetadata)) : testTable.addDeltaCommit(instantTime, Option.empty(), commitMetadata);
        testTable.withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static HoodieCommitMetadata createCommitMetadata(String instantTime, String writeFileName) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(writeFileName);
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        return commitMetadata;
    }

    public static HoodieCommitMetadata createCommitMetadata(String instantTime) {
        return TestConflictResolutionStrategyUtil.createCommitMetadata(instantTime, "file-1");
    }

    public static void createInflightCommit(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-" + instantTime + "-1";
        String fileId2 = "file-" + instantTime + "-2";
        if (metaClient.getTableConfig().getTableType() == HoodieTableType.COPY_ON_WRITE) {
            HoodieTestTable.of((HoodieTableMetaClient)metaClient).addInflightCommit(instantTime).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
        } else {
            HoodieTestTable.of((HoodieTableMetaClient)metaClient).addInflightDeltaCommit(instantTime).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
        }
    }

    public static void createCompactionRequested(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        compactionPlan.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieCompactionOperation operation = new HoodieCompactionOperation();
        operation.setFileId(fileId1);
        operation.setPartitionPath("2016/03/15");
        operation.setDataFilePath("/file-1");
        operation.setDeltaFilePaths(Arrays.asList("/file-1"));
        compactionPlan.setOperations(Arrays.asList(operation));
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addRequestedCompaction(instantTime, compactionPlan);
    }

    public static void createCompaction(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        commitMetadata.setCompacted(Boolean.valueOf(true));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createClusterRequested(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = TestConflictResolutionStrategyUtil.buildRequestedReplaceMetadata(fileId1, WriteOperationType.CLUSTER);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addRequestedCluster(instantTime, requestedReplaceMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    static HoodieRequestedReplaceMetadata buildRequestedReplaceMetadata(String fileId1, WriteOperationType writeOperationType) {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(writeOperationType.name());
        HoodieClusteringPlan clusteringPlan = new HoodieClusteringPlan();
        HoodieClusteringGroup clusteringGroup = new HoodieClusteringGroup();
        HoodieSliceInfo sliceInfo = new HoodieSliceInfo();
        sliceInfo.setFileId(fileId1);
        sliceInfo.setPartitionPath("2016/03/15");
        clusteringGroup.setSlices(Collections.singletonList(sliceInfo));
        clusteringPlan.setInputGroups(Collections.singletonList(clusteringGroup));
        requestedReplaceMetadata.setClusteringPlan(clusteringPlan);
        requestedReplaceMetadata.setVersion(TimelineLayoutVersion.CURR_VERSION);
        return requestedReplaceMetadata;
    }

    public static void createClusterInflight(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addInflightCluster(instantTime);
    }

    public static void createReplaceInflight(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata inflightReplaceMetadata = TestConflictResolutionStrategyUtil.buildReplaceCommitMetadata(WriteOperationType.INSERT_OVERWRITE);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addInflightReplace(instantTime, Option.of((Object)inflightReplaceMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private static HoodieReplaceCommitMetadata buildReplaceCommitMetadata(WriteOperationType insertOverwrite) {
        HoodieReplaceCommitMetadata inflightReplaceMetadata = new HoodieReplaceCommitMetadata();
        inflightReplaceMetadata.setOperationType(insertOverwrite);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        inflightReplaceMetadata.addWriteStat("2016/03/15", writeStat);
        return inflightReplaceMetadata;
    }

    public static void createPendingInsertOverwrite(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addPendingReplace(instantTime, Option.of((Object)requestedReplaceMetadata), Option.empty()).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createReplace(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId2));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = TestConflictResolutionStrategyUtil.buildRequestedReplaceMetadata(fileId1, WriteOperationType.INSERT_OVERWRITE);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addReplaceCommit(instantTime, Option.of((Object)requestedReplaceMetadata), Option.empty(), replaceMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createCluster(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId2));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = TestConflictResolutionStrategyUtil.buildRequestedReplaceMetadata(fileId1, writeOperationType);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addCluster(instantTime, requestedReplaceMetadata, Option.empty(), replaceMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createPendingCluster(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = TestConflictResolutionStrategyUtil.buildRequestedReplaceMetadata(fileId2, writeOperationType);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addPendingCluster(instantTime, requestedReplaceMetadata, Option.empty()).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createPendingCompaction(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        compactionPlan.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieCompactionOperation operation = new HoodieCompactionOperation();
        operation.setFileId(fileId1);
        operation.setPartitionPath("2016/03/15");
        operation.setDataFilePath("/file-1");
        operation.setDeltaFilePaths(Arrays.asList("/file-1-log1"));
        compactionPlan.setOperations(Arrays.asList(operation));
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addRequestedCompaction(instantTime, compactionPlan);
        FileCreateUtilsLegacy.createInflightCompaction((String)metaClient.getBasePath().toString(), (String)instantTime);
    }

    public static void createCompleteCompaction(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        commitMetadata.setCompacted(Boolean.valueOf(true));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    public static void createRequestedCommit(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addInflightCommit(instantTime);
    }

    public static void createCompleteCommit(String instantTime, HoodieTableMetaClient metaClient) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable.of((HoodieTableMetaClient)metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private static HoodieReplaceCommitMetadata createReplaceCommitMetadata(WriteOperationType writeOperationType) {
        String fileId1 = "file-1";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId1));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        return replaceMetadata;
    }
}

