/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import org.apache.curator.test.TestingServer;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProvider;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLockManager
extends HoodieCommonTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestLockManager.class);
    private static TestingServer server;
    private static final String ZK_BASE_PATH = "/hudi/test/lock";
    private static final String KEY = "table1";

    @BeforeAll
    public static void setup() {
        while (server == null) {
            try {
                server = new TestingServer();
            }
            catch (Exception e) {
                LOG.error("Getting bind exception - retrying to allocate server");
                server = null;
            }
        }
    }

    @AfterAll
    public static void tearDown() throws IOException {
        if (server != null) {
            server.close();
        }
    }

    @BeforeEach
    void init() throws IOException {
        this.initPath();
        this.initMetaClient();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testLockAndUnlock(boolean multiWriter) {
        HoodieWriteConfig writeConfig = multiWriter ? this.getMultiWriterWriteConfig() : this.getSingleWriterWriteConfig();
        LockManager lockManager = new LockManager(writeConfig, this.metaClient.getStorage());
        LockManager mockLockManager = (LockManager)Mockito.spy((Object)lockManager);
        Assertions.assertDoesNotThrow(() -> mockLockManager.lock());
        Assertions.assertDoesNotThrow(() -> mockLockManager.unlock());
        ((LockManager)Mockito.verify((Object)mockLockManager)).close();
    }

    private HoodieWriteConfig getMultiWriterWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(ZookeeperBasedLockProvider.class).withZkBasePath(ZK_BASE_PATH).withZkLockKey(KEY).withZkQuorum(server.getConnectString()).build()).build();
    }

    private HoodieWriteConfig getSingleWriterWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(ZookeeperBasedLockProvider.class).withZkBasePath(ZK_BASE_PATH).withZkLockKey(KEY).withZkQuorum(server.getConnectString()).build()).build();
    }

    @Test
    void testLockManagerTriesMetricsConstructorFirst() {
        HoodieWriteConfig writeConfig = this.getStorageBasedLockWriteConfig();
        LockManager lockManager = new LockManager(writeConfig, this.metaClient.getStorage());
        HoodieException exception = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> ((LockManager)lockManager).getLockProvider(), (String)"StorageBasedLockProvider should fail with HoodieLockException due to invalid scheme, but this confirms metrics constructor was found");
        Assertions.assertTrue((boolean)exception.getCause().getCause().getCause().getMessage().startsWith("Unsupported scheme"), (String)"Exception should mention scheme failure, confirming metrics constructor was successfully found and used");
        lockManager.close();
    }

    @Test
    void testLockManagerFallbackToStandardConstructor() {
        HoodieWriteConfig writeConfig = this.getSingleWriterWriteConfig();
        LockManager lockManager = new LockManager(writeConfig, this.metaClient.getStorage());
        Assertions.assertDoesNotThrow(() -> lockManager.getLockProvider());
        lockManager.close();
    }

    private HoodieWriteConfig getStorageBasedLockWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(StorageBasedLockProvider.class).build()).build();
    }
}

