/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.WriteClientTestUtils;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.TestConflictResolutionStrategyUtil;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSimpleConcurrentFileWritesConflictResolutionStrategy
extends HoodieCommonTestHarness {
    @Test
    public void testNoConcurrentWrites() throws Exception {
        this.initMetaClient();
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        this.initMetaClient();
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        TestConflictResolutionStrategyUtil.createInflightCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        TestConflictResolutionStrategyUtil.createInflightCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCommit() throws Exception {
        this.initMetaClient();
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithReplaceInflightCommit() throws Exception {
        this.initMetaClient();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        String replaceInstant = WriteClientTestUtils.createNewInstantTime();
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedReplace(replaceInstant, Option.empty());
        TestConflictResolutionStrategyUtil.createReplaceInflight(replaceInstant, this.metaClient);
        Option lastSuccessfulInstant = Option.empty();
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithClusteringInflightCommit() throws Exception {
        this.initMetaClient();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        String clusteringInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createClusterRequested(clusteringInstantTime, this.metaClient);
        Option lastSuccessfulInstant = Option.empty();
        TestConflictResolutionStrategyUtil.createClusterInflight(clusteringInstantTime, this.metaClient);
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithLegacyClusteringInflightCommit() throws Exception {
        this.initMetaClient();
        String clusteringInstantTime = WriteClientTestUtils.createNewInstantTime();
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedReplace(clusteringInstantTime, Option.of((Object)TestConflictResolutionStrategyUtil.buildRequestedReplaceMetadata("file-1", WriteOperationType.CLUSTER)));
        Option lastSuccessfulInstant = Option.empty();
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightReplace(clusteringInstantTime, Option.empty());
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testConcurrentWritesWithInterleavingScheduledCompaction(boolean preTableVersion8) throws Exception {
        this.initMetaClient(preTableVersion8, HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompactionRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        if (preTableVersion8) {
            Assertions.assertEquals((int)1, (int)candidateInstants.size());
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
            ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
        } else {
            Assertions.assertTrue((boolean)candidateInstants.isEmpty());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testConcurrentWritesWithInterleavingSuccessfulCompaction(boolean preTableVersion8) throws Exception {
        this.initMetaClient(preTableVersion8, HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        if (preTableVersion8) {
            Assertions.assertEquals((int)1, (int)candidateInstants.size());
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
            ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
        } else {
            Assertions.assertTrue((boolean)candidateInstants.isEmpty());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testConcurrentWritesWithInterleavingInflightCompaction(boolean preTableVersion8) throws Exception {
        this.initMetaClient(preTableVersion8, HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCompaction(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", currentWriterInstant));
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        if (preTableVersion8) {
            Assertions.assertEquals((int)1, (int)candidateInstants.size());
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
            ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
        } else {
            Assertions.assertTrue((boolean)candidateInstants.isEmpty());
        }
    }

    @Test
    public void testConcurrentWriteAndCompactionScheduledEarlier() throws Exception {
        this.initMetaClient(false, HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCluster() throws Exception {
        this.initMetaClient(false, HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createClusterRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCluster() throws Exception {
        this.initMetaClient();
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCluster(newInstantTime, WriteOperationType.CLUSTER, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulReplace() throws Exception {
        this.initMetaClient();
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createReplace(newInstantTime, WriteOperationType.INSERT_OVERWRITE, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithPendingInsertOverwriteReplace() throws Exception {
        this.initMetaClient();
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingInsertOverwrite(newInstantTime, WriteOperationType.INSERT_OVERWRITE, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertFalse((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
    }

    @Test
    public void testConcurrentWritesWithPendingInstants() throws Exception {
        this.initMetaClient(false, HoodieTableType.MERGE_ON_READ);
        String newInstantTimeC1 = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCluster(newInstantTimeC1, WriteOperationType.CLUSTER, this.metaClient);
        String newCompactionInstantTimeC11 = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCompaction(newCompactionInstantTimeC11, this.metaClient);
        String newCommitInstantTimeC12 = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(newCommitInstantTimeC12, this.metaClient);
        TestConflictResolutionStrategyUtil.createCommit(WriteClientTestUtils.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String commitC4 = WriteClientTestUtils.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createRequestedCommit(commitC4, this.metaClient);
        this.metaClient.reloadActiveTimeline();
        Set pendingInstant = TransactionUtils.getInflightAndRequestedInstants((HoodieTableMetaClient)this.metaClient);
        pendingInstant.remove(currentWriterInstant);
        TestConflictResolutionStrategyUtil.createCluster(newInstantTimeC1, WriteOperationType.CLUSTER, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCompaction(newCompactionInstantTimeC11, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCommit(newCommitInstantTimeC12, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCommit(commitC4, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant, "file-2");
        this.metaClient.reloadActiveTimeline();
        List completedInstantsDuringCurrentWriteOperation = TransactionUtils.getCompletedInstantsDuringCurrentWriteOperation((HoodieTableMetaClient)this.metaClient, (Set)pendingInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)completedInstantsDuringCurrentWriteOperation.size());
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        for (HoodieInstant instant : completedInstantsDuringCurrentWriteOperation) {
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation(instant, this.metaClient);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            if (instant.requestedTime().equals(newCompactionInstantTimeC11)) {
                Assertions.assertDoesNotThrow(() -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
                continue;
            }
            Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
        }
    }
}

