/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.transaction.SimpleSchemaConflictResolutionStrategy;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSchemaEvolutionConflictException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.TestBaseHoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;

public class TestSimpleSchemaConflictResolutionStrategy {
    @Mock
    public static FileSystemViewManager viewManager;
    @Mock
    public static HoodieEngineContext engineContext;
    @Mock
    public static TaskContextSupplier taskContextSupplier;
    public Option<HoodieInstant> lastCompletedTxnOwnerInstant;
    public Option<HoodieInstant> tableCompactionOwnerInstant;
    public Option<HoodieInstant> tableClusteringOwnerInstant;
    public Option<HoodieInstant> tableReplacementOwnerInstant;
    public Option<HoodieInstant> nonTableCompactionInstant;
    @TempDir
    private Path basePath;
    @Mock
    private HoodieWriteConfig config;
    private HoodieTableMetaClient metaClient;
    private HoodieTestTable dummyInstantGenerator;
    private TestBaseHoodieTable table;
    private SimpleSchemaConflictResolutionStrategy strategy;
    private static final String SCHEMA1 = "{\"type\":\"record\",\"name\":\"MyRecord\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
    private static final String SCHEMA2 = "{\"type\":\"record\",\"name\":\"MyRecord\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"int\"}]}";
    private static final String SCHEMA3 = "{\"type\":\"record\",\"name\":\"MyRecord\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field3\",\"type\":\"boolean\"}]}";
    private static final String NULL_SCHEMA = "{\"type\":\"null\"}";

    private void setupInstants(String tableSchemaAtTxnStart, String tableSchemaAtTxnValidation, String writerSchemaOfTxn, Boolean enableResolution, boolean setupLegacyClustering) throws Exception {
        this.metaClient = HoodieTestUtils.getMetaClientBuilder((HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)new Properties(), (String)"").setTableCreateSchema(SCHEMA1).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath.toString());
        this.dummyInstantGenerator = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        this.lastCompletedTxnOwnerInstant = Option.of((Object)this.metaClient.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "0010", HoodieCommonTestHarness.incTimestampStrByOne((String)"0010")));
        this.tableCompactionOwnerInstant = Option.of((Object)this.metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", "0030", HoodieCommonTestHarness.incTimestampStrByOne((String)"0030")));
        this.tableClusteringOwnerInstant = Option.of((Object)this.metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", "0030", HoodieCommonTestHarness.incTimestampStrByOne((String)"0030")));
        this.tableReplacementOwnerInstant = Option.of((Object)this.metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", "0030", HoodieCommonTestHarness.incTimestampStrByOne((String)"0030")));
        this.nonTableCompactionInstant = Option.of((Object)this.metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "0040", HoodieCommonTestHarness.incTimestampStrByOne((String)"0040")));
        this.dummyInstantGenerator.addCommit("0010", Option.of((Object)HoodieCommonTestHarness.incTimestampStrByOne((String)"0010")), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)tableSchemaAtTxnStart, (String)"commit")));
        this.dummyInstantGenerator.addCommit("0020", Option.of((Object)HoodieCommonTestHarness.incTimestampStrByOne((String)"0020")), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)tableSchemaAtTxnValidation, (String)"commit")));
        if (setupLegacyClustering) {
            Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> result = this.getGetDummyClusteringMetadata();
            this.dummyInstantGenerator.addReplaceCommit(((HoodieInstant)this.tableReplacementOwnerInstant.get()).requestedTime(), Option.of((Object)result.getLeft()), Option.empty(), (HoodieReplaceCommitMetadata)result.getRight());
        }
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.setProperty(HoodieWriteConfig.ENABLE_SCHEMA_CONFLICT_RESOLUTION.key(), enableResolution != false ? ((Boolean)HoodieWriteConfig.ENABLE_SCHEMA_CONFLICT_RESOLUTION.defaultValue()).toString() : "false");
        this.config = HoodieWriteConfig.newBuilder().withSchema(writerSchemaOfTxn).withPath(this.basePath.toString()).withProperties((Properties)typedProperties).build();
        this.table = new TestBaseHoodieTable(this.config, engineContext, viewManager, this.metaClient, taskContextSupplier);
        this.strategy = new SimpleSchemaConflictResolutionStrategy();
    }

    @Test
    void testNoConflictFirstCommit() throws Exception {
        this.setupInstants(null, null, SCHEMA1, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, Option.empty(), this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA1), (Object)result);
    }

    @Test
    void testNullWriterSchema() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA1, "", true, false);
        Assertions.assertFalse((boolean)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).isPresent());
    }

    @Test
    void testNullTypeWriterSchema() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA1, NULL_SCHEMA, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA1), (Object)result);
    }

    @Test
    void testConflictSecondCommitDifferentSchema() throws Exception {
        this.setupInstants(null, SCHEMA1, SCHEMA2, true, false);
        Assertions.assertThrows(HoodieSchemaEvolutionConflictException.class, () -> this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, Option.empty(), this.nonTableCompactionInstant));
    }

    @Test
    void testConflictSecondCommitSameSchema() throws Exception {
        this.setupInstants(null, SCHEMA1, SCHEMA1, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, Option.empty(), this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA1), (Object)result);
    }

    @Test
    void testNoConflictSameSchema() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA1, SCHEMA1, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA1), (Object)result);
    }

    @Test
    void testNoConflictBackwardsCompatible1() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA1, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA2), (Object)result);
    }

    @Test
    void testNoConflictBackwardsCompatible2() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA1, SCHEMA2, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA2), (Object)result);
    }

    @Test
    void testNoConflictConcurrentEvolutionSameSchema() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA2, true, false);
        Schema result = (Schema)this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).get();
        Assertions.assertEquals((Object)new Schema.Parser().parse(SCHEMA2), (Object)result);
    }

    @Test
    void testCompactionTableServiceSkipSchemaEvolutionCheck() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA3, true, false);
        boolean hasSchema = this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.tableCompactionOwnerInstant).isPresent();
        Assertions.assertFalse((boolean)hasSchema);
    }

    @Test
    void testClusteringInstantSkipsSchemaCheck() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA3, true, false);
        boolean hasSchema = this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.tableClusteringOwnerInstant).isPresent();
        Assertions.assertFalse((boolean)hasSchema);
    }

    @Test
    void testLegacyClusteringInstantSkipsSchemaCheck() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA3, true, true);
        boolean hasSchema = this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, this.tableReplacementOwnerInstant).isPresent();
        Assertions.assertFalse((boolean)hasSchema);
    }

    @Test
    void testNoCurrentTxnOptionSkipSchemaEvolutionCheck() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA3, true, false);
        boolean hasResult = this.strategy.resolveConcurrentSchemaEvolution((HoodieTable)this.table, this.config, this.lastCompletedTxnOwnerInstant, Option.empty()).isPresent();
        Assertions.assertFalse((boolean)hasResult);
    }

    @Test
    void testSchemaConflictResolutionDisabled() throws Exception {
        this.setupInstants(SCHEMA1, SCHEMA2, SCHEMA2, false, false);
        boolean hasSchema = TransactionUtils.resolveSchemaConflictIfNeeded((HoodieTable)this.table, (HoodieWriteConfig)this.config, this.lastCompletedTxnOwnerInstant, this.nonTableCompactionInstant).isPresent();
        Assertions.assertFalse((boolean)hasSchema);
    }

    private Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> getGetDummyClusteringMetadata() {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.toString());
        requestedReplaceMetadata.setVersion(Integer.valueOf(1));
        HoodieSliceInfo sliceInfo = HoodieSliceInfo.newBuilder().setFileId("id1").build();
        ArrayList<HoodieClusteringGroup> clusteringGroups = new ArrayList<HoodieClusteringGroup>();
        clusteringGroups.add(HoodieClusteringGroup.newBuilder().setVersion(Integer.valueOf(1)).setNumOutputFileGroups(Integer.valueOf(1)).setMetrics(Collections.emptyMap()).setSlices(Collections.singletonList(sliceInfo)).build());
        requestedReplaceMetadata.setExtraMetadata(Collections.emptyMap());
        requestedReplaceMetadata.setClusteringPlan(HoodieClusteringPlan.newBuilder().setVersion(Integer.valueOf(1)).setExtraMetadata(Collections.emptyMap()).setStrategy(HoodieClusteringStrategy.newBuilder().setStrategyClassName("").setVersion(Integer.valueOf(1)).build()).setInputGroups(clusteringGroups).build());
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        replaceMetadata.addReplaceFileId("parititon", "replacedFileId");
        replaceMetadata.setOperationType(WriteOperationType.CLUSTER);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setPartitionPath("partition");
        writeStat.setPath("partition/" + HoodieTestCommitGenerator.getBaseFilename(((HoodieInstant)this.tableReplacementOwnerInstant.get()).requestedTime(), "newFileId"));
        writeStat.setFileId("newFileId");
        writeStat.setTotalWriteBytes(1L);
        writeStat.setFileSizeInBytes(1L);
        replaceMetadata.addWriteStat("partition", writeStat);
        return Pair.of((Object)requestedReplaceMetadata, (Object)replaceMetadata);
    }
}

