/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProvider;
import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.metrics.HoodieLockMetrics;
import org.apache.hudi.client.transaction.lock.models.HeartbeatManager;
import org.apache.hudi.client.transaction.lock.models.LockGetResult;
import org.apache.hudi.client.transaction.lock.models.LockUpsertResult;
import org.apache.hudi.client.transaction.lock.models.StorageLockData;
import org.apache.hudi.client.transaction.lock.models.StorageLockFile;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.StorageBasedLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

class TestStorageBasedLockProvider {
    private StorageBasedLockProvider lockProvider;
    private StorageLockClient mockLockService;
    private HeartbeatManager mockHeartbeatManager;
    private Logger mockLogger;
    private final String ownerId = UUID.randomUUID().toString();
    private static final int DEFAULT_LOCK_VALIDITY_MS = 10000;

    TestStorageBasedLockProvider() {
    }

    @BeforeEach
    void setupLockProvider() {
        this.mockLockService = (StorageLockClient)Mockito.mock(StorageLockClient.class);
        this.mockHeartbeatManager = (HeartbeatManager)Mockito.mock(HeartbeatManager.class);
        this.mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.mockHeartbeatManager.stopHeartbeat(true)).thenReturn((Object)true);
        Mockito.when((Object)this.mockLockService.readObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)Option.empty());
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-default");
        this.lockProvider = (StorageBasedLockProvider)Mockito.spy((Object)new StorageBasedLockProvider(this.ownerId, props, (Functions.Function3 & Serializable)(a, b, c) -> this.mockHeartbeatManager, (Functions.Function3 & Serializable)(a, b, c) -> this.mockLockService, this.mockLogger, null));
    }

    @AfterEach
    void cleanupLockProvider() {
        this.lockProvider.close();
    }

    @Test
    void testValidLockStorageLocation() {
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"s3://bucket/lake/db/tbl-default");
        LockConfiguration lockConf = new LockConfiguration((Properties)props);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieLockException ex = (HoodieLockException)Assertions.assertThrows(HoodieLockException.class, () -> new StorageBasedLockProvider(lockConf, storageConf));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Failed to load and initialize StorageLock"));
    }

    @ParameterizedTest
    @ValueSource(strings={"gs://bucket/lake/db/tbl-default", "s3://bucket/lake/db/tbl-default", "s3a://bucket/lake/db/tbl-default"})
    void testNonExistentWriteServiceWithDefaults(String tableBasePathString) {
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)tableBasePathString);
        LockConfiguration lockConf = new LockConfiguration((Properties)props);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieLockException ex = (HoodieLockException)Assertions.assertThrows(HoodieLockException.class, () -> new StorageBasedLockProvider(lockConf, storageConf));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Failed to load and initialize StorageLock"));
    }

    @Test
    void testTryLockForTimeUnitThrowsOnInterrupt() throws Exception {
        ((StorageBasedLockProvider)Mockito.doReturn((Object)false).when((Object)this.lockProvider)).tryLock();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            try {
                this.lockProvider.tryLock(1L, TimeUnit.SECONDS);
            }
            catch (HoodieLockException e) {
                latch.countDown();
            }
        });
        t.start();
        Thread.sleep(50L);
        t.interrupt();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    void testTryLockForTimeUnitAcquiresLockEventually() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        ((StorageBasedLockProvider)Mockito.doAnswer(inv -> count.incrementAndGet() > 2).when((Object)this.lockProvider)).tryLock();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            Assertions.assertTrue((boolean)this.lockProvider.tryLock(4L, TimeUnit.SECONDS));
            latch.countDown();
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    void testTryLockForTimeUnitFailsToAcquireLockEventually() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        ((StorageBasedLockProvider)Mockito.doAnswer(inv -> count.incrementAndGet() > 2).when((Object)this.lockProvider)).tryLock();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            Assertions.assertFalse((boolean)this.lockProvider.tryLock(1L, TimeUnit.SECONDS));
            latch.countDown();
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    void testTryLockSuccess() {
        long t0 = 1000L;
        Mockito.when((Object)this.lockProvider.getCurrentEpochMs()).thenReturn((Object)t0);
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, t0 + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.refEq((Object)data, (String[])new String[0]), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertTrue((boolean)acquired);
        Assertions.assertEquals((Object)realLockFile, (Object)this.lockProvider.getLock());
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.atLeastOnce())).tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
    }

    @Test
    void testTryLockSuccessButFailureToStartHeartbeat() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)realLockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertFalse((boolean)acquired);
    }

    @Test
    void testTryLockFailsFromOwnerMismatch() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockFile returnedLockFile = new StorageLockFile(new StorageLockData(false, System.currentTimeMillis() + 10000L, "different-owner"), "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)returnedLockFile)));
        HoodieLockException ex = (HoodieLockException)Assertions.assertThrows(HoodieLockException.class, () -> this.lockProvider.tryLock());
        Assertions.assertTrue((boolean)ex.getMessage().contains("Owners do not match"));
    }

    @Test
    void testTryLockFailsDueToExistingLock() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, "other-owner");
        StorageLockFile existingLock = new StorageLockFile(data, "v2");
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.SUCCESS, (Object)Option.of((Object)existingLock)));
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertFalse((boolean)acquired);
    }

    @Test
    void testTryLockFailsToUpdateFile() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.ACQUIRED_BY_OTHERS, (Object)Option.empty()));
        Assertions.assertFalse((boolean)this.lockProvider.tryLock());
    }

    @Test
    void testTryLockFailsDueToUnknownState() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.UNKNOWN_ERROR, (Object)Option.empty()));
        Assertions.assertFalse((boolean)this.lockProvider.tryLock());
    }

    @Test
    void testTryLockSucceedsWhenExistingLockExpiredByTime() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() - 10000L, "other-owner");
        StorageLockFile existingLock = new StorageLockFile(data, "v2");
        StorageLockData newData = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(newData, "v1");
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.SUCCESS, (Object)Option.of((Object)existingLock)));
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)existingLock)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertTrue((boolean)acquired);
    }

    @Test
    void testTryLockReentrancySucceeds() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertTrue((boolean)acquired);
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
    }

    @Test
    void testTryLockReentrancyAfterLockExpiredByTime() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() - 10000L, this.ownerId);
        StorageLockFile expiredLock = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)expiredLock).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData validData = new StorageLockData(false, System.currentTimeMillis() - 10000L, this.ownerId);
        StorageLockFile validLock = new StorageLockFile(validData, "v2");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)validLock)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
    }

    @Test
    void testTryLockReentrancyAfterLockSetExpired() {
        StorageLockData data = new StorageLockData(true, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile expiredLock = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)expiredLock).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData validData = new StorageLockData(false, System.currentTimeMillis() - 10000L, this.ownerId);
        StorageLockFile validLock = new StorageLockFile(validData, "v2");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)validLock)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
    }

    @Test
    void testTryLockHeartbeatStillActive() {
        StorageLockData data = new StorageLockData(true, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile expiredLock = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)expiredLock).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieLockException.class, () -> this.lockProvider.tryLock());
    }

    @Test
    void testUnlockSucceedsAndReentrancy() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.mockHeartbeatManager.stopHeartbeat(true)).thenReturn((Object)true);
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)realLockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)new StorageLockFile(new StorageLockData(true, data.getValidUntil(), this.ownerId), "v2"))));
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)true).thenReturn((Object)false);
        this.lockProvider.unlock();
        Assertions.assertNull((Object)this.lockProvider.getLock());
        this.lockProvider.unlock();
    }

    @Test
    void testUnlockFailsToStopHeartbeat() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
        Mockito.when((Object)this.mockHeartbeatManager.stopHeartbeat(true)).thenReturn((Object)false);
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieLockException.class, () -> this.lockProvider.unlock());
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)false);
    }

    @Test
    void testCloseFailsToStopHeartbeat() {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.lockProvider.tryLock());
        Mockito.when((Object)this.mockHeartbeatManager.stopHeartbeat(true)).thenReturn((Object)false);
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)true);
        this.lockProvider.close();
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)false);
    }

    @Test
    void testRenewLockReturnsFalseWhenNoLockHeld() {
        ((StorageBasedLockProvider)Mockito.doReturn(null).when((Object)this.lockProvider)).getLock();
        Assertions.assertFalse((boolean)this.lockProvider.renewLock());
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)true);
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn("Owner {}: Cannot renew, no lock held by this process", (Object)this.ownerId);
    }

    @Test
    void testRenewLockWithoutHoldingLock() {
        ((StorageBasedLockProvider)Mockito.doReturn(null).when((Object)this.lockProvider)).getLock();
        Assertions.assertFalse((boolean)this.lockProvider.renewLock());
        Mockito.when((Object)this.mockHeartbeatManager.hasActiveHeartbeat()).thenReturn((Object)false);
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn("Owner {}: Cannot renew, no lock held by this process", (Object)this.ownerId);
    }

    @Test
    void testRenewLockWithFullyExpiredLock() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() - 10000L, this.ownerId);
        StorageLockFile nearExpiredLockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)nearExpiredLockFile).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)nearExpiredLockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.ACQUIRED_BY_OTHERS, null));
        Assertions.assertFalse((boolean)this.lockProvider.renewLock());
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("Owner {}: Unable to renew lock as it is acquired by others.", (Object)this.ownerId);
    }

    @Test
    void testRenewLockUnableToUpsertLockFileButNotFatal() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)lockFile).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)lockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.UNKNOWN_ERROR, (Object)Option.empty()));
        Assertions.assertTrue((boolean)this.lockProvider.renewLock());
    }

    @Test
    void testRenewLockUnableToUpsertLockFileFatal() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)lockFile).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)lockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.UNKNOWN_ERROR, (Object)Option.empty()));
        Assertions.assertTrue((boolean)this.lockProvider.renewLock());
        ((Logger)Mockito.verify((Object)this.mockLogger)).warn("Owner {}: Unable to renew lock due to unknown error, could be transient.", (Object)this.ownerId);
    }

    @Test
    void testRenewLockSucceedsButRenewalWithinExpirationWindow() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)lockFile).when((Object)this.lockProvider)).getLock();
        StorageLockData nearExpirationData = new StorageLockData(false, System.currentTimeMillis(), this.ownerId);
        StorageLockFile lockFileNearExpiration = new StorageLockFile(nearExpirationData, "v2");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)lockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)lockFileNearExpiration)));
        Assertions.assertTrue((boolean)this.lockProvider.renewLock());
    }

    @Test
    void testRenewLockSucceeds() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)lockFile).when((Object)this.lockProvider)).getLock();
        StorageLockData successData = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile successLockFile = new StorageLockFile(successData, "v2");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)lockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)successLockFile)));
        Assertions.assertTrue((boolean)this.lockProvider.renewLock());
        ((Logger)Mockito.verify((Object)this.mockLogger)).info((String)ArgumentMatchers.eq((Object)"Owner {}: Lock renewal successful. The renewal completes {} ms before expiration for lock {}."), new Object[]{ArgumentMatchers.eq((Object)this.ownerId), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((Object)"gs://bucket/lake/db/tbl-default/.hoodie/.locks/table_lock.json")});
    }

    @Test
    void testRenewLockFails() {
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        ((StorageBasedLockProvider)Mockito.doReturn((Object)lockFile).when((Object)this.lockProvider)).getLock();
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.of((Object)lockFile)))).thenThrow(new Throwable[]{new RuntimeException("Failure")});
        Assertions.assertFalse((boolean)this.lockProvider.renewLock());
        ((Logger)Mockito.verify((Object)this.mockLogger)).error((String)ArgumentMatchers.eq((Object)"Owner {}: Exception occurred while renewing lock"), ArgumentMatchers.eq((Object)this.ownerId), ArgumentMatchers.any(RuntimeException.class));
    }

    @Test
    void testCloseCallsDependencies() throws Exception {
        this.lockProvider.close();
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.atLeastOnce())).close();
        ((HeartbeatManager)Mockito.verify((Object)this.mockHeartbeatManager, (VerificationMode)Mockito.atLeastOnce())).close();
        Assertions.assertNull((Object)this.lockProvider.getLock());
    }

    @Test
    void testCloseWithErrorForLockService() throws Exception {
        ((StorageLockClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Some failure")}).when((Object)this.mockLockService)).close();
        this.lockProvider.close();
        ((Logger)Mockito.verify((Object)this.mockLogger)).error((String)ArgumentMatchers.eq((Object)"Owner {}: Lock service failed to close."), ArgumentMatchers.eq((Object)this.ownerId), ArgumentMatchers.any(RuntimeException.class));
        Assertions.assertNull((Object)this.lockProvider.getLock());
    }

    @Test
    void testCloseWithErrorForHeartbeatManager() throws Exception {
        ((HeartbeatManager)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Some failure")}).when((Object)this.mockHeartbeatManager)).close();
        this.lockProvider.close();
        ((Logger)Mockito.verify((Object)this.mockLogger)).error((String)ArgumentMatchers.eq((Object)"Owner {}: Heartbeat manager failed to close."), ArgumentMatchers.eq((Object)this.ownerId), ArgumentMatchers.any(RuntimeException.class));
        Assertions.assertNull((Object)this.lockProvider.getLock());
    }

    @Test
    public void testShutdownHookViaReflection() throws Exception {
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile realLockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        boolean acquired = this.lockProvider.tryLock();
        Assertions.assertTrue((boolean)acquired);
        Assertions.assertEquals((Object)realLockFile, (Object)this.lockProvider.getLock());
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.atLeastOnce())).tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Mockito.when((Object)this.mockLockService.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(StorageLockData.class), (Option)ArgumentMatchers.eq((Object)Option.of((Object)realLockFile)))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)realLockFile)));
        Method shutdownMethod = this.lockProvider.getClass().getDeclaredMethod("shutdown", Boolean.TYPE);
        shutdownMethod.setAccessible(true);
        shutdownMethod.invoke((Object)this.lockProvider, true);
        Assertions.assertNull((Object)this.lockProvider.getLock());
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.never())).close();
        ((HeartbeatManager)Mockito.verify((Object)this.mockHeartbeatManager, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testShutdownHookWhenNoLockPresent() throws Exception {
        Method shutdownMethod = this.lockProvider.getClass().getDeclaredMethod("shutdown", Boolean.TYPE);
        shutdownMethod.setAccessible(true);
        shutdownMethod.invoke((Object)this.lockProvider, true);
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.never())).close();
        ((HeartbeatManager)Mockito.verify((Object)this.mockHeartbeatManager, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testShutdownHookFailsToBeRemoved() throws Exception {
        ((StorageBasedLockProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Shutdown already in progress")}).when((Object)this.lockProvider)).tryRemoveShutdownHook();
        this.lockProvider.close();
        ((StorageLockClient)Mockito.verify((Object)this.mockLockService, (VerificationMode)Mockito.atLeastOnce())).close();
        ((HeartbeatManager)Mockito.verify((Object)this.mockHeartbeatManager, (VerificationMode)Mockito.atLeastOnce())).close();
        Assertions.assertNull((Object)this.lockProvider.getLock());
    }

    @Test
    void testShutdownHookFiresDuringTryLockWithTimeout() throws Exception {
        StorageLockData otherOwnerData = new StorageLockData(false, System.currentTimeMillis() + 10000L, "other-owner");
        StorageLockFile otherOwnerLock = new StorageLockFile(otherOwnerData, "v1");
        Mockito.when((Object)this.mockLockService.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.SUCCESS, (Object)Option.of((Object)otherOwnerLock)));
        CountDownLatch tryLockStarted = new CountDownLatch(1);
        CountDownLatch proceedWithShutdown = new CountDownLatch(1);
        CountDownLatch shutdownCompleted = new CountDownLatch(1);
        CountDownLatch tryLockCompleted = new CountDownLatch(1);
        CountDownLatch exceptionThrown = new CountDownLatch(1);
        AtomicInteger tryLockCallCount = new AtomicInteger(0);
        ((StorageBasedLockProvider)Mockito.doAnswer(inv -> {
            int count = tryLockCallCount.incrementAndGet();
            if (count == 1) {
                tryLockStarted.countDown();
                Assertions.assertTrue((boolean)proceedWithShutdown.await(2L, TimeUnit.SECONDS));
            } else {
                Assertions.assertTrue((boolean)shutdownCompleted.await(100L, TimeUnit.MILLISECONDS));
            }
            return inv.callRealMethod();
        }).when((Object)this.lockProvider)).tryLock();
        Thread tryLockThread = new Thread(() -> {
            try {
                this.lockProvider.tryLock(2L, TimeUnit.SECONDS);
                Assertions.fail((String)"Should have thrown HoodieLockException after shutdown");
            }
            catch (HoodieLockException e) {
                exceptionThrown.countDown();
            }
            finally {
                tryLockCompleted.countDown();
            }
        });
        tryLockThread.start();
        Assertions.assertTrue((boolean)tryLockStarted.await(2L, TimeUnit.SECONDS), (String)"tryLock should have started");
        Method shutdownMethod = this.lockProvider.getClass().getDeclaredMethod("shutdown", Boolean.TYPE);
        shutdownMethod.setAccessible(true);
        Thread shutdownThread = new Thread(() -> {
            try {
                proceedWithShutdown.countDown();
                shutdownMethod.invoke((Object)this.lockProvider, true);
                shutdownCompleted.countDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        shutdownThread.start();
        Assertions.assertTrue((boolean)tryLockCompleted.await(5L, TimeUnit.SECONDS), (String)"tryLock should complete");
        Assertions.assertTrue((boolean)exceptionThrown.await(1L, TimeUnit.SECONDS), (String)"HoodieLockException should have been thrown");
        shutdownThread.join(2000L);
        Assertions.assertNull((Object)this.lockProvider.getLock(), (String)"Lock should be null after shutdown hook fires");
        ((StorageBasedLockProvider)Mockito.verify((Object)this.lockProvider, (VerificationMode)Mockito.atLeastOnce())).tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageBasedLockProviderWithMetricsConstructor() {
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-default");
        LockConfiguration lockConfiguration = new LockConfiguration((Properties)props);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieLockMetrics mockMetrics = (HoodieLockMetrics)Mockito.mock(HoodieLockMetrics.class);
        try (StorageBasedLockProvider lockProviderWithMetrics = null;){
            Assertions.assertThrows(Exception.class, () -> new StorageBasedLockProvider(lockConfiguration, storageConf, mockMetrics), (String)"Constructor should exist but fail during lock client instantiation");
            lockProviderWithMetrics = new StorageBasedLockProvider(UUID.randomUUID().toString(), props, (Functions.Function3 & Serializable)(a, b, c) -> (HeartbeatManager)Mockito.mock(HeartbeatManager.class), (Functions.Function3 & Serializable)(a, b, c) -> new StubStorageLockClient((String)a, (String)b, new Properties()), (Logger)Mockito.mock(Logger.class), mockMetrics);
            Assertions.assertNotNull((Object)lockProviderWithMetrics, (String)"StorageBasedLockProvider should be created successfully");
            Assertions.assertNull((Object)lockProviderWithMetrics.getLock(), (String)"Initially should have no lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageBasedLockProviderStandardConstructor() {
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-default");
        LockConfiguration lockConfiguration = new LockConfiguration((Properties)props);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        try (StorageBasedLockProvider lockProviderStandard = null;){
            Assertions.assertThrows(Exception.class, () -> new StorageBasedLockProvider(lockConfiguration, storageConf), (String)"Standard constructor should exist but fail during lock client instantiation");
            lockProviderStandard = new StorageBasedLockProvider(UUID.randomUUID().toString(), props, (Functions.Function3 & Serializable)(a, b, c) -> (HeartbeatManager)Mockito.mock(HeartbeatManager.class), (Functions.Function3 & Serializable)(a, b, c) -> new StubStorageLockClient((String)a, (String)b, new Properties()), (Logger)Mockito.mock(Logger.class), null);
            Assertions.assertNotNull((Object)lockProviderStandard, (String)"StorageBasedLockProvider should be created successfully");
            Assertions.assertNull((Object)lockProviderStandard.getLock(), (String)"Initially should have no lock");
        }
    }

    @Test
    void testAuditServiceIntegrationWhenConfigNotPresent() {
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-audit-test");
        StorageLockClient auditMockClient = (StorageLockClient)Mockito.mock(StorageLockClient.class);
        Mockito.when((Object)auditMockClient.readObject(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.empty());
        Mockito.when((Object)auditMockClient.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageBasedLockProvider auditLockProvider = new StorageBasedLockProvider(this.ownerId, props, (Functions.Function3 & Serializable)(a, b, c) -> this.mockHeartbeatManager, (Functions.Function3 & Serializable)(a, b, c) -> auditMockClient, this.mockLogger, null);
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)auditMockClient.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)lockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)auditLockProvider.tryLock());
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.times((int)1))).readObject(ArgumentMatchers.contains((String)".locks/audit_enabled.json"), ArgumentMatchers.eq((boolean)true));
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.never())).writeObject(ArgumentMatchers.contains((String)".locks/audit"), ArgumentMatchers.anyString());
        auditLockProvider.close();
    }

    @Test
    void testAuditServiceIntegrationWhenConfigDisabled() {
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-audit-disabled");
        StorageLockClient auditMockClient = (StorageLockClient)Mockito.mock(StorageLockClient.class);
        String disabledConfig = "{\"STORAGE_LOCK_AUDIT_SERVICE_ENABLED\": false}";
        Mockito.when((Object)auditMockClient.readObject(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)disabledConfig));
        Mockito.when((Object)auditMockClient.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        StorageBasedLockProvider auditLockProvider = new StorageBasedLockProvider(this.ownerId, props, (Functions.Function3 & Serializable)(a, b, c) -> this.mockHeartbeatManager, (Functions.Function3 & Serializable)(a, b, c) -> auditMockClient, this.mockLogger, null);
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)auditMockClient.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)lockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)auditLockProvider.tryLock());
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.times((int)1))).readObject(ArgumentMatchers.contains((String)".locks/audit_enabled.json"), ArgumentMatchers.eq((boolean)true));
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.never())).writeObject(ArgumentMatchers.contains((String)".locks/audit"), ArgumentMatchers.anyString());
        auditLockProvider.close();
    }

    @Test
    void testAuditServiceIntegrationWhenConfigEnabled() {
        TypedProperties props = new TypedProperties();
        props.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)"10");
        props.put((Object)StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), (Object)"1");
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-audit-enabled");
        StorageLockClient auditMockClient = (StorageLockClient)Mockito.mock(StorageLockClient.class);
        String enabledConfig = "{\"STORAGE_LOCK_AUDIT_SERVICE_ENABLED\": true}";
        Mockito.when((Object)auditMockClient.readObject(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)enabledConfig));
        Mockito.when((Object)auditMockClient.readCurrentLockFile()).thenReturn((Object)Pair.of((Object)LockGetResult.NOT_EXISTS, (Object)Option.empty()));
        Mockito.when((Object)auditMockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        StorageBasedLockProvider auditLockProvider = new StorageBasedLockProvider(this.ownerId, props, (Functions.Function3 & Serializable)(a, b, c) -> this.mockHeartbeatManager, (Functions.Function3 & Serializable)(a, b, c) -> auditMockClient, this.mockLogger, null);
        StorageLockData data = new StorageLockData(false, System.currentTimeMillis() + 10000L, this.ownerId);
        StorageLockFile lockFile = new StorageLockFile(data, "v1");
        Mockito.when((Object)auditMockClient.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)Option.empty()))).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)lockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.startHeartbeatForThread((Thread)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)auditLockProvider.tryLock());
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.times((int)1))).readObject(ArgumentMatchers.contains((String)".locks/audit_enabled.json"), ArgumentMatchers.eq((boolean)true));
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.times((int)1))).writeObject(ArgumentMatchers.contains((String)".locks/audit/"), ArgumentMatchers.anyString());
        Mockito.when((Object)auditMockClient.tryUpsertLockFile((StorageLockData)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)Pair.of((Object)LockUpsertResult.SUCCESS, (Object)Option.of((Object)lockFile)));
        Mockito.when((Object)this.mockHeartbeatManager.stopHeartbeat(ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
        auditLockProvider.unlock();
        ((StorageLockClient)Mockito.verify((Object)auditMockClient, (VerificationMode)Mockito.times((int)2))).writeObject(ArgumentMatchers.contains((String)".locks/audit/"), ArgumentMatchers.anyString());
        auditLockProvider.close();
    }

    public static class StubStorageLockClient
    implements StorageLockClient {
        public StubStorageLockClient(String ownerId, String lockFileUri, Properties props) {
            Assertions.assertTrue((boolean)lockFileUri.endsWith("table_lock.json"));
        }

        public Pair<LockUpsertResult, Option<StorageLockFile>> tryUpsertLockFile(StorageLockData newLockData, Option<StorageLockFile> previousLockFile) {
            return null;
        }

        public Pair<LockGetResult, Option<StorageLockFile>> readCurrentLockFile() {
            return null;
        }

        public Option<String> readObject(String filePath, boolean checkExistsFirst) {
            return Option.empty();
        }

        public boolean writeObject(String filePath, String content) {
            return true;
        }

        public void close() throws Exception {
        }
    }
}

