/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.hudi.client.transaction.FileSystemBasedLockProviderTestClass;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.client.transaction.lock.NoopLockProvider;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieWriteConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPropertyLoading(boolean withAlternative) throws IOException {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put(HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key(), "1");
        params.put(HoodieArchivalConfig.MAX_COMMITS_TO_KEEP.key(), "5");
        params.put(HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), "2");
        params.put(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "6");
        if (withAlternative) {
            params.put("hoodie.avro.schema.externalTransformation", "true");
        } else {
            params.put("hoodie.avro.schema.external.transformation", "true");
        }
        ByteArrayOutputStream outStream = this.saveParamsIntoOutputStream(params);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
        try {
            builder = builder.fromInputStream((InputStream)inputStream);
        }
        finally {
            outStream.close();
            inputStream.close();
        }
        HoodieWriteConfig config = builder.build();
        Assertions.assertEquals((int)5, (int)config.getMaxCommitsToKeep());
        Assertions.assertEquals((int)2, (int)config.getMinCommitsToKeep());
        Assertions.assertTrue((boolean)config.shouldUseExternalSchemaTransformation());
        Assertions.assertTrue((boolean)config.allowDuplicateInserts());
    }

    @Test
    public void testSupportedTableWriteVersions() {
        Set supportedVersions = CollectionUtils.createSet((Object[])new HoodieTableVersion[]{HoodieTableVersion.SIX, HoodieTableVersion.EIGHT, HoodieTableVersion.NINE});
        Arrays.stream(HoodieTableVersion.values()).filter(version -> !supportedVersions.contains(version)).forEach(version -> {
            Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieWriteConfig.newBuilder().withPath("/tmp").withWriteTableVersion(version.versionCode()).build());
            Properties props = new Properties();
            props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), String.valueOf(version.versionCode()));
            Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).build().getWriteVersion());
        });
        Arrays.stream(HoodieTableVersion.values()).filter(supportedVersions::contains).forEach(version -> {
            Assertions.assertEquals((Object)version, (Object)HoodieWriteConfig.newBuilder().withPath("/tmp").withWriteTableVersion(version.versionCode()).build().getWriteVersion());
            Properties props = new Properties();
            props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), String.valueOf(version.versionCode()));
            Assertions.assertEquals((Object)version, (Object)HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).build().getWriteVersion());
        });
    }

    @Test
    public void testDefaultIndexAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getIndexType, this.constructConfigMap(EngineType.SPARK, HoodieIndex.IndexType.SIMPLE, EngineType.FLINK, HoodieIndex.IndexType.INMEMORY, EngineType.JAVA, HoodieIndex.IndexType.SIMPLE));
    }

    @Test
    public void testDefaultClusteringPlanStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringPlanStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.plan.strategy.FlinkSizeBasedClusteringPlanStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy"));
    }

    @Test
    public void testDefaultClusteringExecutionStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringExecutionStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy"));
    }

    @Test
    public void testDefaultMarkersTypeAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getMarkersType, this.constructConfigMap(EngineType.SPARK, MarkerType.TIMELINE_SERVER_BASED, EngineType.FLINK, MarkerType.DIRECT, EngineType.JAVA, MarkerType.DIRECT));
    }

    @Test
    public void testInferCleaningPolicy() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(10).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().cleanerNumHoursRetained(96).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainFileVersions(2).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().cleanerNumHoursRetained(96).retainFileVersions(2).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).retainFileVersions(2).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS, (Object)writeConfig.getCleanerPolicy());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).retainCommits(10).cleanerNumHoursRetained(96).retainFileVersions(2).build()).build();
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS, (Object)writeConfig.getCleanerPolicy());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithTableServices(final HoodieTableType tableType) {
        String inProcessLockProviderClassName = InProcessLockProvider.class.getCanonicalName();
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), inProcessLockProviderClassName);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), inProcessLockProviderClassName);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, tableType == HoodieTableType.MERGE_ON_READ, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), tableType == HoodieTableType.COPY_ON_WRITE ? null : InProcessLockProvider.class.getName());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieArchivalConfig.ASYNC_ARCHIVE.key(), "true");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, false, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), inProcessLockProviderClassName);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoAdjustLockConfigsSingleWriter(HoodieTableType tableType) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.TYPE.key(), tableType.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(true).withClusteringConfig(new HoodieClusteringConfig.Builder().withInlineClustering(Boolean.valueOf(true)).build()).withProperties((Properties)properties).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(true)).build()).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(true).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(FileSystemBasedLockProviderTestClass.class).build()).withClusteringConfig(new HoodieClusteringConfig.Builder().withInlineClustering(Boolean.valueOf(true)).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(true)).build()).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), InProcessLockProvider.class.getName());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoAdjustLockConfigs(HoodieTableType tableType) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.TYPE.key(), tableType.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(false).withClusteringConfig(new HoodieClusteringConfig.Builder().withAsyncClustering(Boolean.valueOf(true)).build()).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(false).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withClusteringConfig(new HoodieClusteringConfig.Builder().withAsyncClustering(Boolean.valueOf(true)).build()).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, InProcessLockProvider.class.getName());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithUserConfigs(final HoodieTableType tableType) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.TYPE.key(), tableType.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(FileSystemBasedLockProviderTestClass.class).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(true)).build()).withAutoAdjustLockConfigs(true).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), InProcessLockProvider.class.getName());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), ZookeeperBasedLockProvider.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), ZookeeperBasedLockProvider.class.getName());
        writeConfig = this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        });
        if (writeConfig.areAnyTableServicesAsync().booleanValue()) {
            this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), InProcessLockProvider.class.getName());
        } else {
            this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithNoTableService(final HoodieTableType tableType) {
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.TABLE_SERVICES_ENABLED.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), false, false, false, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.TABLE_SERVICES_ENABLED.key(), "true");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), InProcessLockProvider.class.getName());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.TABLE_SERVICES_ENABLED.key(), "false");
                this.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), FileSystemBasedLockProviderTestClass.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), false, false, false, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, FileSystemBasedLockProviderTestClass.class.getName());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithMetadataTableDisabled(final HoodieTableType tableType) {
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieMetadataConfig.ENABLE.key(), "false");
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), null);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), FileSystemBasedLockProviderTestClass.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, FileSystemBasedLockProviderTestClass.class.getName());
    }

    @Test
    public void testTimeGeneratorConfig() {
        HoodieWriteConfig writeConfig = this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), HoodieTableType.COPY_ON_WRITE.name());
            }
        });
        Assertions.assertEquals((Object)InProcessLockProvider.class.getName(), (Object)writeConfig.getTimeGeneratorConfig().getLockConfiguration().getConfig().getProperty(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()));
        writeConfig = this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), HoodieTableType.COPY_ON_WRITE.name());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), NoopLockProvider.class.getName());
            }
        });
        Assertions.assertEquals((Object)NoopLockProvider.class.getName(), (Object)writeConfig.getTimeGeneratorConfig().getLockConfiguration().getConfig().getProperty(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()));
        writeConfig = this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), HoodieTableType.COPY_ON_WRITE.name());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), NoopLockProvider.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        });
        Assertions.assertEquals((Object)InProcessLockProvider.class.getName(), (Object)writeConfig.getTimeGeneratorConfig().getLockConfiguration().getConfig().getProperty(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()));
    }

    @Test
    public void testConsistentBucketIndexDefaultClusteringConfig() {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING).build()).build();
        Assertions.assertEquals((Object)"org.apache.hudi.client.clustering.plan.strategy.SparkConsistentBucketClusteringPlanStrategy", (Object)writeConfig.getClusteringPlanStrategyClass());
        Assertions.assertEquals((Object)"org.apache.hudi.client.clustering.run.strategy.SingleSparkJobConsistentHashingExecutionStrategy", (Object)writeConfig.getClusteringExecutionStrategyClass());
    }

    @Test
    public void testConsistentBucketIndexInvalidClusteringConfig() {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        TypedProperties consistentBucketIndexProps = HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING).build().getProps();
        HoodieWriteConfig.Builder writeConfigBuilder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        Assertions.assertThrows(IllegalArgumentException.class, () -> writeConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().fromProperties((Properties)consistentBucketIndexProps).withClusteringPlanStrategyClass("org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy").build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> writeConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().fromProperties((Properties)consistentBucketIndexProps).withClusteringExecutionStrategyClass("org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy").build()));
    }

    @Test
    public void testSimpleBucketIndexPartitionerConfig() {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).build();
        Assertions.assertEquals((Object)"org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner", (Object)writeConfig.getString(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME));
        HoodieWriteConfig overwritePartitioner = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).withLayoutConfig(HoodieLayoutConfig.newBuilder().withLayoutPartitioner("org.apache.hudi.table.action.commit.UpsertPartitioner").build()).build();
        Assertions.assertEquals((Object)"org.apache.hudi.table.action.commit.UpsertPartitioner", (Object)overwritePartitioner.getString(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME));
    }

    @Test
    void testBloomIndexFileIdKeySortingConfig() {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BLOOM).enableBloomIndexFileGroupIdKeySorting(true).build()).build();
        Assertions.assertTrue((boolean)writeConfig.isBloomIndexFileGroupIdKeySortingEnabled());
    }

    @Test
    public void testAutoAdjustCleanPolicyForNonBlockingConcurrencyControl() {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties((Properties)props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).withWriteConcurrencyMode(WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, null);
    }

    @Test
    public void testNonBlockingConcurrencyControlInvalidEarlyConflictDetection() {
        Properties props = new Properties();
        props.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig.Builder writeConfigBuilder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        Assertions.assertThrows(IllegalArgumentException.class, () -> writeConfigBuilder.withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).withWriteConcurrencyMode(WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL).withEarlyConflictDetectionEnable(true).build(), (String)"To use early conflict detection, set hoodie.write.concurrency.mode=OPTIMISTIC_CONCURRENCY_CONTROL");
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testNonBlockingConcurrencyControlInvalidTableTypeOrIndexType(HoodieTableType tableType) {
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieTableConfig.TYPE.key(), (Object)tableType.name());
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig.Builder writeConfigBuilder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        Assertions.assertThrows(IllegalArgumentException.class, () -> writeConfigBuilder.withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties((Properties)props).withIndexType(HoodieIndex.IndexType.SIMPLE).build()).withWriteConcurrencyMode(WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL).build(), (String)"Non-blocking concurrency control requires the MOR table with simple bucket index");
    }

    @Test
    public void testFileSystemViewStorageConfigDefaults() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        Assertions.assertEquals((double)((double)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue()).longValue() * (Double)FileSystemViewStorageConfig.BOOTSTRAP_BASE_FILE_MEM_FRACTION.defaultValue()), (double)writeConfig.getViewStorageConfig().getMaxMemoryForBootstrapBaseFile());
        Assertions.assertEquals((double)((double)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue()).longValue() * (Double)FileSystemViewStorageConfig.SPILLABLE_COMPACTION_MEM_FRACTION.defaultValue()), (double)writeConfig.getViewStorageConfig().getMaxMemoryForPendingCompaction());
        Assertions.assertEquals((double)((double)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue()).longValue() * (Double)FileSystemViewStorageConfig.SPILLABLE_LOG_COMPACTION_MEM_FRACTION.defaultValue()), (double)writeConfig.getViewStorageConfig().getMaxMemoryForPendingLogCompaction());
        Assertions.assertEquals((double)((double)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue()).longValue() * (Double)FileSystemViewStorageConfig.SPILLABLE_CLUSTERING_MEM_FRACTION.defaultValue()), (double)writeConfig.getViewStorageConfig().getMaxMemoryForPendingClusteringFileGroups());
        Assertions.assertEquals((double)((double)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue()).longValue() * (Double)FileSystemViewStorageConfig.SPILLABLE_REPLACED_MEM_FRACTION.defaultValue()), (double)writeConfig.getViewStorageConfig().getMaxMemoryForReplacedFileGroups());
        Assertions.assertEquals((long)((Long)FileSystemViewStorageConfig.SPILLABLE_MEMORY.defaultValue() - writeConfig.getViewStorageConfig().getMaxMemoryForBootstrapBaseFile() - writeConfig.getViewStorageConfig().getMaxMemoryForPendingCompaction() - writeConfig.getViewStorageConfig().getMaxMemoryForPendingLogCompaction() - writeConfig.getViewStorageConfig().getMaxMemoryForPendingClusteringFileGroups() - writeConfig.getViewStorageConfig().getMaxMemoryForReplacedFileGroups()), (long)writeConfig.getViewStorageConfig().getMaxMemoryForFileGroupMap());
    }

    @Test
    void testBloomFilterType() {
        String bloomFilterType = BloomFilterTypeCode.SIMPLE.name();
        Assertions.assertNotEquals((Object)((String)HoodieStorageConfig.BLOOM_FILTER_TYPE.defaultValue()).toUpperCase(), (Object)bloomFilterType.toUpperCase());
        Properties props = new Properties();
        props.put(HoodieStorageConfig.BLOOM_FILTER_TYPE.key(), bloomFilterType);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).build();
        Assertions.assertEquals((Object)bloomFilterType, (Object)config.getBloomFilterType());
    }

    @Test
    public void testStreamingWritesToMetadataConfig() {
        Properties props = new Properties();
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).withMetadataConfig(HoodieMetadataConfig.newBuilder().withStreamingWriteEnabled(true).build()).withEngineType(EngineType.SPARK).build();
        Assertions.assertTrue((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.EIGHT));
        Assertions.assertFalse((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.SIX));
        config = HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).withEngineType(EngineType.FLINK).build();
        Assertions.assertFalse((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.SIX));
        Assertions.assertFalse((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.EIGHT));
        config = HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(props).withEngineType(EngineType.JAVA).build();
        Assertions.assertFalse((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.SIX));
        Assertions.assertFalse((boolean)config.isMetadataStreamingWritesEnabled(HoodieTableVersion.EIGHT));
    }

    private HoodieWriteConfig createWriteConfig(Map<String, String> configs) {
        Properties properties = new Properties();
        configs.forEach(properties::setProperty);
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(properties).build();
    }

    private ByteArrayOutputStream saveParamsIntoOutputStream(Map<String, String> params) throws IOException {
        Properties properties = new Properties();
        properties.putAll(params);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        properties.store(outStream, "Saved on " + new Date(System.currentTimeMillis()));
        return outStream;
    }

    private void testEngineSpecificConfig(Function<HoodieWriteConfig, Object> getConfigFunc, Map<EngineType, Object> expectedConfigMap) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        Assertions.assertEquals((Object)expectedConfigMap.get(EngineType.SPARK), (Object)getConfigFunc.apply(writeConfig));
        for (EngineType engineType : expectedConfigMap.keySet()) {
            writeConfig = HoodieWriteConfig.newBuilder().withEngineType(engineType).withPath("/tmp").build();
            Assertions.assertEquals((Object)expectedConfigMap.get(engineType), (Object)getConfigFunc.apply(writeConfig));
        }
    }

    private Map<EngineType, Object> constructConfigMap(EngineType k1, Object v1, EngineType k2, Object v2, EngineType k3, Object v3) {
        HashMap<EngineType, Object> mapping = new HashMap<EngineType, Object>();
        mapping.put(k1, v1);
        mapping.put(k2, v2);
        mapping.put(k3, v3);
        return mapping;
    }

    private void verifyConcurrencyControlRelatedConfigs(HoodieWriteConfig writeConfig, boolean expectedTableServicesEnabled, boolean expectedAnyTableServicesAsync, boolean expectedAnyTableServicesExecutedInline, WriteConcurrencyMode expectedConcurrencyMode, HoodieFailedWritesCleaningPolicy expectedCleanPolicy, String expectedLockProviderName) {
        Assertions.assertEquals((Object)expectedTableServicesEnabled, (Object)writeConfig.areTableServicesEnabled());
        Assertions.assertEquals((Object)expectedAnyTableServicesAsync, (Object)writeConfig.areAnyTableServicesAsync());
        Assertions.assertEquals((Object)expectedAnyTableServicesExecutedInline, (Object)writeConfig.areAnyTableServicesExecutedInline());
        Assertions.assertEquals((Object)expectedConcurrencyMode, (Object)writeConfig.getWriteConcurrencyMode());
        Assertions.assertEquals((Object)expectedCleanPolicy, (Object)writeConfig.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)expectedLockProviderName, (Object)writeConfig.getLockProviderClass());
    }
}

