/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.common.model.PartitionBucketIndexHashingConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexCalculator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestPartitionBucketIndexCalculator
extends HoodieCommonTestHarness {
    private static final String DEFAULT_RULE = "regex";
    private static final String DEFAULT_EXPRESSIONS = "\\d{4}-(06-(01|17|18)|11-(01|10|11)),256";
    private static final int DEFAULT_BUCKET_NUMBER = 10;
    private PartitionBucketIndexCalculator calc;

    void setUp(String expression, String rule, int defaultBucketNumber) throws IOException {
        this.initMetaClient();
        PartitionBucketIndexHashingConfig.saveHashingConfig((HoodieTableMetaClient)this.metaClient, (String)expression, (String)rule, (int)defaultBucketNumber, null);
        this.calc = PartitionBucketIndexCalculator.getInstance((String)expression, (String)rule, (int)defaultBucketNumber);
    }

    @AfterEach
    void cleanup() {
        if (this.calc == null) {
            return;
        }
        this.calc.cleanCache();
    }

    @ParameterizedTest(name="Partition {0} should map to bucket {1}")
    @MethodSource(value={"providePartitionsAndExpectedBuckets"})
    void testBasicRegexRuleMatching(String partition, int expectedBucket) throws IOException {
        this.setUp(DEFAULT_EXPRESSIONS, DEFAULT_RULE, 10);
        Assertions.assertEquals((int)expectedBucket, (int)this.calc.computeNumBuckets(partition));
    }

    @Test
    void testCaching() throws IOException {
        this.setUp(DEFAULT_EXPRESSIONS, DEFAULT_RULE, 10);
        String partition = "2023-06-01";
        int bucket1 = this.calc.computeNumBuckets(partition);
        Assertions.assertEquals((int)256, (int)bucket1);
        Assertions.assertEquals((long)1L, (long)this.calc.getCacheSize());
        int bucket2 = this.calc.computeNumBuckets(partition);
        Assertions.assertEquals((int)256, (int)bucket2);
        Assertions.assertEquals((long)1L, (long)this.calc.getCacheSize());
        this.calc.computeNumBuckets("2023-11-10");
        Assertions.assertEquals((long)2L, (long)this.calc.getCacheSize());
    }

    @ParameterizedTest
    @MethodSource(value={"testMultipleRegexRulesWithPriority"})
    void testMultipleRegexRulesWithPriority(String expressions, boolean hiveStyle, String format) throws IOException {
        this.setUp(expressions, DEFAULT_RULE, 10);
        PartitionBucketIndexCalculator calc = PartitionBucketIndexCalculator.getInstance((String)expressions, (String)DEFAULT_RULE, (int)10);
        Assertions.assertEquals((int)256, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s06%s01", format, format) : String.format("2023%s06%s01", format, format)));
        Assertions.assertEquals((int)128, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s06%s02", format, format) : String.format("2023%s06%s02", format, format)));
        Assertions.assertEquals((int)128, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s06%s30", format, format) : String.format("2023%s06%s30", format, format)));
        Assertions.assertEquals((int)64, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s11%s01", format, format) : String.format("2023%s11%s01", format, format)));
        Assertions.assertEquals((int)64, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s11%s30", format, format) : String.format("2023%s11%s30", format, format)));
        Assertions.assertEquals((int)10, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s07%s01", format, format) : String.format("2023%s07%s01", format, format)));
        Assertions.assertEquals((int)10, (int)calc.computeNumBuckets(hiveStyle ? String.format("dt=2023%s12%s25", format, format) : String.format("2023%s12%s25", format, format)));
    }

    @Test
    void testInvalidExpressions() {
        Assertions.assertThrows(HoodieException.class, () -> this.setUp("\\d{4-06-01256", DEFAULT_RULE, 10));
        Assertions.assertThrows(HoodieException.class, () -> this.setUp("\\d{4}-06-01,a", DEFAULT_RULE, 10));
    }

    private static Stream<Arguments> providePartitionsAndExpectedBuckets() {
        return Stream.of(Arguments.of((Object[])new Object[]{"2023-06-01", 256}), Arguments.of((Object[])new Object[]{"2023-06-17", 256}), Arguments.of((Object[])new Object[]{"2023-06-18", 256}), Arguments.of((Object[])new Object[]{"2023-11-01", 256}), Arguments.of((Object[])new Object[]{"2023-11-10", 256}), Arguments.of((Object[])new Object[]{"2023-11-11", 256}), Arguments.of((Object[])new Object[]{"2022-06-01", 256}), Arguments.of((Object[])new Object[]{"2021-11-10", 256}), Arguments.of((Object[])new Object[]{"2023-06-02", 10}), Arguments.of((Object[])new Object[]{"2023-06-19", 10}), Arguments.of((Object[])new Object[]{"2023-07-01", 10}), Arguments.of((Object[])new Object[]{"2023-11-12", 10}), Arguments.of((Object[])new Object[]{"2023-11-02", 10}), Arguments.of((Object[])new Object[]{"2023-05-01", 10}), Arguments.of((Object[])new Object[]{"not-a-date", 10}), Arguments.of((Object[])new Object[]{"", 10}));
    }

    private static Stream<Arguments> testMultipleRegexRulesWithPriority() {
        return Stream.of(Arguments.of((Object[])new Object[]{"\\d{4}-06-01,256;\\d{4}-06-\\d{2},128;\\d{4}-11-\\d{2},64", true, "-"}), Arguments.of((Object[])new Object[]{"\\d{4}-06-01,256;\\d{4}-06-\\d{2},128;\\d{4}-11-\\d{2},64", false, "-"}), Arguments.of((Object[])new Object[]{"\\d{4}/06/01,256;\\d{4}/06/\\d{2},128;\\d{4}/11/\\d{2},64", true, "/"}), Arguments.of((Object[])new Object[]{"\\d{4}/06/01,256;\\d{4}/06/\\d{2},128;\\d{4}/11/\\d{2},64", false, "/"}));
    }
}

