/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.schema.MessageType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestHoodieBinaryCopyHandleSchemaEvolution {
    private HoodieWriteConfig config;
    @Mock
    private HoodieTable<?, ?, ?, ?> hoodieTable;
    @Mock
    private TaskContextSupplier taskContextSupplier;
    @Mock
    private HoodieStorage storage;
    private Configuration hadoopConf;
    private MessageType fileSchema;
    private MessageType tableSchema;
    private Schema avroSchema;
    private List<StoragePath> inputFiles;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.hadoopConf = new Configuration();
        String avroSchemaStr = "{\"type\":\"record\",\"name\":\"TestRecord\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"int\"}]}";
        this.avroSchema = new Schema.Parser().parse(avroSchemaStr);
        this.fileSchema = new AvroSchemaConverter().convert(this.avroSchema);
        String tableAvroSchemaStr = "{\"type\":\"record\",\"name\":\"TestRecord\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"},{\"name\":\"field2\",\"type\":\"int\"},{\"name\":\"field3\",\"type\":[\"null\",\"string\"],\"default\":null}]}";
        Schema tableAvroSchema = new Schema.Parser().parse(tableAvroSchemaStr);
        this.tableSchema = new AvroSchemaConverter().convert(tableAvroSchema);
        this.inputFiles = Arrays.asList(new StoragePath("/test/file1.parquet"), new StoragePath("/test/file2.parquet"));
        Mockito.when((Object)this.hoodieTable.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.hoodieTable.getStorageConf()).thenReturn(Mockito.mock(StorageConfiguration.class));
        Mockito.when((Object)this.hoodieTable.getStorageConf().unwrapAs(Configuration.class)).thenReturn((Object)this.hadoopConf);
    }

    @Test
    public void testSchemaEvolutionDisabled_UsesFileSchema() throws Exception {
        this.config = HoodieWriteConfig.newBuilder().withPath("/dummy/path").build();
        this.config.setValue(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE, "false");
        try (MockedConstruction parquetUtilsConstruction = Mockito.mockConstruction(ParquetUtils.class, (mock, context) -> Mockito.when((Object)mock.readSchema((HoodieStorage)ArgumentMatchers.eq((Object)this.storage), (StoragePath)ArgumentMatchers.eq((Object)this.inputFiles.get(0)))).thenReturn((Object)this.fileSchema));){
            TestableHoodieBinaryCopyHandle handle = new TestableHoodieBinaryCopyHandle();
            MessageType result = handle.testGetWriteSchema(this.config, this.inputFiles, this.hadoopConf, this.hoodieTable);
            Assertions.assertEquals((Object)this.fileSchema, (Object)result);
            Assertions.assertEquals((int)1, (int)parquetUtilsConstruction.constructed().size());
        }
    }

    @Test
    public void testSchemaEvolutionEnabled_UsesTableSchema() throws Exception {
        this.config = HoodieWriteConfig.newBuilder().withPath("/dummy/path").build();
        this.config.setValue(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE, "true");
        TestableHoodieBinaryCopyHandle handle = new TestableHoodieBinaryCopyHandle();
        handle.setWriteSchemaWithMetaFields(this.avroSchema);
        MessageType result = handle.testGetWriteSchema(this.config, this.inputFiles, this.hadoopConf, this.hoodieTable);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testSchemaEvolutionDisabled_FileReadError_ThrowsException() throws Exception {
        this.config = HoodieWriteConfig.newBuilder().withPath("/dummy/path").build();
        this.config.setValue(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE, "false");
        TestableHoodieBinaryCopyHandle handle = new TestableHoodieBinaryCopyHandle();
        handle.setWriteSchemaWithMetaFields(this.avroSchema);
        handle.setSimulateFileReadError(true);
        Assertions.assertThrows(HoodieIOException.class, () -> handle.testGetWriteSchema(this.config, this.inputFiles, this.hadoopConf, this.hoodieTable));
    }

    @Test
    public void testSchemaEvolutionDisabled_EmptyInputFiles_UsesTableSchema() throws Exception {
        this.config = HoodieWriteConfig.newBuilder().withPath("/dummy/path").build();
        this.config.setValue(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE, "false");
        TestableHoodieBinaryCopyHandle handle = new TestableHoodieBinaryCopyHandle();
        handle.setWriteSchemaWithMetaFields(this.avroSchema);
        MessageType result = handle.testGetWriteSchema(this.config, Arrays.asList(new StoragePath[0]), this.hadoopConf, this.hoodieTable);
        Assertions.assertNotNull((Object)result);
    }

    private static class TestableHoodieBinaryCopyHandle {
        private Schema writeSchemaWithMetaFields;
        private boolean simulateFileReadError = false;

        private TestableHoodieBinaryCopyHandle() {
        }

        public void setWriteSchemaWithMetaFields(Schema schema) {
            this.writeSchemaWithMetaFields = schema;
        }

        public void setSimulateFileReadError(boolean simulateError) {
            this.simulateFileReadError = simulateError;
        }

        public MessageType testGetWriteSchema(HoodieWriteConfig config, List<StoragePath> inputFiles, Configuration conf, HoodieTable<?, ?, ?, ?> table) {
            if (!config.isBinaryCopySchemaEvolutionEnabled() && !inputFiles.isEmpty()) {
                try {
                    if (this.simulateFileReadError) {
                        throw new IOException("Simulated file read error");
                    }
                    ParquetUtils parquetUtils = new ParquetUtils();
                    MessageType fileSchema = parquetUtils.readSchema(table.getStorage(), inputFiles.get(0));
                    return fileSchema;
                }
                catch (Exception e) {
                    throw new HoodieIOException("Failed to read schema from input file when schema evolution is disabled: " + inputFiles.get(0), e instanceof IOException ? (IOException)e : new IOException(e));
                }
            }
            return new AvroSchemaConverter(conf).convert(this.writeSchemaWithMetaFields);
        }
    }
}

