/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Properties;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.FileGroupReaderBasedMergeHandle;
import org.apache.hudi.io.HoodieConcatHandle;
import org.apache.hudi.io.HoodieMergeHandleFactory;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandleWithChangeLog;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestHoodieMergeHandleFactory {
    private static final String CUSTOM_MERGE_HANDLE = "io.custom.CustomMergeHandle.java";
    private static final String BASE_PATH = "base_path";
    @Mock
    private HoodieTable mockHoodieTable;
    @Mock
    private HoodieTableConfig mockHoodieTableConfig;
    @Mock
    private HoodieTableMetaClient mockMetaClient;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)this.mockMetaClient);
        Mockito.when((Object)this.mockMetaClient.getTableConfig()).thenReturn((Object)this.mockHoodieTableConfig);
    }

    @Test
    public void validateWriterPathFactoryImpl() {
        Properties properties = new Properties();
        properties.setProperty(HoodieWriteConfig.MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.key(), "false");
        Pair mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)true);
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)true);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieSortedMergeHandleWithChangeLog.class.getName());
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)false);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieSortedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)false);
        Properties propsWithDups = new Properties();
        propsWithDups.setProperty(HoodieWriteConfig.MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.key(), "true");
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.INSERT, (HoodieWriteConfig)this.getWriterConfig(propsWithDups), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieConcatHandle.class.getName());
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(propsWithDups), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.INSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)true);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(propsWithDups), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.INSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)false);
        properties.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        properties.setProperty(HoodieWriteConfig.CONCAT_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        propsWithDups.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, CUSTOM_MERGE_HANDLE, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)true);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieSortedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)false);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.INSERT, (HoodieWriteConfig)this.getWriterConfig(propsWithDups), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieConcatHandle.class.getName());
        propsWithDups.setProperty(HoodieWriteConfig.CONCAT_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.INSERT, (HoodieWriteConfig)this.getWriterConfig(propsWithDups), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, CUSTOM_MERGE_HANDLE, HoodieConcatHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)false);
        properties.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), FileGroupReaderBasedMergeHandle.class.getName());
        propsWithDups.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName(), null);
        Mockito.when((Object)this.mockHoodieTableConfig.isCDCEnabled()).thenReturn((Object)true);
        properties.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), FileGroupReaderBasedMergeHandle.class.getName());
        propsWithDups.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite((WriteOperationType)WriteOperationType.UPSERT, (HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName(), null);
    }

    @Test
    public void validateCompactionPathFactoryImpl() {
        Properties properties = new Properties();
        Pair mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesCompaction((HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)true);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesCompaction((HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieSortedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)false);
        properties.setProperty(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.key(), CUSTOM_MERGE_HANDLE);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesCompaction((HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, CUSTOM_MERGE_HANDLE, FileGroupReaderBasedMergeHandle.class.getName());
        Mockito.when((Object)this.mockHoodieTable.requireSortedRecords()).thenReturn((Object)true);
        mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesCompaction((HoodieWriteConfig)this.getWriterConfig(properties), (HoodieTable)this.mockHoodieTable);
        this.validateMergeClasses((Pair<String, String>)mergeHandleClasses, HoodieSortedMergeHandle.class.getName());
    }

    private void validateMergeClasses(Pair<String, String> mergeHandleClasses, String expectedMergeHandleClasses) {
        this.validateMergeClasses(mergeHandleClasses, expectedMergeHandleClasses, null);
    }

    private void validateMergeClasses(Pair<String, String> mergeHandleClasses, String expectedMergeHandleClass, String expectedFallbackClass) {
        Assertions.assertEquals((Object)expectedMergeHandleClass, (Object)mergeHandleClasses.getLeft());
        Assertions.assertEquals((Object)expectedFallbackClass, (Object)mergeHandleClasses.getRight());
    }

    private HoodieWriteConfig getWriterConfig(Properties properties) {
        return HoodieWriteConfig.newBuilder().withPath(BASE_PATH).withProperties(properties).build();
    }
}

