/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class TestHoodieWriteHandle {
    @Mock
    private HoodieTable mockHoodieTable;
    @Mock
    private HoodieTableMetaClient mockMetaClient;
    @Mock
    private HoodieTableConfig mockTableConfig;
    @Mock
    private HoodieRecordMerger mockRecordMerger;
    @Mock
    private HoodieWriteConfig mockWriteConfig;

    TestHoodieWriteHandle() {
    }

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)this.mockMetaClient);
        Mockito.when((Object)this.mockMetaClient.getTableConfig()).thenReturn((Object)this.mockTableConfig);
        Mockito.when((Object)this.mockWriteConfig.getRecordMerger()).thenReturn((Object)this.mockRecordMerger);
        String basicSchema = "{\"type\":\"record\",\"name\":\"test\",\"fields\":[{\"name\":\"id\",\"type\":\"string\"}]}";
        Mockito.when((Object)this.mockWriteConfig.getWriteSchema()).thenReturn((Object)basicSchema);
        Mockito.when((Object)this.mockWriteConfig.getProps()).thenReturn((Object)new TypedProperties());
        Mockito.when((Object)this.mockWriteConfig.allowOperationMetadataField()).thenReturn((Object)false);
        Mockito.when((Object)this.mockWriteConfig.getWriteStatusClassName()).thenReturn((Object)"org.apache.hudi.client.WriteStatus");
        Mockito.when((Object)this.mockWriteConfig.getWriteStatusFailureFraction()).thenReturn((Object)0.0);
        Mockito.when((Object)this.mockHoodieTable.shouldTrackSuccessRecords()).thenReturn((Object)true);
        Mockito.when((Object)this.mockHoodieTable.isMetadataTable()).thenReturn((Object)false);
        Mockito.when((Object)this.mockHoodieTable.getConfig()).thenReturn((Object)this.mockWriteConfig);
        Mockito.when((Object)this.mockTableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.EIGHT);
        Mockito.when((Object)this.mockHoodieTable.getBaseFileExtension()).thenReturn((Object)".parquet");
    }

    @Test
    void testShouldTrackEventTimeWaterMarkerAvroRecordTypeWithEventTimeOrderingAndConfigEnabled() {
        boolean result = this.mockWriteHandle(true, "ts").isTrackingEventTimeWaterMarker();
        Assertions.assertTrue((boolean)result, (String)"Should track event time watermark for AVRO records with event time ordering and config enabled");
    }

    @Test
    void testShouldTrackEventTimeWaterMarkerAvroRecordTypeWithEventTimeOrderingAndConfigDisabled() {
        boolean result = this.mockWriteHandle(false, null).isTrackingEventTimeWaterMarker();
        Assertions.assertFalse((boolean)result, (String)"Should not track event time watermark when config is disabled");
    }

    @Test
    void testShouldTrackEventTimeWaterMarkerNonAvroRecordType() {
        boolean result = this.mockWriteHandle(true, "ts", false, HoodieRecord.HoodieRecordType.SPARK, RecordMergeMode.EVENT_TIME_ORDERING).isTrackingEventTimeWaterMarker();
        Assertions.assertTrue((boolean)result, (String)"Should track event time watermark for SPARK record type");
    }

    @Test
    void testShouldTrackEventTimeWaterMarkerAvroRecordTypeWithCommitTimeOrdering() {
        boolean result = this.mockWriteHandle(true, null, false, HoodieRecord.HoodieRecordType.AVRO, RecordMergeMode.COMMIT_TIME_ORDERING).isTrackingEventTimeWaterMarker();
        Assertions.assertFalse((boolean)result, (String)"Should not track event time watermark when using commit time ordering");
    }

    @Test
    void testAppendEventTimeMetadataWithEventTimeField() {
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("event_time", Schema.create((Schema.Type)Schema.Type.LONG), null, null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        record.put("event_time", (Object)1234567890L);
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "event_time");
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertTrue((boolean)result.isPresent(), (String)"Should return metadata when event time is present");
        Map metadata = (Map)result.get();
        Assertions.assertEquals((Object)"1234567890", metadata.get("metadata.event_time.key"), (String)"Event time should be correctly extracted");
    }

    @Test
    void testAppendEventTimeMetadataWithExistingMetadata() {
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("event_time", Schema.create((Schema.Type)Schema.Type.LONG), null, null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        record.put("event_time", (Object)1234567890L);
        HashMap<String, String> existingMetadata = new HashMap<String, String>();
        existingMetadata.put("existing_key", "existing_value");
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record, HoodieOperation.INSERT, Option.of(existingMetadata), null, null);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "event_time");
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertTrue((boolean)result.isPresent(), (String)"Should return metadata when event time is present");
        Map metadata = (Map)result.get();
        Assertions.assertEquals((Object)"1234567890", metadata.get("metadata.event_time.key"), (String)"Event time should be correctly extracted");
        Assertions.assertEquals((Object)"existing_value", metadata.get("existing_key"), (String)"Existing metadata should be preserved");
    }

    @Test
    void testAppendEventTimeMetadataWithoutEventTimeField() {
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "event_time");
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertFalse((boolean)result.isPresent(), (String)"Should return empty when event time field is not present");
    }

    @Test
    void testAppendEventTimeMetadataWithNullEventTimeValue() {
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("event_time", Schema.create((Schema.Type)Schema.Type.LONG), null, null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        record.put("event_time", null);
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "event_time");
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertFalse((boolean)result.isPresent(), (String)"Should return empty when event time value is null");
    }

    @Test
    void testAppendEventTimeMetadataWithStringEventTime() {
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("event_time", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        record.put("event_time", (Object)"2023-01-01T00:00:00Z");
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "event_time");
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertTrue((boolean)result.isPresent(), (String)"Should return metadata when event time is present");
        Map metadata = (Map)result.get();
        Assertions.assertEquals((Object)"2023-01-01T00:00:00Z", metadata.get("metadata.event_time.key"), (String)"String event time should be correctly extracted");
    }

    @Test
    void testAppendEventTimeMetadataWithNestedEventTimeField() {
        Schema nestedSchema = Schema.createRecord((String)"nested", null, null, (boolean)false);
        nestedSchema.setFields(Arrays.asList(new Schema.Field("event_time", Schema.create((Schema.Type)Schema.Type.LONG), null, null)));
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false);
        schema.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("nested", nestedSchema, null, null)));
        GenericData.Record nestedRecord = new GenericData.Record(nestedSchema);
        nestedRecord.put("event_time", (Object)1234567890L);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("id", (Object)"test_id");
        record.put("nested", (Object)nestedRecord);
        DummyHoodieWriteHandle testWriteHandle = this.mockWriteHandle(true, "nested.event_time");
        HoodieAvroIndexedRecord hoodieRecord = new HoodieAvroIndexedRecord(null, (IndexedRecord)record);
        Option<Map<String, String>> result = testWriteHandle.testAppendEventTimeMetadata((HoodieRecord)hoodieRecord, schema, new Properties());
        Assertions.assertTrue((boolean)result.isPresent(), (String)"Should return metadata when nested event time is present");
        Map metadata = (Map)result.get();
        Assertions.assertEquals((Object)"1234567890", metadata.get("metadata.event_time.key"), (String)"Nested event time should be correctly extracted");
    }

    private DummyHoodieWriteHandle mockWriteHandle(boolean isTrackingEventTimeMetadata, String eventTimeField) {
        return this.mockWriteHandle(isTrackingEventTimeMetadata, eventTimeField, false, HoodieRecord.HoodieRecordType.AVRO, RecordMergeMode.EVENT_TIME_ORDERING);
    }

    private DummyHoodieWriteHandle mockWriteHandle(boolean isTrackingEventTimeMetadata, String eventTimeField, boolean keepConsistentLogicalTimestamp, HoodieRecord.HoodieRecordType recordType, RecordMergeMode mergeMode) {
        Mockito.when((Object)this.mockRecordMerger.getRecordType()).thenReturn((Object)recordType);
        Mockito.when((Object)this.mockTableConfig.getRecordMergeMode()).thenReturn((Object)mergeMode);
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.write.track.event.time.watermark", (Object)String.valueOf(isTrackingEventTimeMetadata));
        if (eventTimeField != null) {
            props.put((Object)"hoodie.payload.event.time.field", (Object)eventTimeField);
        }
        props.put((Object)"hoodie.datasource.write.keygenerator.consistent.logical.timestamp.enabled", (Object)String.valueOf(keepConsistentLogicalTimestamp));
        Mockito.when((Object)this.mockWriteConfig.getProps()).thenReturn((Object)props);
        LocalTaskContextSupplier taskContextSupplier = new LocalTaskContextSupplier();
        return new DummyHoodieWriteHandle(this.mockWriteConfig, "test_instant", "test_partition", "test_file_id", (HoodieTable<Object, Object, Object, Object>)this.mockHoodieTable, (TaskContextSupplier)taskContextSupplier, false);
    }

    private static class DummyHoodieWriteHandle
    extends HoodieWriteHandle<Object, Object, Object, Object> {
        public DummyHoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<Object, Object, Object, Object> hoodieTable, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
            super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier, preserveMetadata);
        }

        public boolean isTrackingEventTimeWaterMarker() {
            return this.isTrackingEventTimeWatermark;
        }

        public Option<Map<String, String>> testAppendEventTimeMetadata(HoodieRecord record, Schema schema, Properties props) {
            return this.getRecordMetadata(record, schema, props);
        }

        public List<WriteStatus> close() {
            return Collections.emptyList();
        }

        public IOType getIOType() {
            return IOType.MERGE;
        }
    }
}

