/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.client.SecondaryIndexStats;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.SecondaryIndexStreamingTracker;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestSecondaryIndexStreamingTracker {
    private static final String SIMPLE_SCHEMA_STR = "{\n  \"type\": \"record\",\n  \"name\": \"TestRecord\",\n  \"fields\": [\n    {\"name\": \"_hoodie_commit_time\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_commit_seqno\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_record_key\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_partition_path\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_file_name\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"id\", \"type\": \"string\"},\n    {\"name\": \"name\", \"type\": \"string\"},\n    {\"name\": \"fare\", \"type\": \"double\"},\n    {\"name\": \"timestamp\", \"type\": \"long\"}\n  ]\n}";
    private static final String NULLABLE_SCHEMA_STR = "{\n  \"type\": \"record\",\n  \"name\": \"TestRecord\",\n  \"fields\": [\n    {\"name\": \"_hoodie_commit_time\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_commit_seqno\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_record_key\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_partition_path\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"_hoodie_file_name\", \"type\": [\"null\", \"string\"], \"default\": null},\n    {\"name\": \"id\", \"type\": \"string\"},\n    {\"name\": \"name\", \"type\": \"string\"},\n    {\"name\": \"fare\", \"type\": [\"null\", \"double\"], \"default\": null},\n    {\"name\": \"timestamp\", \"type\": \"long\"}\n  ]\n}";
    private Schema schema;
    private Schema nullableSchema;
    private HoodieWriteConfig config;
    private WriteStatus writeStatus;
    private HoodieIndexDefinition fareIndexDef;

    TestSecondaryIndexStreamingTracker() {
    }

    @BeforeEach
    void setUp() {
        this.schema = new Schema.Parser().parse(SIMPLE_SCHEMA_STR);
        this.nullableSchema = new Schema.Parser().parse(NULLABLE_SCHEMA_STR);
        Properties props = new Properties();
        this.config = HoodieWriteConfig.newBuilder().withPath("/tmp/test").withProps((Map)props).build();
        this.writeStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        this.fareIndexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
    }

    @ParameterizedTest
    @MethodSource(value={"insertTestCases"})
    void testTrackSecondaryIndexStats_Insert(String testName, Object fareValue, String expectedSecondaryKeyValue, Schema testSchema) {
        String recordKey = "test-record-key-" + testName;
        String partitionPath = "2023/01/01";
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        GenericRecord avroRecord = this.createRecord(testSchema, recordKey, partitionPath, "Test User", fareValue, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> newRecord = this.createHoodieRecord(hoodieKey, avroRecord);
        this.trackSecondaryIndexStats(hoodieKey, newRecord, null, false, testSchema);
        this.verifySecondaryIndexStats(this.writeStatus, (stats, indexName) -> {
            Assertions.assertEquals((int)1, (int)stats.size());
            Assertions.assertEquals((Object)recordKey, (Object)((SecondaryIndexStats)stats.get(0)).getRecordKey());
            Assertions.assertEquals((Object)expectedSecondaryKeyValue, (Object)((SecondaryIndexStats)stats.get(0)).getSecondaryKeyValue());
            Assertions.assertFalse((boolean)((SecondaryIndexStats)stats.get(0)).isDeleted());
        });
    }

    private static Stream<Arguments> insertTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"insert-normal", 100.5, "100.5", new Schema.Parser().parse(SIMPLE_SCHEMA_STR)}), Arguments.of((Object[])new Object[]{"insert-null", null, null, new Schema.Parser().parse(NULLABLE_SCHEMA_STR)}));
    }

    @ParameterizedTest
    @MethodSource(value={"updateTestCases"})
    void testTrackSecondaryIndexStats_Update(String testName, Object oldFareValue, Object newFareValue, String expectedDeleteValue, String expectedInsertValue, boolean expectUpdate) {
        String recordKey = "test-record-key-" + testName;
        String partitionPath = "2023/01/02";
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        GenericRecord oldAvroRecord = this.createRecord(this.nullableSchema, recordKey, partitionPath, "Old User", oldFareValue, System.currentTimeMillis() - 1000L);
        HoodieRecord<HoodieAvroPayload> oldRecord = this.createHoodieRecord(hoodieKey, oldAvroRecord);
        GenericRecord newAvroRecord = this.createRecord(this.nullableSchema, recordKey, partitionPath, "New User", newFareValue, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> newRecord = this.createHoodieRecord(hoodieKey, newAvroRecord);
        this.trackSecondaryIndexStats(hoodieKey, newRecord, oldRecord, false, this.nullableSchema);
        if (!expectUpdate) {
            Assertions.assertEquals((int)0, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
        } else {
            this.verifyUpdateEntries(this.writeStatus, recordKey, expectedDeleteValue, expectedInsertValue);
        }
    }

    private static Stream<Arguments> updateTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"update-same-value", 100.5, 100.5, null, null, false}), Arguments.of((Object[])new Object[]{"update-different-value", 100.5, 200.75, "100.5", "200.75", true}), Arguments.of((Object[])new Object[]{"update-to-null", 100.5, null, "100.5", null, true}), Arguments.of((Object[])new Object[]{"update-from-null", null, 200.75, null, "200.75", true}));
    }

    @ParameterizedTest
    @MethodSource(value={"deleteTestCases"})
    void testTrackSecondaryIndexStats_Delete(String testName, Object fareValue, String expectedSecondaryKeyValue) {
        String recordKey = "test-record-key-" + testName;
        String partitionPath = "2023/01/03";
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        GenericRecord oldAvroRecord = this.createRecord(this.nullableSchema, recordKey, partitionPath, "User to delete", fareValue, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> oldRecord = this.createHoodieRecord(hoodieKey, oldAvroRecord);
        this.trackSecondaryIndexStats(hoodieKey, (HoodieRecord<HoodieAvroPayload>)new HoodieEmptyRecord(null, HoodieRecord.HoodieRecordType.AVRO), oldRecord, true, this.nullableSchema);
        this.verifySecondaryIndexStats(this.writeStatus, (stats, indexName) -> {
            Assertions.assertEquals((int)1, (int)stats.size());
            Assertions.assertEquals((Object)recordKey, (Object)((SecondaryIndexStats)stats.get(0)).getRecordKey());
            Assertions.assertEquals((Object)expectedSecondaryKeyValue, (Object)((SecondaryIndexStats)stats.get(0)).getSecondaryKeyValue());
            Assertions.assertTrue((boolean)((SecondaryIndexStats)stats.get(0)).isDeleted());
        });
    }

    private static Stream<Arguments> deleteTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"delete-normal", 100.5, "100.5"}), Arguments.of((Object[])new Object[]{"delete-null", null, null}));
    }

    @Test
    void testTrackSecondaryIndexStats_MultipleSecondaryIndexes() {
        String recordKey = "test-record-key-006";
        String partitionPath = "2023/01/06";
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        GenericRecord avroRecord = this.createRecord(this.schema, recordKey, partitionPath, "Multi Index User", 100.5, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> newRecord = this.createHoodieRecord(hoodieKey, avroRecord);
        HoodieIndexDefinition nameIndexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_name_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("name")).build();
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats((HoodieKey)hoodieKey, newRecord, null, (boolean)false, (WriteStatus)this.writeStatus, (Schema)this.schema, () -> this.schema, Arrays.asList(this.fareIndexDef, nameIndexDef), (Option)Option.empty(), (HoodieWriteConfig)this.config);
        Assertions.assertEquals((int)2, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
        List fareStats = (List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index");
        Assertions.assertEquals((int)1, (int)fareStats.size());
        Assertions.assertEquals((Object)"100.5", (Object)((SecondaryIndexStats)fareStats.get(0)).getSecondaryKeyValue());
        List nameStats = (List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_name_index");
        Assertions.assertEquals((int)1, (int)nameStats.size());
        Assertions.assertEquals((Object)"Multi Index User", (Object)((SecondaryIndexStats)nameStats.get(0)).getSecondaryKeyValue());
    }

    @Test
    void testTrackSecondaryIndexStats_EdgeCases() {
        HoodieKey hoodieKey = new HoodieKey("test-key", "test-partition");
        GenericRecord avroRecord = this.createRecord(this.schema, "test-key", "test-partition", "Test User", 100.0, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> newRecord = this.createHoodieRecord(hoodieKey, avroRecord);
        this.trackSecondaryIndexStats(hoodieKey, newRecord, null, false, this.schema, Collections.emptyList());
        Assertions.assertEquals((int)0, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
        WriteStatus newWriteStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats(null, (HoodieRecord)new HoodieEmptyRecord(null, HoodieRecord.HoodieRecordType.AVRO), null, (boolean)true, (WriteStatus)newWriteStatus, (Schema)this.schema, () -> this.schema, Collections.singletonList(this.fareIndexDef), (Option)Option.empty(), (HoodieWriteConfig)this.config);
        Assertions.assertEquals((int)0, (int)newWriteStatus.getIndexStats().getSecondaryIndexStats().size());
    }

    @Test
    void testTrackSecondaryIndexStats_RecordKeyExtraction() {
        WriteStatus case1WriteStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        GenericRecord oldRecordData = this.createRecord(this.schema, "old-key", "old-partition", "Old User", 75.0, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> oldRecord = this.createHoodieRecord(new HoodieKey("old-key", "old-partition"), oldRecordData);
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats(null, (HoodieRecord)new HoodieEmptyRecord(null, HoodieRecord.HoodieRecordType.AVRO), oldRecord, (boolean)true, (WriteStatus)case1WriteStatus, (Schema)this.schema, () -> this.schema, Collections.singletonList(this.fareIndexDef), (Option)Option.empty(), (HoodieWriteConfig)this.config);
        this.verifySecondaryIndexStats(case1WriteStatus, (stats, indexName) -> {
            Assertions.assertEquals((int)1, (int)stats.size());
            Assertions.assertEquals((Object)"old-key", (Object)((SecondaryIndexStats)stats.get(0)).getRecordKey());
            Assertions.assertEquals((Object)"75.0", (Object)((SecondaryIndexStats)stats.get(0)).getSecondaryKeyValue());
            Assertions.assertTrue((boolean)((SecondaryIndexStats)stats.get(0)).isDeleted());
        });
        WriteStatus case2WriteStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        GenericRecord newRecordData = this.createRecord(this.schema, "new-key", "new-partition", "New User", 85.0, System.currentTimeMillis());
        HoodieRecord<HoodieAvroPayload> newRecord = this.createHoodieRecord(new HoodieKey("new-key", "new-partition"), newRecordData);
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats(null, newRecord, null, (boolean)false, (WriteStatus)case2WriteStatus, (Schema)this.schema, () -> this.schema, Collections.singletonList(this.fareIndexDef), (Option)Option.empty(), (HoodieWriteConfig)this.config);
        this.verifySecondaryIndexStats(case2WriteStatus, (stats, indexName) -> {
            Assertions.assertEquals((int)1, (int)stats.size());
            Assertions.assertEquals((Object)"new-key", (Object)((SecondaryIndexStats)stats.get(0)).getRecordKey());
            Assertions.assertEquals((Object)"85.0", (Object)((SecondaryIndexStats)stats.get(0)).getSecondaryKeyValue());
            Assertions.assertFalse((boolean)((SecondaryIndexStats)stats.get(0)).isDeleted());
        });
    }

    private GenericRecord createRecord(Schema recordSchema, String recordKey, String partitionPath, String name, Object fare, long timestamp) {
        GenericData.Record avroRecord = new GenericData.Record(recordSchema);
        avroRecord.put("_hoodie_record_key", (Object)recordKey);
        avroRecord.put("_hoodie_partition_path", (Object)partitionPath);
        avroRecord.put("_hoodie_commit_time", (Object)"20231201120000");
        avroRecord.put("_hoodie_commit_seqno", (Object)"001");
        avroRecord.put("_hoodie_file_name", (Object)"test-file.parquet");
        avroRecord.put("id", (Object)recordKey);
        avroRecord.put("name", (Object)name);
        avroRecord.put("fare", fare);
        avroRecord.put("timestamp", (Object)timestamp);
        return avroRecord;
    }

    private HoodieRecord<HoodieAvroPayload> createHoodieRecord(HoodieKey key, GenericRecord avroRecord) {
        HoodieAvroPayload payload = new HoodieAvroPayload(Option.of((Object)avroRecord));
        return new HoodieAvroRecord(key, (HoodieRecordPayload)payload);
    }

    private void trackSecondaryIndexStats(HoodieKey hoodieKey, HoodieRecord<HoodieAvroPayload> newRecord, HoodieRecord<HoodieAvroPayload> oldRecord, boolean isDelete, Schema recordSchema) {
        this.trackSecondaryIndexStats(hoodieKey, newRecord, oldRecord, isDelete, recordSchema, Collections.singletonList(this.fareIndexDef));
    }

    private void trackSecondaryIndexStats(HoodieKey hoodieKey, HoodieRecord<HoodieAvroPayload> newRecord, HoodieRecord<HoodieAvroPayload> oldRecord, boolean isDelete, Schema recordSchema, List<HoodieIndexDefinition> indexDefs) {
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats((HoodieKey)hoodieKey, newRecord, oldRecord, (boolean)isDelete, (WriteStatus)this.writeStatus, (Schema)recordSchema, () -> recordSchema, indexDefs, (Option)Option.empty(), (HoodieWriteConfig)this.config);
    }

    private void verifySecondaryIndexStats(WriteStatus status, BiConsumer<List<SecondaryIndexStats>, String> verification) {
        Assertions.assertFalse((boolean)status.getIndexStats().getSecondaryIndexStats().isEmpty());
        status.getIndexStats().getSecondaryIndexStats().forEach((indexName, statsList) -> verification.accept((List<SecondaryIndexStats>)statsList, (String)indexName));
    }

    private void verifyUpdateEntries(WriteStatus status, String recordKey, String expectedDeleteValue, String expectedInsertValue) {
        this.verifySecondaryIndexStats(status, (stats, indexName) -> {
            Assertions.assertEquals((int)2, (int)stats.size());
            boolean foundDelete = false;
            boolean foundInsert = false;
            for (SecondaryIndexStats stat : stats) {
                Assertions.assertEquals((Object)recordKey, (Object)stat.getRecordKey());
                if (stat.isDeleted()) {
                    Assertions.assertEquals((Object)expectedDeleteValue, (Object)stat.getSecondaryKeyValue());
                    foundDelete = true;
                    continue;
                }
                Assertions.assertEquals((Object)expectedInsertValue, (Object)stat.getSecondaryKeyValue());
                foundInsert = true;
            }
            Assertions.assertTrue((foundDelete && foundInsert ? 1 : 0) != 0, (String)"Should have both delete and insert entries");
        });
    }
}

