/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class TestFileWriter
implements HoodieFileWriter {
    private boolean closed = false;
    private boolean failOnWrite = false;

    public TestFileWriter(StoragePath filePath, HoodieStorage storage, boolean failOnInitialization) throws IOException {
        this(filePath, storage, failOnInitialization, false);
    }

    public TestFileWriter(StoragePath filePath, HoodieStorage storage, boolean failOnInitialization, boolean failOnWrite) throws IOException {
        this.failOnWrite = failOnWrite;
        storage.create(filePath, false);
        if (failOnInitialization) {
            throw new IOException("Simulated file writer initialization failure");
        }
    }

    public boolean canWrite() {
        return !this.closed;
    }

    public void writeWithMetadata(HoodieKey key, HoodieRecord record, Schema schema, Properties props) throws IOException {
        if (this.closed) {
            throw new IOException("Writer is closed");
        }
        if (this.failOnWrite) {
            throw new IOException("Simulated file writer write failure");
        }
    }

    public void write(String recordKey, HoodieRecord record, Schema schema, Properties props) throws IOException {
        if (this.closed) {
            throw new IOException("Writer is closed");
        }
        if (this.failOnWrite) {
            throw new IOException("Simulated file writer write failure");
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

