/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestComplexAvroKeyGenerator {
    @ParameterizedTest
    @CsvSource(value={"false,true,8", "true,false,8", "true,true,8", "false,true,9", "true,false,9", "true,true,9"})
    void testSingleValueKeyGenerator(boolean setNewEncodingConfig, boolean encodeSingleKeyFieldValueOnly, String tableVersion) {
        String recordKeyFieldName = "_row_key";
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), recordKeyFieldName);
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "timestamp");
        properties.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), tableVersion);
        if (setNewEncodingConfig) {
            properties.setProperty(HoodieWriteConfig.COMPLEX_KEYGEN_NEW_ENCODING.key(), String.valueOf(encodeSingleKeyFieldValueOnly));
        }
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        Assertions.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)1);
        Assertions.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)1);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = record.get(recordKeyFieldName).toString();
        String partitionPath = record.get("timestamp").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        String expectedRecordKey = "9".equals(tableVersion) ? recordKeyFieldName + ":" + rowKey : (setNewEncodingConfig && encodeSingleKeyFieldValueOnly ? rowKey : recordKeyFieldName + ":" + rowKey);
        Assertions.assertEquals((Object)expectedRecordKey, (Object)hoodieKey.getRecordKey());
        Assertions.assertEquals((Object)partitionPath, (Object)hoodieKey.getPartitionPath());
    }

    @ParameterizedTest
    @CsvSource(value={"false,true,8", "true,false,8", "true,true,8", "false,true,9", "true,false,9", "true,true,9"})
    void testMultipleValueKeyGenerator(boolean setNewEncodingConfig, boolean encodeSingleKeyFieldValueOnly, String tableVersion) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "rider,driver");
        properties.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), tableVersion);
        if (setNewEncodingConfig) {
            properties.setProperty(HoodieWriteConfig.COMPLEX_KEYGEN_NEW_ENCODING.key(), String.valueOf(encodeSingleKeyFieldValueOnly));
        }
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        Assertions.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        Assertions.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)2);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = record.get("rider").toString() + "/" + record.get("driver").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        Assertions.assertEquals((Object)rowKey, (Object)hoodieKey.getRecordKey());
        Assertions.assertEquals((Object)partitionPath, (Object)hoodieKey.getPartitionPath());
    }

    @ParameterizedTest
    @CsvSource(value={"false,true,8", "true,false,8", "true,true,8", "false,true,9", "true,false,9", "true,true,9"})
    void testMultipleValueKeyGeneratorNonPartitioned(boolean setNewEncodingConfig, boolean encodeSingleKeyFieldValueOnly, String tableVersion) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "");
        properties.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), tableVersion);
        if (setNewEncodingConfig) {
            properties.setProperty(HoodieWriteConfig.COMPLEX_KEYGEN_NEW_ENCODING.key(), String.valueOf(encodeSingleKeyFieldValueOnly));
        }
        ComplexAvroKeyGenerator compositeKeyGenerator = new ComplexAvroKeyGenerator(properties);
        Assertions.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        Assertions.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)0);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = "";
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        Assertions.assertEquals((Object)rowKey, (Object)hoodieKey.getRecordKey());
        Assertions.assertEquals((Object)partitionPath, (Object)hoodieKey.getPartitionPath());
    }
}

