/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyGenUtils {
    @Test
    public void testInferKeyGeneratorType() {
        Assertions.assertEquals((Object)KeyGeneratorType.SIMPLE, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1"), (String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1"), (String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1"), (String)"partition1:simple,partition2:timestamp"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1:simple"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1:simple,partition2:timestamp"));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)""));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), null));
        Assertions.assertEquals((Object)KeyGeneratorType.SIMPLE, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), (String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), (String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), (String)"partition1:simple"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), (String)"partition1:simple,partition2:timestamp"));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), (String)""));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.empty(), null));
    }

    @Test
    public void testInferKeyGeneratorTypeFromPartitionFields() {
        Assertions.assertEquals((Object)KeyGeneratorType.SIMPLE, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)"partition1:simple"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)"partition1:timestamp"));
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)"partition1:simple,partition2:timestamp"));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields((String)""));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields(null));
    }

    @Test
    public void testExtractRecordKeys() {
        Object[] s1 = KeyGenUtils.extractRecordKeys((String)"2024-10-22 14:11:53.023");
        Assertions.assertArrayEquals((Object[])new String[]{"2024-10-22 14:11:53.023"}, (Object[])s1);
        Object[] s2 = KeyGenUtils.extractRecordKeys((String)"id:1,id:2");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])s2);
        Object[] s3 = KeyGenUtils.extractRecordKeys((String)"id:1,id2:__null__,id3:__empty__");
        Assertions.assertArrayEquals((Object[])new String[]{"1", null, ""}, (Object[])s3);
        Object[] s4 = KeyGenUtils.extractRecordKeys((String)"id:ab:cd,id2:ef");
        Assertions.assertArrayEquals((Object[])new String[]{"ab:cd", "ef"}, (Object[])s4);
        Object[] s5 = KeyGenUtils.extractRecordKeys((String)"1");
        Assertions.assertArrayEquals((Object[])new String[]{"1"}, (Object[])s5);
        Object[] s6 = KeyGenUtils.extractRecordKeys((String)"id:1,id2:2,2");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2,2"}, (Object[])s6);
    }

    @Test
    public void testExtractRecordKeysWithFields() {
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add("id2");
        Object[] s1 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,id2:2,id3:3", fields);
        Assertions.assertArrayEquals((Object[])new String[]{"2"}, (Object[])s1);
        Object[] s2 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,id2:2,2,id3:3", fields);
        Assertions.assertArrayEquals((Object[])new String[]{"2,2"}, (Object[])s2);
        Object[] s3 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,1,1,id2:,2,2,,id3:3", fields);
        Assertions.assertArrayEquals((Object[])new String[]{",2,2,"}, (Object[])s3);
        fields.addAll(Arrays.asList("id1", "id3", "id4"));
        Object[] s4 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,,,id2:2024-10-22 14:11:53.023,id3:,,3,id4:::1:2::4::", fields);
        Assertions.assertArrayEquals((Object[])new String[]{"1,,", "2024-10-22 14:11:53.023", ",,3", "::1:2::4::"}, (Object[])s4);
    }

    @Test
    void testGetRecordKey() {
        Schema nullableStringSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)});
        Schema schema = Schema.createRecord((String)"TestRecord", (String)"doc", (String)"test", (boolean)false, Arrays.asList(new Schema.Field("key1", nullableStringSchema), new Schema.Field("key2", nullableStringSchema), new Schema.Field("key3", nullableStringSchema), new Schema.Field("key4", nullableStringSchema)));
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("key1", (Object)"value1");
        avroRecord.put("key2", (Object)"value2");
        avroRecord.put("key3", null);
        avroRecord.put("key4", (Object)"");
        Assertions.assertEquals((Object)"key1:value1", (Object)KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key1"), (boolean)true));
        Assertions.assertThrows(HoodieKeyException.class, () -> TestKeyGenUtils.lambda$testGetRecordKey$0((GenericRecord)avroRecord), (String)"recordKey values: \"key3:__null__\" for fields: [key3] cannot be entirely null or empty.");
        Assertions.assertThrows(HoodieKeyException.class, () -> TestKeyGenUtils.lambda$testGetRecordKey$1((GenericRecord)avroRecord), (String)"recordKey values: \"key4:__empty__\" for fields: [key4] cannot be entirely null or empty.");
        Assertions.assertEquals((Object)"key1:value1,key2:value2", (Object)KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key1", "key2"), (boolean)true));
        Assertions.assertEquals((Object)"key1:value1,key3:__null__", (Object)KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key1", "key3"), (boolean)true));
        Assertions.assertEquals((Object)"key1:value1,key4:__empty__", (Object)KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key1", "key4"), (boolean)true));
        Assertions.assertEquals((Object)"value1", (Object)KeyGenUtils.getRecordKey((GenericRecord)avroRecord, (String)"key1", (boolean)true));
        Assertions.assertThrows(HoodieKeyException.class, () -> TestKeyGenUtils.lambda$testGetRecordKey$2((GenericRecord)avroRecord), (String)"recordKey value: \"null\" for field: \"key3\" cannot be null or empty.");
        Assertions.assertThrows(HoodieKeyException.class, () -> TestKeyGenUtils.lambda$testGetRecordKey$3((GenericRecord)avroRecord), (String)"recordKey value: \"\" for field: \"key4\" cannot be null or empty.");
    }

    @Test
    void testIsComplexKeyGeneratorWithSingleRecordKeyField() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id");
        Assertions.assertTrue((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
        tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "userId");
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX_AVRO.name());
        Assertions.assertTrue((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
    }

    @Test
    void testIsComplexKeyGeneratorWithSingleRecordKeyFieldOnMultipleFields() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id,userId");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
        tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX_AVRO.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id,userId,name");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
    }

    @Test
    void testIsComplexKeyGeneratorWithSingleRecordKeyFieldOnNonComplexGenerator() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.SIMPLE.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
        tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.SIMPLE_AVRO.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "userId");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
        tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.TIMESTAMP.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
        tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.CUSTOM.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "id");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
    }

    @Test
    void testIsComplexKeyGeneratorWithSingleRecordKeyFieldOnNoRecordKeyFields() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX.name());
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
    }

    @Test
    void testIsComplexKeyGeneratorWithSingleRecordKeyFieldEmptyRecordKeyFields() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX.name());
        tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "");
        Assertions.assertFalse((boolean)KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField((HoodieTableConfig)tableConfig));
    }

    private static /* synthetic */ void lambda$testGetRecordKey$3(GenericRecord avroRecord) throws Throwable {
        KeyGenUtils.getRecordKey((GenericRecord)avroRecord, (String)"key4", (boolean)true);
    }

    private static /* synthetic */ void lambda$testGetRecordKey$2(GenericRecord avroRecord) throws Throwable {
        KeyGenUtils.getRecordKey((GenericRecord)avroRecord, (String)"key3", (boolean)true);
    }

    private static /* synthetic */ void lambda$testGetRecordKey$1(GenericRecord avroRecord) throws Throwable {
        KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key4"), (boolean)true);
    }

    private static /* synthetic */ void lambda$testGetRecordKey$0(GenericRecord avroRecord) throws Throwable {
        KeyGenUtils.getRecordKey((GenericRecord)avroRecord, Arrays.asList("key3"), (boolean)true);
    }
}

