/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.util.Lazy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class TestHoodieBackedTableMetadataWriter {
    private HoodieEngineContext engineContext;
    private HoodieTableMetaClient dataMetaClient;
    private HoodieMetadataConfig metadataConfig;
    private StorageConfiguration<?> storageConf;

    TestHoodieBackedTableMetadataWriter() {
    }

    @BeforeEach
    void setUp() {
        this.engineContext = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        this.dataMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        this.metadataConfig = (HoodieMetadataConfig)Mockito.mock(HoodieMetadataConfig.class);
        this.storageConf = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        Mockito.when((Object)this.metadataConfig.getMaxReaderBufferSize()).thenReturn((Object)1024);
    }

    @ParameterizedTest
    @CsvSource(value={"true,true,false,true", "false,true,false,true", "true,false,false,true", "false,false,false,false", "false,false,true,false"})
    void runPendingTableServicesOperations(boolean hasPendingCompaction, boolean hasPendingLogCompaction, boolean requiresRefresh, boolean ranService) {
        HoodieActiveTimeline expectedResult;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieActiveTimeline initialTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseHoodieWriteClient writeClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        if (requiresRefresh) {
            Mockito.when((Object)metaClient.reloadActiveTimeline()).thenReturn((Object)initialTimeline);
        } else {
            Mockito.when((Object)metaClient.getActiveTimeline()).thenReturn((Object)initialTimeline);
        }
        if (hasPendingCompaction) {
            Mockito.when((Object)initialTimeline.filterPendingCompactionTimeline().countInstants()).thenReturn((Object)1);
        }
        if (hasPendingLogCompaction) {
            Mockito.when((Object)initialTimeline.filterPendingLogCompactionTimeline().countInstants()).thenReturn((Object)1);
        }
        if (ranService) {
            HoodieActiveTimeline timelineReloadedAfterServicesRun = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
            Mockito.when((Object)metaClient.reloadActiveTimeline()).thenReturn((Object)timelineReloadedAfterServicesRun);
            expectedResult = timelineReloadedAfterServicesRun;
        } else {
            expectedResult = initialTimeline;
        }
        Assertions.assertSame((Object)expectedResult, (Object)HoodieBackedTableMetadataWriter.runPendingTableServicesOperationsAndRefreshTimeline((HoodieTableMetaClient)metaClient, (BaseHoodieWriteClient)writeClient, (boolean)requiresRefresh));
        ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)(hasPendingCompaction ? 1 : 0)))).runAnyPendingCompactions();
        ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)(hasPendingLogCompaction ? 1 : 0)))).runAnyPendingLogCompactions();
        int expectedTimelineReloads = (requiresRefresh ? 1 : 0) + (ranService ? 1 : 0);
        ((HoodieTableMetaClient)Mockito.verify((Object)metaClient, (VerificationMode)Mockito.times((int)expectedTimelineReloads))).reloadActiveTimeline();
    }

    @Test
    void rollbackFailedWrites_reloadsTimelineOnWritesRolledBack() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        BaseHoodieWriteClient mockWriteClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockWriteClient.rollbackFailedWrites(mockMetaClient)).thenReturn((Object)true);
        try (MockedStatic mockedStatic = Mockito.mockStatic(HoodieTableMetaClient.class);){
            HoodieTableMetaClient reloadedClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
            mockedStatic.when(() -> HoodieTableMetaClient.reload((HoodieTableMetaClient)mockMetaClient)).thenReturn((Object)reloadedClient);
            Assertions.assertSame((Object)reloadedClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)writeConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
        }
    }

    @Test
    void rollbackFailedWrites_avoidsTimelineReload() {
        HoodieWriteConfig eagerWriteConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        BaseHoodieWriteClient mockWriteClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockWriteClient.rollbackFailedWrites(mockMetaClient)).thenReturn((Object)false);
        Assertions.assertSame((Object)mockMetaClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)eagerWriteConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
        HoodieWriteConfig lazyWriteConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        Assertions.assertSame((Object)mockMetaClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)lazyWriteConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
    }

    @Test
    void testConvertToColumnStatsRecordWithEmptyInputs() {
        HashMap partitionFilesToAdd = new HashMap();
        HashMap partitionFilesToDelete = new HashMap();
        Map result = HoodieBackedTableMetadataWriter.convertToColumnStatsRecord(partitionFilesToAdd, partitionFilesToDelete, (HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.metadataConfig, (Option)Option.empty(), (int)4);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    void testConvertToColumnStatsRecordWithEmptyColumnsToIndex() {
        try (MockedStatic mockedUtil = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            HashMap emptyColumnsMap = new HashMap();
            mockedUtil.when(() -> HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)((HoodieTableConfig)ArgumentMatchers.any()), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.any()), (Lazy)((Lazy)ArgumentMatchers.any()), (boolean)ArgumentMatchers.eq((boolean)false), (HoodieIndexVersion)((HoodieIndexVersion)ArgumentMatchers.any()))).thenReturn(emptyColumnsMap);
            HashMap partitionFilesToAdd = new HashMap();
            HashMap<String, Long> filesToAdd = new HashMap<String, Long>();
            filesToAdd.put("file1.parquet", 1024L);
            partitionFilesToAdd.put("partition1", filesToAdd);
            HashMap partitionFilesToDelete = new HashMap();
            Map result = HoodieBackedTableMetadataWriter.convertToColumnStatsRecord(partitionFilesToAdd, partitionFilesToDelete, (HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.metadataConfig, (Option)Option.empty(), (int)4);
            Assertions.assertTrue((boolean)result.isEmpty());
        }
    }

    @Test
    void testConvertToColumnStatsRecordWithValidColumns() {
        try (MockedStatic mockedUtil = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("col1", null);
            columnsMap.put("col2", null);
            mockedUtil.when(() -> HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)((HoodieTableConfig)ArgumentMatchers.any()), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.any()), (Lazy)((Lazy)ArgumentMatchers.any()), (boolean)ArgumentMatchers.eq((boolean)false), (Option)((Option)ArgumentMatchers.any()), (HoodieIndexVersion)((HoodieIndexVersion)ArgumentMatchers.any()))).thenReturn(columnsMap);
            HoodieData mockHoodieData = (HoodieData)Mockito.mock(HoodieData.class);
            mockedUtil.when(() -> HoodieTableMetadataUtil.convertFilesToColumnStatsRecords((HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.any()), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.any()), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (List)((List)ArgumentMatchers.any()))).thenReturn((Object)mockHoodieData);
            HashMap partitionFilesToAdd = new HashMap();
            partitionFilesToAdd.put("partition1", new HashMap());
            HashMap partitionFilesToDelete = new HashMap();
            Map result = HoodieBackedTableMetadataWriter.convertToColumnStatsRecord(partitionFilesToAdd, partitionFilesToDelete, (HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.metadataConfig, (Option)Option.empty(), (int)4);
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertTrue((boolean)result.containsKey(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
            Assertions.assertEquals((Object)mockHoodieData, result.get(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
            mockedUtil.verify(() -> HoodieTableMetadataUtil.convertFilesToColumnStatsRecords((HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.eq((Object)this.engineContext)), (Map)((Map)ArgumentMatchers.eq((Object)partitionFilesToDelete)), (Map)((Map)ArgumentMatchers.eq((Object)partitionFilesToAdd)), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.dataMetaClient)), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.eq((Object)this.metadataConfig)), (int)ArgumentMatchers.eq((int)4), (int)ArgumentMatchers.eq((int)1024), (List)((List)ArgumentMatchers.any())));
        }
    }

    @Test
    void testConvertToColumnStatsRecordWithMixedInputs() {
        try (MockedStatic mockedUtil = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("col1", null);
            columnsMap.put("col2", null);
            columnsMap.put("col3", null);
            mockedUtil.when(() -> HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)((HoodieTableConfig)ArgumentMatchers.any()), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.any()), (Lazy)((Lazy)ArgumentMatchers.any()), (boolean)ArgumentMatchers.eq((boolean)false), (Option)((Option)ArgumentMatchers.any()), (HoodieIndexVersion)((HoodieIndexVersion)ArgumentMatchers.any()))).thenReturn(columnsMap);
            HoodieData mockHoodieData = (HoodieData)Mockito.mock(HoodieData.class);
            mockedUtil.when(() -> HoodieTableMetadataUtil.convertFilesToColumnStatsRecords((HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()), (Map)((Map)ArgumentMatchers.any()), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.any()), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.any()), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (List)((List)ArgumentMatchers.any()))).thenReturn((Object)mockHoodieData);
            HashMap partitionFilesToAdd = new HashMap();
            HashMap<String, Long> filesToAdd = new HashMap<String, Long>();
            filesToAdd.put("file1.parquet", 1024L);
            filesToAdd.put("file2.parquet", 2048L);
            partitionFilesToAdd.put("partition1", filesToAdd);
            HashMap partitionFilesToDelete = new HashMap();
            ArrayList<String> filesToDelete = new ArrayList<String>();
            filesToDelete.add("old_file1.parquet");
            filesToDelete.add("old_file2.parquet");
            partitionFilesToDelete.put("partition1", filesToDelete);
            Map result = HoodieBackedTableMetadataWriter.convertToColumnStatsRecord(partitionFilesToAdd, partitionFilesToDelete, (HoodieEngineContext)this.engineContext, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.metadataConfig, (Option)Option.empty(), (int)4);
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertTrue((boolean)result.containsKey(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
            mockedUtil.verify(() -> HoodieTableMetadataUtil.convertFilesToColumnStatsRecords((HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.eq((Object)this.engineContext)), (Map)((Map)ArgumentMatchers.eq((Object)partitionFilesToDelete)), (Map)((Map)ArgumentMatchers.eq((Object)partitionFilesToAdd)), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.dataMetaClient)), (HoodieMetadataConfig)((HoodieMetadataConfig)ArgumentMatchers.eq((Object)this.metadataConfig)), (int)ArgumentMatchers.eq((int)4), (int)ArgumentMatchers.eq((int)1024), (List)((List)ArgumentMatchers.any())));
        }
    }

    @Test
    void testValidateRollbackForMDT() throws Exception {
        ArrayList<HoodieInstant> instants = new ArrayList<HoodieInstant>();
        instants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", "20250925012123905"));
        instants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "20250925012447357", "20250925013432341"));
        instants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "20250925012518125", "20250925012831379"));
        instants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "20250925012851950", "20250925013157886"));
        instants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "20250925012523368", "20250925015000000"));
        HoodieInstant instantToRollback = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "20250925012123804", "20250925014634434");
        instants.add(instantToRollback);
        HoodieActiveTimeline timeline = this.createMockTimeline(instants);
        HoodieBackedTableMetadataWriter writer = (HoodieBackedTableMetadataWriter)Mockito.mock(HoodieBackedTableMetadataWriter.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockMetaClient.getActiveTimeline()).thenReturn((Object)timeline);
        Field metadataMetaClientField = HoodieBackedTableMetadataWriter.class.getDeclaredField("metadataMetaClient");
        metadataMetaClientField.setAccessible(true);
        metadataMetaClientField.set(writer, mockMetaClient);
        Method validateRollbackMethod = HoodieBackedTableMetadataWriter.class.getDeclaredMethod("validateRollback", HoodieInstant.class);
        validateRollbackMethod.setAccessible(true);
        Assertions.assertDoesNotThrow(() -> validateRollbackMethod.invoke((Object)writer, instantToRollback));
    }

    private HoodieActiveTimeline createMockTimeline(List<HoodieInstant> instants) {
        ActiveTimelineV2 timeline = new ActiveTimelineV2();
        timeline.setInstants(instants);
        return timeline;
    }
}

