/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieTableSchemaEvolution {
    private static final String TABLE_SCHEMA = "{\"type\": \"record\",\"name\": \"test\",\"fields\": [  {\"name\": \"id\", \"type\": \"int\"},  {\"name\": \"name\", \"type\": \"string\"},  {\"name\": \"age\", \"type\": \"int\"},  {\"name\": \"salary\", \"type\": \"double\"},  {\"name\": \"nullable_field\", \"type\": [\"null\", \"string\"], \"default\": null}]}";

    @Test
    public void testNoSecondaryIndexes() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA.replace("\"age\", \"type\": \"int\"", "\"age\", \"type\": \"long\""));
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(new HashMap());
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testNoSchemaChange() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_age", "age");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testNonIndexedColumnEvolution() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA.replace("\"name\", \"type\": \"string\"", "\"name\", \"type\": [\"null\", \"string\"]"));
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_age", "age");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInvalidSchemaEvolutions"})
    public void testIndexedColumnTypeEvolution(String fieldName, String originalType, String evolvedType) {
        String originalSchema = TABLE_SCHEMA;
        String evolvedSchema = TABLE_SCHEMA.replace("\"" + fieldName + "\", \"type\": \"" + originalType + "\"", "\"" + fieldName + "\", \"type\": \"" + evolvedType + "\"");
        Schema tableSchema = new Schema.Parser().parse(originalSchema);
        Schema writerSchema = new Schema.Parser().parse(evolvedSchema);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_" + fieldName, fieldName);
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        SchemaCompatibilityException exception = (SchemaCompatibilityException)Assertions.assertThrows(SchemaCompatibilityException.class, () -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
        Assertions.assertTrue((boolean)exception.getMessage().contains("secondary index"));
        Assertions.assertTrue((boolean)exception.getMessage().contains(fieldName));
        Assertions.assertTrue((boolean)exception.getMessage().contains("secondary_index_" + fieldName));
    }

    private static Stream<Arguments> provideInvalidSchemaEvolutions() {
        return Stream.of(Arguments.of((Object[])new Object[]{"age", "int", "long"}), Arguments.of((Object[])new Object[]{"age", "int", "double"}), Arguments.of((Object[])new Object[]{"salary", "double", "float"}));
    }

    @Test
    public void testMultipleIndexesOnSameColumn() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA.replace("\"age\", \"type\": \"int\"", "\"age\", \"type\": \"long\""));
        HoodieIndexDefinition indexDef1 = this.createSecondaryIndexDefinition("secondary_index_age_1", "age");
        HoodieIndexDefinition indexDef2 = this.createSecondaryIndexDefinition("secondary_index_age_2", "age");
        HashMap<String, HoodieIndexDefinition> indexDefs = new HashMap<String, HoodieIndexDefinition>();
        indexDefs.put("secondary_index_age_1", indexDef1);
        indexDefs.put("secondary_index_age_2", indexDef2);
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(indexDefs);
        SchemaCompatibilityException exception = (SchemaCompatibilityException)Assertions.assertThrows(SchemaCompatibilityException.class, () -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
        Assertions.assertTrue((boolean)exception.getMessage().contains("age"));
        Assertions.assertTrue((exception.getMessage().contains("secondary_index_age_1") || exception.getMessage().contains("secondary_index_age_2") ? 1 : 0) != 0);
    }

    @Test
    public void testCompoundIndex() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA.replace("\"age\", \"type\": \"int\"", "\"age\", \"type\": \"long\""));
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_compound", "name", "age");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        SchemaCompatibilityException exception = (SchemaCompatibilityException)Assertions.assertThrows(SchemaCompatibilityException.class, () -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
        Assertions.assertTrue((boolean)exception.getMessage().contains("age"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("secondary_index_compound"));
    }

    @Test
    public void testFieldWithAlias() {
        String tableSchemaStr = "{\"type\": \"record\",\"name\": \"test\",\"fields\": [  {\"name\": \"id\", \"type\": \"int\"},  {\"name\": \"old_name\", \"type\": \"string\", \"aliases\": [\"new_name\"]}]}";
        String writerSchemaStr = "{\"type\": \"record\",\"name\": \"test\",\"fields\": [  {\"name\": \"id\", \"type\": \"int\"},  {\"name\": \"new_name\", \"type\": \"string\"}]}";
        Schema tableSchema = new Schema.Parser().parse(tableSchemaStr);
        Schema writerSchema = new Schema.Parser().parse(writerSchemaStr);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_name", "old_name");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testNullableFieldEvolution() {
        String evolvedSchema = TABLE_SCHEMA.replace("\"name\", \"type\": \"string\"", "\"name\", \"type\": [\"null\", \"string\"], \"default\": null");
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(evolvedSchema);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_name", "name");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testMissingIndexedColumnInTableSchema() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_nonexistent", "nonexistent_column");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testNonSecondaryIndexDefinitions() {
        Schema tableSchema = new Schema.Parser().parse(TABLE_SCHEMA);
        Schema writerSchema = new Schema.Parser().parse(TABLE_SCHEMA.replace("\"age\", \"type\": \"int\"", "\"age\", \"type\": \"long\""));
        HoodieIndexDefinition expressionIndexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.EXPRESSION_INDEX.getPartitionPath() + "_expr_idx").withIndexType(MetadataPartitionType.EXPRESSION_INDEX.getPartitionPath()).withSourceFields(Collections.singletonList("age")).build();
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(expressionIndexDef);
        Assertions.assertDoesNotThrow(() -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchema, (Schema)writerSchema, (HoodieIndexMetadata)indexMetadata));
    }

    @Test
    public void testFixedTypeEvolution() {
        String fixed8Schema = "{\"type\": \"record\",\"name\": \"test\",\"fields\": [  {\"name\": \"id\", \"type\": \"int\"},  {\"name\": \"fixed_field\", \"type\": {\"type\": \"fixed\", \"name\": \"FixedField\", \"size\": 8}}]}";
        String fixed16Schema = "{\"type\": \"record\",\"name\": \"test\",\"fields\": [  {\"name\": \"id\", \"type\": \"int\"},  {\"name\": \"fixed_field\", \"type\": {\"type\": \"fixed\", \"name\": \"FixedField\", \"size\": 16}}]}";
        Schema tableSchema = new Schema.Parser().parse(fixed8Schema);
        Schema writerSchema = new Schema.Parser().parse(fixed16Schema);
        HoodieIndexDefinition indexDef = this.createSecondaryIndexDefinition("secondary_index_fixed", "fixed_field");
        HoodieIndexMetadata indexMetadata = this.createIndexMetadata(indexDef);
        Schema tableSchemaFixed1 = tableSchema;
        Schema writerSchemaFixed1 = writerSchema;
        HoodieIndexMetadata indexMetadataFixed = indexMetadata;
        SchemaCompatibilityException exception = (SchemaCompatibilityException)Assertions.assertThrows(SchemaCompatibilityException.class, () -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchemaFixed1, (Schema)writerSchemaFixed1, (HoodieIndexMetadata)indexMetadataFixed));
        Assertions.assertTrue((boolean)exception.getMessage().contains("fixed_field"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("secondary index"));
        tableSchema = new Schema.Parser().parse(fixed16Schema);
        writerSchema = new Schema.Parser().parse(fixed8Schema);
        Schema tableSchemaFixed2 = tableSchema;
        Schema writerSchemaFixed2 = writerSchema;
        exception = (SchemaCompatibilityException)Assertions.assertThrows(SchemaCompatibilityException.class, () -> HoodieTable.validateSecondaryIndexSchemaEvolution((Schema)tableSchemaFixed2, (Schema)writerSchemaFixed2, (HoodieIndexMetadata)indexMetadataFixed));
        Assertions.assertTrue((boolean)exception.getMessage().contains("fixed_field"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("secondary index"));
    }

    private HoodieIndexDefinition createSecondaryIndexDefinition(String indexName, String ... sourceFields) {
        return HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_" + indexName).withIndexType(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath()).withSourceFields(Arrays.asList(sourceFields)).build();
    }

    private HoodieIndexMetadata createIndexMetadata(HoodieIndexDefinition ... indexDefs) {
        HashMap<String, HoodieIndexDefinition> indexDefMap = new HashMap<String, HoodieIndexDefinition>();
        for (HoodieIndexDefinition indexDef : indexDefs) {
            indexDefMap.put(indexDef.getIndexName(), indexDef);
        }
        return new HoodieIndexMetadata(indexDefMap);
    }
}

