/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.savepoint.SavepointActionExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestSavepointActionExecutor {
    private static final String CLEAN_REQUEST_TIME = "20240111101012345";
    private final HoodieTable mockTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
    private final String instantTime = "20240121101012345";

    TestSavepointActionExecutor() {
    }

    @Test
    void testLastCommitRetained_noCleanCommits() {
        String expectedInstant = "20240101101012345";
        Mockito.when((Object)this.mockTable.getCompletedCommitsTimeline().firstInstant()).thenReturn((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", expectedInstant, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Mockito.when((Object)this.mockTable.getCleanTimeline().lastInstant()).thenReturn((Object)Option.empty());
        SavepointActionExecutor executor = new SavepointActionExecutor((HoodieEngineContext)this.engineContext, null, this.mockTable, "20240121101012345", "user", "comment");
        Assertions.assertEquals((Object)expectedInstant, (Object)executor.getLastCommitRetained());
    }

    @Test
    void testLastCommitRetained_completedClean() throws IOException {
        String expectedInstant = "20240101101012345";
        HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", CLEAN_REQUEST_TIME, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.mockTable.getCompletedCommitsTimeline().firstInstant()).thenReturn((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", expectedInstant, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Mockito.when((Object)this.mockTable.getCleanTimeline().lastInstant()).thenReturn((Object)Option.of((Object)cleanInstant));
        HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata();
        cleanMetadata.setEarliestCommitToRetain(expectedInstant);
        Mockito.when((Object)this.mockTable.getActiveTimeline().readCleanMetadata(cleanInstant)).thenReturn((Object)cleanMetadata);
        SavepointActionExecutor executor = new SavepointActionExecutor((HoodieEngineContext)this.engineContext, null, this.mockTable, "20240121101012345", "user", "comment");
        Assertions.assertEquals((Object)expectedInstant, (Object)executor.getLastCommitRetained());
    }

    @Test
    void testLastCommitRetained_requestedClean() throws IOException {
        String expectedInstant = "20240101101012345";
        String cleanRequested = CLEAN_REQUEST_TIME;
        HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", cleanRequested, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        InstantGenerator instantGenerator = (InstantGenerator)Mockito.mock(InstantGenerator.class);
        Mockito.when((Object)this.mockTable.getInstantGenerator()).thenReturn((Object)instantGenerator);
        Mockito.when((Object)instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanRequested)).thenReturn((Object)cleanInstant);
        Mockito.when((Object)this.mockTable.getCompletedCommitsTimeline().firstInstant()).thenReturn((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", expectedInstant, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Mockito.when((Object)this.mockTable.getCleanTimeline().lastInstant()).thenReturn((Object)Option.of((Object)cleanInstant));
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan();
        HoodieActionInstant lastInstantToRetain = HoodieActionInstant.newBuilder().setAction("commit").setState(HoodieInstant.State.COMPLETED.name()).setTimestamp(expectedInstant).build();
        cleanerPlan.setEarliestInstantToRetain(lastInstantToRetain);
        Mockito.when((Object)this.mockTable.getActiveTimeline().readCleanerPlan(cleanInstant)).thenReturn((Object)cleanerPlan);
        SavepointActionExecutor executor = new SavepointActionExecutor((HoodieEngineContext)this.engineContext, null, this.mockTable, "20240121101012345", "user", "comment");
        Assertions.assertEquals((Object)expectedInstant, (Object)executor.getLastCommitRetained());
    }

    private static Stream<Arguments> noEarliestInstantRetained() {
        String lastCommitBeforeClean = "20240110101012345";
        return Stream.of(Arguments.of((Object[])new Object[]{Stream.of("20240108101012345", "20240109101012345", lastCommitBeforeClean, "20240129101012345"), lastCommitBeforeClean}), Arguments.of((Object[])new Object[]{Stream.of("20240129101012345", "20240139101012345", "20240149101012345"), CLEAN_REQUEST_TIME}));
    }

    @ParameterizedTest
    @MethodSource(value={"noEarliestInstantRetained"})
    void testLastCommitRetained_completedCleanWithoutEarliestInstantRetained(Stream<String> writeInstants, String expectedInstant) throws IOException {
        HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", CLEAN_REQUEST_TIME, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.mockTable.getCompletedCommitsTimeline().firstInstant()).thenReturn((Object)Option.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", expectedInstant, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR)));
        Mockito.when((Object)this.mockTable.getCleanTimeline().lastInstant()).thenReturn((Object)Option.of((Object)cleanInstant));
        HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata();
        Mockito.when((Object)this.mockTable.getActiveTimeline().readCleanMetadata(cleanInstant)).thenReturn((Object)cleanMetadata);
        MockHoodieTimeline mockTimeline = new MockHoodieTimeline(writeInstants, Stream.empty());
        Mockito.when((Object)this.mockTable.getActiveTimeline().getWriteTimeline().filterCompletedInstants()).thenReturn((Object)mockTimeline);
        SavepointActionExecutor executor = new SavepointActionExecutor((HoodieEngineContext)this.engineContext, null, this.mockTable, "20240121101012345", "user", "comment");
        Assertions.assertEquals((Object)expectedInstant, (Object)executor.getLastCommitRetained());
    }
}

