/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.cluster.strategy;

import java.util.stream.Stream;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestClusteringPlanStrategyConfigCompatibility {
    private static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{"org.apache.hudi.client.clustering.plan.strategy.SparkRecentDaysClusteringPlanStrategy", "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy", ClusteringPlanPartitionFilterMode.RECENT_DAYS}, {"org.apache.hudi.client.clustering.plan.strategy.SparkSelectedPartitionsClusteringPlanStrategy", "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy", ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS}, {"org.apache.hudi.client.clustering.plan.strategy.JavaRecentDaysClusteringPlanStrategy", "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy", ClusteringPlanPartitionFilterMode.RECENT_DAYS}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testCheckAndGetClusteringPlanStrategy(String oldClass, String newClass, ClusteringPlanPartitionFilterMode mode) {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("").withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanStrategyClass(oldClass).build()).build();
        Assertions.assertEquals((Object)newClass, (Object)ClusteringPlanStrategy.checkAndGetClusteringPlanStrategy((HoodieWriteConfig)config));
        Assertions.assertEquals((Object)mode, (Object)config.getClusteringPlanPartitionFilterMode());
    }
}

