/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.upgrade.EightToSevenDowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestEightToSevenDowngradeHandler {
    @TempDir
    private File baseDir;
    private static final List<String> SAMPLE_METADATA_PATHS = Arrays.asList("expr_index_random", "secondary_index_random", "partition_stats", MetadataPartitionType.FILES.getPartitionPath(), MetadataPartitionType.COLUMN_STATS.getPartitionPath());
    @Mock
    HoodieTableMetaClient metaClient;
    @Mock
    HoodieEngineContext context;
    @Mock
    HoodieWriteConfig config;
    @Mock
    SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private EightToSevenDowngradeHandler downgradeHandler;

    TestEightToSevenDowngradeHandler() {
    }

    @BeforeEach
    void setUp() {
        this.downgradeHandler = new EightToSevenDowngradeHandler();
    }

    @Test
    void testDeleteMetadataPartition() {
        try (MockedStatic mockedMetadataUtils = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            List leftPartitionPaths = EightToSevenDowngradeHandler.deleteMetadataPartition((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient, SAMPLE_METADATA_PATHS);
            mockedMetadataUtils.verify(() -> HoodieTableMetadataUtil.deleteMetadataTablePartition((HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)this.context, (String)"expr_index_random", (boolean)true), Mockito.times((int)1));
            mockedMetadataUtils.verify(() -> HoodieTableMetadataUtil.deleteMetadataTablePartition((HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)this.context, (String)"secondary_index_random", (boolean)true), Mockito.times((int)1));
            mockedMetadataUtils.verify(() -> HoodieTableMetadataUtil.deleteMetadataTablePartition((HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)this.context, (String)"partition_stats", (boolean)true), Mockito.times((int)1));
            Assertions.assertArrayEquals((Object[])new String[]{"files", "column_stats"}, (Object[])leftPartitionPaths.toArray());
        }
    }

    @Test
    void testDowngradeMetadataPartitions() {
        String baseTablePath = this.baseDir.toString();
        HoodieStorage hoodieStorage = HoodieStorageUtils.getStorage((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf());
        StoragePath basePath = new StoragePath(baseTablePath);
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)basePath);
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)hoodieStorage);
        HashMap tablePropsToAdd = new HashMap();
        try (MockedStatic mockedFSUtils = Mockito.mockStatic(FSUtils.class);
             MockedStatic mockedStaticMetaClient = Mockito.mockStatic(HoodieTableMetaClient.class);){
            StoragePath mdtBasePath = HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePath());
            mockedFSUtils.when(() -> FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient, (boolean)false)).thenReturn(SAMPLE_METADATA_PATHS);
            HoodieTableMetaClient.Builder mockBuilder = (HoodieTableMetaClient.Builder)Mockito.mock(HoodieTableMetaClient.Builder.class);
            Mockito.when((Object)mockBuilder.setBasePath(mdtBasePath.toUri().toString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.setConf(hoodieStorage.getConf())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.build()).thenReturn((Object)this.metaClient);
            mockedStaticMetaClient.when(HoodieTableMetaClient::builder).thenReturn((Object)mockBuilder);
            mockedFSUtils.when(() -> FSUtils.isTableExists((String)mdtBasePath.toString(), (HoodieStorage)hoodieStorage)).thenReturn((Object)true);
            EightToSevenDowngradeHandler.downgradeMetadataPartitions((HoodieEngineContext)this.context, (HoodieStorage)hoodieStorage, (HoodieTableMetaClient)this.metaClient, tablePropsToAdd);
            Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.TABLE_METADATA_PARTITIONS));
            Assertions.assertEquals((Object)"files,column_stats", tablePropsToAdd.get(HoodieTableConfig.TABLE_METADATA_PARTITIONS));
        }
    }

    @Test
    void testPropertyDowngrade() {
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        HashMap tablePropsToAdd = new HashMap();
        Properties existingTableProps = new Properties();
        existingTableProps.put(HoodieTableConfig.INITIAL_VERSION.key(), HoodieTableVersion.SIX.name());
        existingTableProps.put(HoodieTableConfig.RECORD_MERGE_MODE.key(), RecordMergeMode.EVENT_TIME_ORDERING.name());
        existingTableProps.put(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE.key(), BootstrapIndexType.HFILE.name());
        existingTableProps.put(HoodieTableConfig.KEY_GENERATOR_TYPE.key(), KeyGeneratorType.CUSTOM.name());
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.EVENT_TIME_ORDERING);
        Mockito.when((Object)tableConfig.getProps()).thenReturn((Object)TypedProperties.copy((Properties)existingTableProps));
        Mockito.when((Object)this.config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key())).thenReturn((Object)"partition_field");
        Mockito.when((Object)tableConfig.getPartitionFieldProp()).thenReturn((Object)"partition_field");
        Mockito.when((Object)tableConfig.getKeyGeneratorClassName()).thenReturn((Object)"org.apache.hudi.keygen.CustomKeyGenerator");
        EightToSevenDowngradeHandler.downgradePartitionFields((HoodieWriteConfig)this.config, (HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.PARTITION_FIELDS));
        Assertions.assertEquals((Object)"partition_field", tablePropsToAdd.get(HoodieTableConfig.PARTITION_FIELDS));
        EightToSevenDowngradeHandler.unsetInitialVersion((HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertFalse((boolean)tableConfig.getProps().containsKey((Object)HoodieTableConfig.INITIAL_VERSION.key()));
        List propsToRemove = EightToSevenDowngradeHandler.unsetRecordMergeMode((HoodieWriteConfig)this.config, (HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)propsToRemove.contains(HoodieTableConfig.RECORD_MERGE_MODE));
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME));
        EightToSevenDowngradeHandler.downgradeBootstrapIndexType((HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertFalse((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE));
        Assertions.assertFalse((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
        EightToSevenDowngradeHandler.downgradeKeyGeneratorType((HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertFalse((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_TYPE));
        Assertions.assertFalse((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
    }

    @ParameterizedTest
    @CsvSource(value={"com.example.CustomPayload, CUSTOM, com.example.CustomPayload", ", CUSTOM, ", "org.apache.hudi.metadata.HoodieMetadataPayload, CUSTOM, org.apache.hudi.metadata.HoodieMetadataPayload", "org.apache.hudi.common.model.OverwriteWithLatestAvroPayload, COMMIT_TIME_ORDERING, org.apache.hudi.common.model.OverwriteWithLatestAvroPayload", "org.apache.hudi.common.model.DefaultHoodieRecordPayload, EVENT_TIME_ORDERING, org.apache.hudi.common.model.DefaultHoodieRecordPayload", ", EVENT_TIME_ORDERING, org.apache.hudi.common.model.DefaultHoodieRecordPayload", ", COMMIT_TIME_ORDERING, org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"})
    void testUnsetRecordMergeMode(String payloadClass, String recordMergeMode, String expectedPayloadClass) {
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        HashMap tablePropsToAdd = new HashMap();
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)payloadClass);
        if (StringUtils.isNullOrEmpty((String)payloadClass)) {
            Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.valueOf((String)recordMergeMode));
        }
        if (!StringUtils.isNullOrEmpty((String)recordMergeMode) && recordMergeMode.equals("CUSTOM") && StringUtils.isNullOrEmpty((String)payloadClass)) {
            Assertions.assertThrows(HoodieUpgradeDowngradeException.class, () -> EightToSevenDowngradeHandler.unsetRecordMergeMode((HoodieWriteConfig)this.config, (HoodieTableConfig)tableConfig, (Map)tablePropsToAdd));
        } else {
            List propsToRemove = EightToSevenDowngradeHandler.unsetRecordMergeMode((HoodieWriteConfig)this.config, (HoodieTableConfig)tableConfig, tablePropsToAdd);
            Assertions.assertTrue((boolean)propsToRemove.stream().anyMatch(cfg -> cfg.key().equals(HoodieTableConfig.RECORD_MERGE_MODE.key())));
            Assertions.assertTrue((!tablePropsToAdd.containsKey(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID) ? 1 : 0) != 0);
            if (!StringUtils.isNullOrEmpty((String)payloadClass)) {
                Assertions.assertFalse((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            } else {
                Assertions.assertEquals((Object)expectedPayloadClass, tablePropsToAdd.get(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            }
        }
    }
}

