/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.upgrade.SevenToEightUpgradeHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestSevenToEightUpgradeHandler {
    @Mock
    private HoodieWriteConfig config;
    @Mock
    private HoodieTableConfig tableConfig;
    private SevenToEightUpgradeHandler upgradeHandler;

    TestSevenToEightUpgradeHandler() {
    }

    @BeforeEach
    void setUp() {
        this.upgradeHandler = new SevenToEightUpgradeHandler();
    }

    @Test
    void testPropertyUpgrade() {
        HashMap tablePropsToAdd = new HashMap();
        Mockito.when((Object)this.config.getString(ArgumentMatchers.anyString())).thenAnswer(i -> {
            Object arg0 = i.getArguments()[0];
            if (arg0.equals(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key())) {
                return "partition_field";
            }
            if (arg0.equals(HoodieWriteConfig.RECORD_MERGE_MODE.key())) {
                return RecordMergeMode.EVENT_TIME_ORDERING.name();
            }
            return null;
        });
        Mockito.when((Object)this.tableConfig.getKeyGeneratorClassName()).thenReturn((Object)"org.apache.hudi.keygen.CustomKeyGenerator");
        SevenToEightUpgradeHandler.upgradePartitionFields((HoodieWriteConfig)this.config, (HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertEquals((Object)"partition_field", tablePropsToAdd.get(HoodieTableConfig.PARTITION_FIELDS));
        SevenToEightUpgradeHandler.setInitialVersion((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertEquals((Object)"6", tablePropsToAdd.get(HoodieTableConfig.INITIAL_VERSION));
        Mockito.when((Object)this.tableConfig.contains((ConfigProperty)Mockito.isA(ConfigProperty.class))).thenAnswer(i -> i.getArguments()[0].equals(HoodieTableConfig.PAYLOAD_CLASS_NAME));
        Mockito.when((Object)this.tableConfig.getPayloadClass()).thenReturn((Object)OverwriteWithLatestAvroPayload.class.getName());
        Mockito.when((Object)this.tableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.empty());
        SevenToEightUpgradeHandler.upgradeMergeMode((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.RECORD_MERGE_MODE));
        Assertions.assertNotNull(tablePropsToAdd.get(HoodieTableConfig.RECORD_MERGE_MODE));
        Mockito.when((Object)this.tableConfig.getBooleanOrDefault(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tableConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)).thenReturn((Object)HFileBootstrapIndex.class.getName());
        SevenToEightUpgradeHandler.upgradeBootstrapIndexType((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE));
        SevenToEightUpgradeHandler.upgradeKeyGeneratorType((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_TYPE));
    }

    @ParameterizedTest
    @CsvSource(value={"com.example.CustomPayload, , CUSTOM, 00000000-0000-0000-0000-000000000000, com.example.CustomPayload", "com.example.CustomPayload, preCombineFieldValue, CUSTOM, 00000000-0000-0000-0000-000000000000, com.example.CustomPayload", "org.apache.hudi.metadata.HoodieMetadataPayload, , CUSTOM, 00000000-0000-0000-0000-000000000000, org.apache.hudi.metadata.HoodieMetadataPayload", "org.apache.hudi.metadata.HoodieMetadataPayload, preCombineFieldValue, CUSTOM, 00000000-0000-0000-0000-000000000000, org.apache.hudi.metadata.HoodieMetadataPayload", "org.apache.hudi.common.model.OverwriteWithLatestAvroPayload, , COMMIT_TIME_ORDERING, ce9acb64-bde0-424c-9b91-f6ebba25356d, org.apache.hudi.common.model.OverwriteWithLatestAvroPayload", "org.apache.hudi.common.model.DefaultHoodieRecordPayload, , EVENT_TIME_ORDERING, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5, org.apache.hudi.common.model.DefaultHoodieRecordPayload", ", preCombineFieldValue, EVENT_TIME_ORDERING, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5, org.apache.hudi.common.model.DefaultHoodieRecordPayload", "org.apache.hudi.common.model.OverwriteWithLatestAvroPayload, preCombineFieldValue, EVENT_TIME_ORDERING,eeb8d96f-b1e4-49fd-bbf8-28ac514178e5, org.apache.hudi.common.model.DefaultHoodieRecordPayload", ", preCombineFieldValue, EVENT_TIME_ORDERING, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5, org.apache.hudi.common.model.DefaultHoodieRecordPayload", "org.apache.hudi.common.model.DefaultHoodieRecordPayload, preCombineFieldValue, EVENT_TIME_ORDERING,eeb8d96f-b1e4-49fd-bbf8-28ac514178e5, org.apache.hudi.common.model.DefaultHoodieRecordPayload", ", , COMMIT_TIME_ORDERING, ce9acb64-bde0-424c-9b91-f6ebba25356d, org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"})
    void testUpgradeMergeMode(String payloadClass, String preCombineField, String expectedMergeMode, String expectedStrategy, String expectedPayloadClass) {
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        HashMap tablePropsToAdd = new HashMap();
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)payloadClass);
        Mockito.when((Object)tableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.ofNullable((Object)preCombineField));
        SevenToEightUpgradeHandler.upgradeMergeMode((HoodieTableConfig)tableConfig, tablePropsToAdd);
        Assertions.assertEquals((Object)expectedMergeMode, tablePropsToAdd.get(HoodieTableConfig.RECORD_MERGE_MODE));
        Assertions.assertEquals((Object)expectedStrategy, tablePropsToAdd.get(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID));
        if (expectedPayloadClass != null) {
            Assertions.assertEquals((Object)expectedPayloadClass, tablePropsToAdd.get(HoodieTableConfig.PAYLOAD_CLASS_NAME));
        } else {
            Assertions.assertTrue((!tablePropsToAdd.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME) ? 1 : 0) != 0);
        }
    }

    private static Map<ConfigProperty, String> createMap(Object ... keyValues) {
        HashMap<ConfigProperty, String> map = new HashMap<ConfigProperty, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put((ConfigProperty)keyValues[i], (String)keyValues[i + 1]);
        }
        return map;
    }
}

