/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.testutils.CheckedFunction;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.function.Executable;

public class Assertions {
    public static void assertNoWriteErrors(List<WriteStatus> statuses) {
        org.junit.jupiter.api.Assertions.assertAll(statuses.stream().map(status -> () -> org.junit.jupiter.api.Assertions.assertFalse((boolean)status.hasErrors(), (String)("Errors found in write of " + status.getFileId()))));
    }

    public static void assertFileSizesEqual(List<WriteStatus> statuses, CheckedFunction<WriteStatus, Long> fileSizeGetter) {
        org.junit.jupiter.api.Assertions.assertAll(statuses.stream().map(status -> () -> org.junit.jupiter.api.Assertions.assertEquals((Long)((Long)fileSizeGetter.apply(status)), (long)status.getStat().getFileSizeInBytes())));
    }

    public static void assertPartitionMetadataForRecords(String basePath, List<HoodieRecord> inputRecords, HoodieStorage storage) throws IOException {
        String[] partitionPathSet = (String[])inputRecords.stream().map(HoodieRecord::getPartitionPath).distinct().toArray(String[]::new);
        Assertions.assertPartitionMetadata(basePath, partitionPathSet, storage);
    }

    public static void assertPartitionMetadataForKeys(String basePath, List<HoodieKey> inputKeys, HoodieStorage storage) throws IOException {
        String[] partitionPathSet = (String[])inputKeys.stream().map(HoodieKey::getPartitionPath).distinct().toArray(String[]::new);
        Assertions.assertPartitionMetadata(basePath, partitionPathSet, storage);
    }

    public static void assertPartitionMetadata(String basePath, String[] partitionPaths, HoodieStorage storage) throws IOException {
        for (String partitionPath : partitionPaths) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodiePartitionMetadata.hasPartitionMetadata((HoodieStorage)storage, (StoragePath)new StoragePath(basePath, partitionPath)));
            HoodiePartitionMetadata pmeta = new HoodiePartitionMetadata(storage, new StoragePath(basePath, partitionPath));
            pmeta.readFromFS();
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)pmeta.getPartitionDepth());
        }
    }

    public static void assertNoDupesWithinPartition(List<HoodieRecord<IndexedRecord>> records) {
        HashMap partitionToKeys = new HashMap();
        for (HoodieRecord<IndexedRecord> r : records) {
            String key = r.getRecordKey();
            String partitionPath = r.getPartitionPath();
            if (!partitionToKeys.containsKey(partitionPath)) {
                partitionToKeys.put(partitionPath, new HashSet());
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Set)partitionToKeys.get(partitionPath)).contains(key), (String)("key " + key + " is duplicate within partition " + partitionPath));
            ((Set)partitionToKeys.get(partitionPath)).add(key);
        }
    }

    public static void assertNoDuplicatesInPartition(List<HoodieRecordDelegate> recordDelegates) {
        HashMap partitionToKeys = new HashMap();
        for (HoodieRecordDelegate r : recordDelegates) {
            String recordKey = r.getRecordKey();
            String partitionPath = r.getPartitionPath();
            if (!partitionToKeys.containsKey(partitionPath)) {
                partitionToKeys.put(partitionPath, new HashSet());
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Set)partitionToKeys.get(partitionPath)).contains(recordKey), (String)("key " + recordKey + " is duplicate within partition " + partitionPath));
            ((Set)partitionToKeys.get(partitionPath)).add(recordKey);
        }
    }

    public static void assertActualAndExpectedPartitionPathRecordKeyMatches(List<Pair<String, String>> expectedPartitionPathRecKeyPairs, List<Pair<String, String>> actualPartitionPathRecKeyPairs) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedPartitionPathRecKeyPairs.size(), (int)actualPartitionPathRecKeyPairs.size());
        for (Pair<String, String> entry : actualPartitionPathRecKeyPairs) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedPartitionPathRecKeyPairs.contains(entry));
        }
        for (Pair<String, String> entry : expectedPartitionPathRecKeyPairs) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actualPartitionPathRecKeyPairs.contains(entry));
        }
    }

    public static void assertComplexKeyGeneratorValidationThrows(Executable writeOperation, String operation) {
        HoodieException exception = (HoodieException)org.junit.jupiter.api.Assertions.assertThrows(HoodieException.class, (Executable)writeOperation);
        org.junit.jupiter.api.Assertions.assertEquals((Object)KeyGenUtils.getComplexKeygenErrorMessage((String)operation), (Object)exception.getMessage());
    }
}

