/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;

public class MetadataMergeWriteStatus
extends WriteStatus {
    private Map<String, String> mergedMetadataMap = new HashMap<String, String>();

    public MetadataMergeWriteStatus(Boolean trackSuccessRecords, Double failureFraction) {
        super(trackSuccessRecords, failureFraction);
    }

    public MetadataMergeWriteStatus(Boolean trackSuccessRecords, Double failureFraction, Boolean isMetadataTable) {
        super(trackSuccessRecords, failureFraction, isMetadataTable);
    }

    public static Map<String, String> mergeMetadataForWriteStatuses(List<WriteStatus> writeStatuses) {
        HashMap<String, String> allWriteStatusMergedMetadataMap = new HashMap<String, String>();
        for (WriteStatus writeStatus : writeStatuses) {
            MetadataMergeWriteStatus.mergeMetadataMaps(((MetadataMergeWriteStatus)writeStatus).getMergedMetadataMap(), allWriteStatusMergedMetadataMap);
        }
        return allWriteStatusMergedMetadataMap;
    }

    private static void mergeMetadataMaps(Map<String, String> mergeFromMap, Map<String, String> mergeToMap) {
        for (Map.Entry<String, String> entry : mergeFromMap.entrySet()) {
            String key = entry.getKey();
            if (!mergeToMap.containsKey(key)) {
                mergeToMap.put(key, "0");
            }
            mergeToMap.put(key, MetadataMergeWriteStatus.addStrsAsLong(entry.getValue(), mergeToMap.get(key)));
        }
    }

    private static String addStrsAsLong(String a, String b) {
        return String.valueOf(Long.parseLong(a) + Long.parseLong(b));
    }

    public void markSuccess(HoodieRecord record, Option<Map<String, String>> recordMetadata) {
        super.markSuccess(record, recordMetadata);
        if (recordMetadata.isPresent()) {
            MetadataMergeWriteStatus.mergeMetadataMaps((Map)recordMetadata.get(), this.mergedMetadataMap);
        }
    }

    public void markFailure(HoodieRecord record, Throwable t, Option<Map<String, String>> recordMetadata) {
        super.markFailure(record, t, recordMetadata);
        if (recordMetadata.isPresent()) {
            MetadataMergeWriteStatus.mergeMetadataMaps((Map)recordMetadata.get(), this.mergedMetadataMap);
        }
    }

    private Map<String, String> getMergedMetadataMap() {
        return this.mergedMetadataMap;
    }
}

