/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.stream.Stream;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.util.CommonClientUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class TestCommonClientUtils {
    TestCommonClientUtils() {
    }

    @Test
    void testDisallowPartialUpdatesPreVersion8() {
        HoodieWriteConfig wConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        HoodieTableConfig tConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)wConfig.getWriteVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)tConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)wConfig.shouldWritePartialUpdates()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieNotSupportedException.class, () -> CommonClientUtils.validateTableVersion((HoodieTableConfig)tConfig, (HoodieWriteConfig)wConfig));
    }

    @Test
    void testDisallowNBCCPreVersion8() {
        HoodieWriteConfig wConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        HoodieTableConfig tConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)wConfig.getWriteVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)tConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)wConfig.isNonBlockingConcurrencyControl()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieNotSupportedException.class, () -> CommonClientUtils.validateTableVersion((HoodieTableConfig)tConfig, (HoodieWriteConfig)wConfig));
    }

    @Test
    void testGenerateTokenOnError() {
        TaskContextSupplier taskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Mockito.when((Object)taskContextSupplier.getPartitionIdSupplier()).thenThrow(new Throwable[]{new RuntimeException("generated under testing")});
        Assertions.assertEquals((Object)"0-0-0", (Object)CommonClientUtils.generateWriteToken((TaskContextSupplier)taskContextSupplier));
    }

    @ParameterizedTest(name="Table version {0} with write version {1} should be valid: {2}")
    @MethodSource(value={"provideValidTableVersionWriteVersionPairs"})
    void testValidTableVersionWriteVersionPairs(HoodieTableVersion tableVersion, HoodieTableVersion writeVersion, boolean expectedResult) throws Exception {
        boolean result = CommonClientUtils.areTableVersionsCompatible((HoodieTableVersion)tableVersion, (HoodieTableVersion)writeVersion);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }

    private static Stream<Arguments> provideValidTableVersionWriteVersionPairs() {
        return Stream.concat(Stream.concat(TestCommonClientUtils.generateWriterGreaterThanTableCases(), TestCommonClientUtils.generateSameVersionCases()), Stream.of(Arguments.of((Object[])new Object[]{HoodieTableVersion.SEVEN, HoodieTableVersion.SIX, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.EIGHT, HoodieTableVersion.SIX, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.NINE, HoodieTableVersion.SIX, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.NINE, HoodieTableVersion.EIGHT, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.EIGHT, HoodieTableVersion.SEVEN, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.SEVEN, HoodieTableVersion.SIX, true}), Arguments.of((Object[])new Object[]{HoodieTableVersion.NINE, HoodieTableVersion.FIVE, false}), Arguments.of((Object[])new Object[]{HoodieTableVersion.EIGHT, HoodieTableVersion.FIVE, false}), Arguments.of((Object[])new Object[]{HoodieTableVersion.SEVEN, HoodieTableVersion.FIVE, false}), Arguments.of((Object[])new Object[]{HoodieTableVersion.SIX, HoodieTableVersion.FIVE, false})));
    }

    private static Stream<Arguments> generateWriterGreaterThanTableCases() {
        HoodieTableVersion[] allVersions = HoodieTableVersion.values();
        return Stream.of(allVersions).flatMap(tableVersion -> Stream.of(allVersions).filter(writeVersion -> writeVersion.greaterThan(tableVersion)).map(writeVersion -> Arguments.of((Object[])new Object[]{tableVersion, writeVersion, true})));
    }

    private static Stream<Arguments> generateSameVersionCases() {
        return Stream.of(HoodieTableVersion.values()).map(version -> Arguments.of((Object[])new Object[]{version, version, true}));
    }
}

