/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hudi.client.utils.ConcatenatingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConcatenatingIterator {
    @Test
    public void testConcatBasic() {
        Iterator<Integer> i1 = Arrays.asList(5, 3, 2, 1).iterator();
        Iterator i2 = Collections.emptyIterator();
        Iterator<Integer> i3 = Collections.singletonList(3).iterator();
        ConcatenatingIterator ci = new ConcatenatingIterator(Arrays.asList(i1, i2, i3));
        ArrayList<Object> allElements = new ArrayList<Object>();
        while (ci.hasNext()) {
            allElements.add(ci.next());
        }
        Assertions.assertEquals((int)5, (int)allElements.size());
        Assertions.assertEquals(Arrays.asList(5, 3, 2, 1, 3), allElements);
    }

    @Test
    public void testConcatError() {
        Iterator i1 = Collections.emptyIterator();
        ConcatenatingIterator ci = new ConcatenatingIterator(Collections.singletonList(i1));
        Assertions.assertFalse((boolean)ci.hasNext());
        try {
            ci.next();
            Assertions.fail((String)"expected error for empty iterator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

