/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hudi.callback.HoodieClientInitCallback;
import org.apache.hudi.client.embedded.EmbeddedTimelineServerHelper;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerators;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieClient
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieClient.class);
    private static final long serialVersionUID = 1L;
    protected final transient HoodieStorage storage;
    protected final transient HoodieEngineContext context;
    protected final transient StorageConfiguration<?> storageConf;
    protected final transient HoodieMetrics metrics;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final HoodieHeartbeatClient heartbeatClient;
    protected final TransactionManager txnManager;
    protected final TimeGenerator timeGenerator;
    private transient Option<EmbeddedTimelineService> timelineServer;
    private final boolean shouldStopTimelineServer;

    protected BaseHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, (Option<EmbeddedTimelineService>)Option.empty());
    }

    protected BaseHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineServer) {
        this(context, clientConfig, timelineServer, BaseHoodieClient.buildTransactionManager(context, clientConfig), BaseHoodieClient.buildTimeGenerator(context, clientConfig));
    }

    private static TimeGenerator buildTimeGenerator(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        return TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)clientConfig.getTimeGeneratorConfig(), (StorageConfiguration)context.getStorageConf());
    }

    private static TransactionManager buildTransactionManager(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        return new TransactionManager(clientConfig, HoodieStorageUtils.getStorage((String)clientConfig.getBasePath(), (StorageConfiguration)context.getStorageConf()));
    }

    @VisibleForTesting
    BaseHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineServer, TransactionManager transactionManager, TimeGenerator timeGenerator) {
        this.storageConf = context.getStorageConf();
        this.storage = HoodieStorageUtils.getStorage((String)clientConfig.getBasePath(), this.storageConf);
        this.context = context;
        this.basePath = clientConfig.getBasePath();
        this.config = clientConfig;
        this.timelineServer = timelineServer;
        this.shouldStopTimelineServer = !timelineServer.isPresent();
        this.heartbeatClient = new HoodieHeartbeatClient(this.storage, this.basePath, clientConfig.getHoodieClientHeartbeatIntervalInMs(), clientConfig.getHoodieClientHeartbeatTolerableMisses());
        this.metrics = new HoodieMetrics(this.config, this.storage);
        this.txnManager = transactionManager;
        this.timeGenerator = timeGenerator;
        this.startEmbeddedServerView();
        this.initWrapperFSMetrics();
        this.runClientInitCallbacks();
    }

    @Override
    public void close() {
        this.stopEmbeddedServerView(true);
        this.context.setJobStatus("", "");
        this.heartbeatClient.close();
        this.txnManager.close();
    }

    private synchronized void stopEmbeddedServerView(boolean resetViewStorageConfig) {
        if (this.timelineServer.isPresent() && this.shouldStopTimelineServer) {
            LOG.info("Stopping Timeline service !!");
            ((EmbeddedTimelineService)this.timelineServer.get()).stopForBasePath(this.basePath);
        }
        this.timelineServer = Option.empty();
        if (resetViewStorageConfig) {
            this.config.resetViewStorageConfig();
        }
    }

    private synchronized void startEmbeddedServerView() {
        if (this.config.isEmbeddedTimelineServerEnabled()) {
            if (!this.timelineServer.isPresent()) {
                try {
                    this.timelineServer = Option.of((Object)EmbeddedTimelineServerHelper.createEmbeddedTimelineService(this.context, this.config));
                }
                catch (IOException e) {
                    LOG.warn("Unable to start timeline service. Proceeding as if embedded server is disabled", (Throwable)e);
                    this.stopEmbeddedServerView(false);
                }
            } else {
                LOG.info("Timeline Server already running. Not restarting the service");
            }
        } else {
            LOG.info("Embedded Timeline Server is disabled. Not starting timeline service");
        }
    }

    private void runClientInitCallbacks() {
        String callbackClassNames = this.config.getClientInitCallbackClassNames();
        if (StringUtils.isNullOrEmpty((String)callbackClassNames)) {
            return;
        }
        Arrays.stream(callbackClassNames.split(",")).forEach(callbackClass -> {
            Object callback = ReflectionUtils.loadClass((String)callbackClass);
            if (!(callback instanceof HoodieClientInitCallback)) {
                throw new HoodieException(callbackClass + " is not a subclass of " + HoodieClientInitCallback.class.getName());
            }
            ((HoodieClientInitCallback)callback).call(this);
        });
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieEngineContext getEngineContext() {
        return this.context;
    }

    protected void initWrapperFSMetrics() {
    }

    protected HoodieTableMetaClient createMetaClient(boolean loadActiveTimelineOnLoad) {
        return HoodieTableMetaClient.builder().setConf(this.storageConf.newInstance()).setBasePath(this.config.getBasePath()).setLoadActiveTimelineOnLoad(loadActiveTimelineOnLoad).setConsistencyGuardConfig(this.config.getConsistencyGuardConfig()).setTimeGeneratorConfig(this.config.getTimeGeneratorConfig()).setFileSystemRetryConfig(this.config.getFileSystemRetryConfig()).setMetaserverConfig((Properties)this.config.getProps()).build();
    }

    public String createNewInstantTime(boolean shouldLock) {
        return TimelineUtils.generateInstantTime((boolean)shouldLock, (TimeGenerator)this.timeGenerator);
    }

    public Option<EmbeddedTimelineService> getTimelineServer() {
        return this.timelineServer;
    }

    public HoodieHeartbeatClient getHeartbeatClient() {
        return this.heartbeatClient;
    }

    protected void resolveWriteConflict(HoodieTable table, HoodieCommitMetadata metadata, Set<String> pendingInflightAndRequestedInstants) {
        Timer.Context conflictResolutionTimer = this.metrics.getConflictResolutionCtx();
        try {
            TransactionUtils.resolveWriteConflictIfAny(table, this.txnManager.getCurrentTransactionOwner(), (Option<HoodieCommitMetadata>)Option.of((Object)metadata), this.config, this.txnManager.getLastCompletedTransactionOwner(), true, pendingInflightAndRequestedInstants);
            this.metrics.emitConflictResolutionSuccessful();
        }
        catch (HoodieWriteConflictException e) {
            this.metrics.emitConflictResolutionFailed();
            throw e;
        }
        finally {
            if (conflictResolutionTimer != null) {
                conflictResolutionTimer.stop();
            }
        }
    }

    protected void finalizeWrite(HoodieTable table, String instantTime, List<HoodieWriteStat> stats) {
        try {
            Timer.Context finalizeCtx = this.metrics.getFinalizeCtx();
            table.finalizeWrite(this.context, instantTime, stats);
            if (finalizeCtx != null) {
                Option durationInMs = Option.of((Object)this.metrics.getDurationInMs(finalizeCtx.stop()));
                durationInMs.ifPresent(duration -> {
                    LOG.info("Finalize write elapsed time (milliseconds): {}", duration);
                    this.metrics.updateFinalizeWriteMetrics((long)duration, stats.size());
                });
            }
        }
        catch (HoodieIOException ioe) {
            throw new HoodieCommitException("Failed to complete commit " + instantTime + " due to finalize errors.", ioe);
        }
    }

    protected void writeTableMetadata(HoodieTable table, String instantTime, HoodieCommitMetadata metadata) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Committing to metadata table: " + this.config.getTableName());
        Option<HoodieTableMetadataWriter> metadataWriterOpt = table.getMetadataWriter(instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                metadataWriter.update(metadata, instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)((Object)e);
                }
                throw new HoodieException("Failed to update metadata", (Throwable)e);
            }
        }
    }

    protected abstract void updateColumnsToIndexWithColStats(HoodieTableMetaClient var1, List<String> var2);

    protected void executeUsingTxnManager(Option<HoodieInstant> ownerInstant, Runnable r) {
        this.txnManager.beginStateChange(ownerInstant, (Option<HoodieInstant>)Option.empty());
        try {
            r.run();
        }
        finally {
            this.txnManager.endStateChange(ownerInstant);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.txnManager;
    }

    protected boolean isStreamingWriteToMetadataEnabled(HoodieTable table) {
        return this.config.isMetadataTableEnabled() && this.config.isMetadataStreamingWritesEnabled(table.getMetaClient().getTableConfig().getTableVersion());
    }
}

