/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RunsTableService {
    public static final Logger LOG = LoggerFactory.getLogger(RunsTableService.class);

    default public boolean tableServicesEnabled(HoodieWriteConfig config) {
        boolean enabled = config.areTableServicesEnabled();
        if (!enabled) {
            LOG.warn("Table services are disabled. Set `{}` to enable.", HoodieWriteConfig.TABLE_SERVICES_ENABLED);
        }
        return enabled;
    }

    default public boolean shouldDelegateToTableServiceManager(HoodieWriteConfig config, ActionType actionType) {
        return config.getTableServiceManagerConfig().isEnabledAndActionSupported(actionType);
    }
}

