/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.client.IndexStats;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public class WriteStatus
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WriteStatus.class);
    private static final long serialVersionUID = 1L;
    private static final long RANDOM_SEED = 9038412832L;
    private final HashMap<HoodieKey, Throwable> errors = new HashMap();
    private final List<Pair<HoodieRecordDelegate, Throwable>> failedRecords = new ArrayList<Pair<HoodieRecordDelegate, Throwable>>();
    private final boolean isMetadataTable;
    private Throwable globalError = null;
    private String fileId = null;
    private String partitionPath = null;
    private HoodieWriteStat stat = null;
    private long totalRecords = 0L;
    private long totalErrorRecords = 0L;
    private final double failureFraction;
    private boolean trackSuccessRecords;
    private final transient Random random;
    private IndexStats indexStats = new IndexStats();

    public WriteStatus(Boolean trackSuccessRecords, Double failureFraction, Boolean isMetadataTable) {
        this.trackSuccessRecords = trackSuccessRecords;
        this.failureFraction = failureFraction;
        this.random = new Random(9038412832L);
        this.isMetadataTable = isMetadataTable;
    }

    public WriteStatus(Boolean trackSuccessRecords, Double failureFraction) {
        this(trackSuccessRecords, failureFraction, false);
    }

    public WriteStatus() {
        this.failureFraction = 0.0;
        this.trackSuccessRecords = false;
        this.random = null;
        this.isMetadataTable = false;
    }

    public void markSuccess(HoodieRecord record, Option<Map<String, String>> optionalRecordMetadata) {
        if (this.trackSuccessRecords) {
            this.indexStats.addHoodieRecordDelegate(HoodieRecordDelegate.fromHoodieRecord((HoodieRecord)record));
        }
        this.updateStatsForSuccess(optionalRecordMetadata);
    }

    public void manuallyTrackSuccess() {
        this.trackSuccessRecords = false;
    }

    public void addRecordDelegate(HoodieRecordDelegate recordDelegate) {
        this.indexStats.addHoodieRecordDelegate(recordDelegate);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public void markSuccess(HoodieRecordDelegate recordDelegate, Option<Map<String, String>> optionalRecordMetadata) {
        if (this.trackSuccessRecords) {
            this.indexStats.addHoodieRecordDelegate(Objects.requireNonNull(recordDelegate));
        }
        this.updateStatsForSuccess(optionalRecordMetadata);
    }

    private void updateStatsForSuccess(Option<Map<String, String>> optionalRecordMetadata) {
        ++this.totalRecords;
        String eventTimeVal = ((Map)optionalRecordMetadata.orElse(Collections.emptyMap())).getOrDefault("metadata.event_time.key", null);
        if (StringUtils.isNullOrEmpty((String)eventTimeVal)) {
            return;
        }
        try {
            long millisEventTime;
            int length = eventTimeVal.length();
            if (length == 10) {
                millisEventTime = Long.parseLong(eventTimeVal) * 1000L;
            } else if (length == 13) {
                millisEventTime = Long.parseLong(eventTimeVal);
            } else {
                throw new IllegalArgumentException("not support event_time format:" + eventTimeVal);
            }
            long eventTime = DateTimeUtils.parseDateTime((String)Long.toString(millisEventTime)).toEpochMilli();
            this.stat.setMinEventTime(Long.valueOf(eventTime));
            this.stat.setMaxEventTime(Long.valueOf(eventTime));
        }
        catch (IllegalArgumentException | DateTimeException e) {
            LOG.debug("Fail to parse event time value: {}", (Object)eventTimeVal, (Object)e);
        }
    }

    public void markFailure(HoodieRecord record, Throwable t, Option<Map<String, String>> optionalRecordMetadata) {
        if (this.failedRecords.isEmpty() || this.random.nextDouble() <= this.failureFraction) {
            this.failedRecords.add((Pair<HoodieRecordDelegate, Throwable>)Pair.of((Object)HoodieRecordDelegate.fromHoodieRecord((HoodieRecord)record), (Object)t));
            this.errors.put(record.getKey(), t);
        }
        this.updateStatsForFailure();
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public void markFailure(String recordKey, String partitionPath, Throwable t) {
        if (this.failedRecords.isEmpty() || this.random.nextDouble() <= this.failureFraction) {
            HoodieRecordDelegate recordDelegate = HoodieRecordDelegate.create((String)recordKey, (String)partitionPath);
            this.failedRecords.add((Pair<HoodieRecordDelegate, Throwable>)Pair.of((Object)recordDelegate, (Object)t));
            this.errors.put(recordDelegate.getHoodieKey(), t);
        }
        this.updateStatsForFailure();
    }

    private void updateStatsForFailure() {
        ++this.totalRecords;
        ++this.totalErrorRecords;
    }

    public WriteStatus removeMetadataStats() {
        this.indexStats = null;
        return this;
    }

    public double getFailureFraction() {
        return this.failureFraction;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public boolean hasErrors() {
        return this.totalErrorRecords > 0L;
    }

    public boolean isErrored(HoodieKey key) {
        return this.errors.containsKey(key);
    }

    public HashMap<HoodieKey, Throwable> getErrors() {
        return this.errors;
    }

    public boolean hasGlobalError() {
        return this.globalError != null;
    }

    public Throwable getGlobalError() {
        return this.globalError;
    }

    public void setGlobalError(Throwable t) {
        this.globalError = t;
    }

    public IndexStats getIndexStats() {
        return this.indexStats;
    }

    public List<HoodieRecordDelegate> getWrittenRecordDelegates() {
        return this.indexStats.getWrittenRecordDelegates();
    }

    public List<Pair<HoodieRecordDelegate, Throwable>> getFailedRecords() {
        return this.failedRecords;
    }

    public HoodieWriteStat getStat() {
        return this.stat;
    }

    public void setStat(HoodieWriteStat stat) {
        this.stat = stat;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getTotalErrorRecords() {
        return this.totalErrorRecords;
    }

    public void setTotalErrorRecords(long totalErrorRecords) {
        this.totalErrorRecords = totalErrorRecords;
    }

    public boolean isTrackingSuccessfulWrites() {
        return this.trackSuccessRecords;
    }

    public boolean isMetadataTable() {
        return this.isMetadataTable;
    }

    public String toString() {
        return "WriteStatus {isMetadataTable=" + this.isMetadataTable + ", fileId=" + this.fileId + ", writeStat=" + this.stat + ", globalError='" + this.globalError + '\'' + ", hasErrors='" + this.hasErrors() + '\'' + ", errorCount='" + this.totalErrorRecords + '\'' + ", errorPct='" + 100.0 * (double)this.totalErrorRecords / (double)this.totalRecords + '\'' + '}';
    }
}

