/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConcurrentFileWritesConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleConcurrentFileWritesConflictResolutionStrategy.class);

    @Override
    public Stream<HoodieInstant> getCandidateInstants(HoodieTableMetaClient metaClient, HoodieInstant currentInstant, Option<HoodieInstant> lastSuccessfulInstant) {
        if (metaClient.getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            return this.getCandidateInstantsV8AndAbove(metaClient, currentInstant, lastSuccessfulInstant);
        }
        return this.getCandidateInstantsPreV8(metaClient, currentInstant, lastSuccessfulInstant);
    }

    private Stream<HoodieInstant> getCandidateInstantsV8AndAbove(HoodieTableMetaClient metaClient, HoodieInstant currentInstant, Option<HoodieInstant> lastSuccessfulInstant) {
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        boolean isMoRTable = metaClient.getTableType() == HoodieTableType.MERGE_ON_READ;
        Stream completedCommitsInstantStream = activeTimeline.getCommitsTimeline().filterCompletedInstants().filter(instant -> !isMoRTable || !instant.getAction().equals("commit")).findInstantsAfter(lastSuccessfulInstant.isPresent() ? ((HoodieInstant)lastSuccessfulInstant.get()).requestedTime() : "00000000000000").getInstantsAsStream();
        Stream clusteringAndReplaceCommitInstants = activeTimeline.filterPendingReplaceOrClusteringTimeline().filter(instant -> this.isClusteringOrRecentlyRequestedInstant(activeTimeline, metaClient, currentInstant).test((HoodieInstant)instant)).getInstantsAsStream();
        return Stream.concat(completedCommitsInstantStream, clusteringAndReplaceCommitInstants);
    }

    private Stream<HoodieInstant> getCandidateInstantsPreV8(HoodieTableMetaClient metaClient, HoodieInstant currentInstant, Option<HoodieInstant> lastSuccessfulInstant) {
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Stream<HoodieInstant> completedCommitsInstantStream = SimpleConcurrentFileWritesConflictResolutionStrategy.getCommitsCompletedSinceLastCommit(lastSuccessfulInstant, activeTimeline);
        Stream compactionAndClusteringPendingTimeline = activeTimeline.filterPendingReplaceClusteringAndCompactionTimeline().filter(instant -> this.isClusteringOrRecentlyRequestedInstant(activeTimeline, metaClient, currentInstant).test((HoodieInstant)instant)).getInstantsAsStream();
        return Stream.concat(completedCommitsInstantStream, compactionAndClusteringPendingTimeline);
    }

    private static Stream<HoodieInstant> getCommitsCompletedSinceLastCommit(Option<HoodieInstant> lastSuccessfulInstant, HoodieActiveTimeline activeTimeline) {
        return activeTimeline.getCommitsTimeline().filterCompletedInstants().findInstantsAfter((String)lastSuccessfulInstant.map(HoodieInstant::requestedTime).orElse((Object)"00000000000000")).getInstantsAsStream();
    }

    private Predicate<HoodieInstant> isClusteringOrRecentlyRequestedInstant(HoodieActiveTimeline activeTimeline, HoodieTableMetaClient metaClient, HoodieInstant currentInstant) {
        return instant -> ClusteringUtils.isClusteringInstant((HoodieTimeline)activeTimeline, (HoodieInstant)instant, (InstantGenerator)metaClient.getInstantGenerator()) || !"clustering".equals(instant.getAction()) && InstantComparison.compareTimestamps((String)instant.requestedTime(), (BiPredicate)InstantComparison.GREATER_THAN, (String)currentInstant.requestedTime());
    }

    @Override
    public boolean hasConflict(ConcurrentOperation thisOperation, ConcurrentOperation otherOperation) {
        Set<Pair<String, String>> partitionAndFileIdsSetForFirstInstant = thisOperation.getMutatedPartitionAndFileIds();
        Set<Pair<String, String>> partitionAndFileIdsSetForSecondInstant = otherOperation.getMutatedPartitionAndFileIds();
        HashSet<Pair<String, String>> intersection = new HashSet<Pair<String, String>>(partitionAndFileIdsSetForFirstInstant);
        intersection.retainAll(partitionAndFileIdsSetForSecondInstant);
        if (!intersection.isEmpty()) {
            LOG.info("Found conflicting writes between first operation = " + thisOperation + ", second operation = " + otherOperation + " , intersecting file ids " + intersection);
            return true;
        }
        return false;
    }

    @Override
    public Option<HoodieCommitMetadata> resolveConflict(HoodieTable table, ConcurrentOperation thisOperation, ConcurrentOperation otherOperation) {
        if (otherOperation.getOperationType() == WriteOperationType.COMPACT ? InstantComparison.compareTimestamps((String)otherOperation.getInstantTimestamp(), (BiPredicate)InstantComparison.LESSER_THAN, (String)thisOperation.getInstantTimestamp()) : "logcompaction".equals(thisOperation.getInstantActionType())) {
            return thisOperation.getCommitMetadataOption();
        }
        throw new HoodieWriteConflictException((Throwable)new ConcurrentModificationException("Cannot resolve conflicts for overlapping writes between first operation = " + thisOperation + ", second operation = " + otherOperation));
    }

    @Override
    public boolean isPreCommitRequired() {
        return false;
    }
}

