/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaComparatorForSchemaEvolution;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.transaction.ConcurrentSchemaEvolutionTableSchemaGetter;
import org.apache.hudi.client.transaction.SchemaConflictResolutionStrategy;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSchemaConflictResolutionStrategy
implements SchemaConflictResolutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSchemaConflictResolutionStrategy.class);

    @Override
    public Option<Schema> resolveConcurrentSchemaEvolution(HoodieTable table, HoodieWriteConfig config, Option<HoodieInstant> lastCompletedTxnOwnerInstant, Option<HoodieInstant> currTxnOwnerInstant) {
        Option<Schema> tableSchemaAtTxnStart;
        if (!currTxnOwnerInstant.isPresent() || ((HoodieInstant)currTxnOwnerInstant.get()).getAction().equals("compaction") || ClusteringUtils.isClusteringInstant((HoodieTimeline)table.getMetaClient().getActiveTimeline(), (HoodieInstant)((HoodieInstant)currTxnOwnerInstant.get()), (InstantGenerator)table.getMetaClient().getInstantGenerator())) {
            return Option.empty();
        }
        if (StringUtils.isNullOrEmpty((String)config.getWriteSchema())) {
            LOG.warn("Writer config does not come with a valid writer schema. Writer config: {}. Owner instant: {}", (Object)config, (Object)((HoodieInstant)currTxnOwnerInstant.get()).toString());
            return Option.empty();
        }
        Schema writerSchemaOfTxn = new Schema.Parser().parse(config.getWriteSchema());
        ConcurrentSchemaEvolutionTableSchemaGetter schemaResolver = new ConcurrentSchemaEvolutionTableSchemaGetter(table.getMetaClient());
        if (HoodieAvroUtils.isSchemaNull((Schema)writerSchemaOfTxn)) {
            return SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, (HoodieInstant)currTxnOwnerInstant.get());
        }
        HoodieInstant lastCompletedInstantAtTxnStart = lastCompletedTxnOwnerInstant.isPresent() ? (HoodieInstant)this.getInstantInTimelineImmediatelyPriorToTimestamp(((HoodieInstant)lastCompletedTxnOwnerInstant.get()).getCompletionTime(), schemaResolver.computeSchemaEvolutionTimelineInReverseOrder()).orElse(null) : null;
        HoodieInstant lastCompletedInstantAtTxnValidation = schemaResolver.computeSchemaEvolutionTimelineInReverseOrder().findFirst().orElse(null);
        if (lastCompletedInstantAtTxnValidation == null) {
            return Option.of((Object)writerSchemaOfTxn);
        }
        if (lastCompletedInstantAtTxnValidation.equals((Object)lastCompletedInstantAtTxnStart)) {
            return Option.of((Object)writerSchemaOfTxn);
        }
        Option<Schema> tableSchemaAtTxnValidation = SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, lastCompletedInstantAtTxnValidation);
        if (!tableSchemaAtTxnValidation.isPresent()) {
            return Option.of((Object)writerSchemaOfTxn);
        }
        boolean writerSchemaIsCurrentTableSchema = AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)writerSchemaOfTxn, (Schema)((Schema)tableSchemaAtTxnValidation.get()));
        if (writerSchemaIsCurrentTableSchema) {
            return Option.of((Object)writerSchemaOfTxn);
        }
        if (lastCompletedInstantAtTxnStart == null) {
            SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException((Option<Schema>)Option.empty(), tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        }
        if (!(tableSchemaAtTxnStart = SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, lastCompletedInstantAtTxnStart)).isPresent()) {
            SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException((Option<Schema>)Option.empty(), tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        }
        if (AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)((Schema)tableSchemaAtTxnStart.get()), (Schema)((Schema)tableSchemaAtTxnValidation.get()))) {
            return Option.of((Object)writerSchemaOfTxn);
        }
        if (AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)writerSchemaOfTxn, (Schema)((Schema)tableSchemaAtTxnStart.get()))) {
            return tableSchemaAtTxnValidation;
        }
        SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException(tableSchemaAtTxnStart, tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        return Option.empty();
    }

    private Option<HoodieInstant> getInstantInTimelineImmediatelyPriorToTimestamp(String timestamp, Stream<HoodieInstant> reverseOrderTimeline) {
        return Option.fromJavaOptional(reverseOrderTimeline.filter(s -> InstantComparison.compareTimestamps((String)s.getCompletionTime(), (BiPredicate)InstantComparison.LESSER_THAN_OR_EQUALS, (String)timestamp)).findFirst());
    }

    private static Option<Schema> getTableSchemaAtInstant(ConcurrentSchemaEvolutionTableSchemaGetter schemaResolver, HoodieInstant instant) {
        try {
            return schemaResolver.getTableAvroSchemaIfPresent(false, (Option<HoodieInstant>)Option.of((Object)instant));
        }
        catch (Exception ex) {
            LOG.error("Cannot get table schema for instant {}", (Object)instant);
            throw new HoodieException("Unable to get table schema", (Throwable)ex);
        }
    }
}

